/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.usageView.UsageTreeColors;
import com.intellij.usageView.UsageTreeColorsScheme;
import com.intellij.usages.TextChunk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChunkExtractor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.usages.ChunkExtractor");
    private final PsiElement myElement;
    private final Document myDocument;
    private final int myLineNumber;
    private final int myColumnNumber;
    private final List<RangeMarker> myRangeMarkers;
    private final EditorColorsScheme myColorsScheme;

    public ChunkExtractor(PsiElement element, List<RangeMarker> rangeMarkers) {
        this.myElement = element;
        this.myRangeMarkers = new ArrayList<RangeMarker>(rangeMarkers.size());
        for (RangeMarker rangeMarker : rangeMarkers) {
            if (!rangeMarker.isValid()) continue;
            this.myRangeMarkers.add(rangeMarker);
        }
        Collections.sort(this.myRangeMarkers, RangeMarker.BY_START_OFFSET);
        this.myColorsScheme = UsageTreeColorsScheme.getInstance().getScheme();
        int absoluteStartOffset = ChunkExtractor.getStartOffset(this.myRangeMarkers);
        assert (absoluteStartOffset != -1);
        this.myDocument = PsiDocumentManager.getInstance(this.myElement.getProject()).getDocument(this.myElement.getContainingFile());
        this.myLineNumber = this.myDocument.getLineNumber(absoluteStartOffset);
        this.myColumnNumber = absoluteStartOffset - this.myDocument.getLineStartOffset(this.myLineNumber);
    }

    public static int getStartOffset(List<RangeMarker> rangeMarkers) {
        LOG.assertTrue(!rangeMarkers.isEmpty());
        int minStart = Integer.MAX_VALUE;
        for (RangeMarker rangeMarker : rangeMarkers) {
            int startOffset;
            if (!rangeMarker.isValid() || (startOffset = rangeMarker.getStartOffset()) >= minStart) continue;
            minStart = startOffset;
        }
        return minStart == Integer.MAX_VALUE ? -1 : minStart;
    }

    public TextChunk[] extractChunks() {
        int lineEndOffset;
        int lineStartOffset = this.myDocument.getLineStartOffset(this.myLineNumber);
        int n = lineEndOffset = lineStartOffset < this.myDocument.getTextLength() ? this.myDocument.getLineEndOffset(this.myLineNumber) : 0;
        if (lineStartOffset > lineEndOffset) {
            return new TextChunk[0];
        }
        FileType fileType = this.myElement.getContainingFile().getFileType();
        SyntaxHighlighter highlighter = SyntaxHighlighter.PROVIDER.create(fileType, this.myElement.getProject(), this.myElement.getContainingFile().getVirtualFile());
        if (highlighter == null) {
            highlighter = new PlainSyntaxHighlighter();
        }
        return this.createTextChunks(this.myDocument.getCharsSequence(), highlighter, lineStartOffset, lineEndOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextChunk[] createTextChunks(CharSequence chars, SyntaxHighlighter highlighter, int start, int end) {
        LOG.assertTrue(start <= end);
        ArrayList<TextChunk> result = new ArrayList<TextChunk>();
        this.appendPrefix(result);
        Lexer lexer = highlighter.getHighlightingLexer();
        lexer.start(chars);
        int i = StringUtil.indexOf((CharSequence)chars, (char)'\n', (int)start, (int)end);
        if (i != -1) {
            end = i;
        }
        boolean isBeginning = true;
        while (lexer.getTokenType() != null) {
            try {
                int hiStart = lexer.getTokenStart();
                int hiEnd = lexer.getTokenEnd();
                if (hiStart >= end) break;
                if ((hiStart = Math.max(hiStart, start)) >= (hiEnd = Math.min(hiEnd, end))) continue;
                String text = ((Object)chars.subSequence(hiStart, hiEnd)).toString();
                if (isBeginning && text.trim().length() == 0) continue;
                isBeginning = false;
                IElementType tokenType = lexer.getTokenType();
                TextAttributesKey[] tokenHighlights = highlighter.getTokenHighlights(tokenType);
                this.processIntersectingRange(chars, hiStart, hiEnd, tokenHighlights, result);
            }
            finally {
                lexer.advance();
            }
        }
        return result.toArray(new TextChunk[result.size()]);
    }

    private void processIntersectingRange(CharSequence chars, int hiStart, int hiEnd, TextAttributesKey[] tokenHighlights, List<TextChunk> result) {
        TextAttributes originalAttrs = this.convertAttributes(tokenHighlights);
        int lastOffset = hiStart;
        for (RangeMarker rangeMarker : this.myRangeMarkers) {
            int usageStart = rangeMarker.getStartOffset();
            int usageEnd = rangeMarker.getEndOffset();
            if (!rangeMarker.isValid() || !ChunkExtractor.rangeIntersect(lastOffset, hiEnd, usageStart, usageEnd)) continue;
            ChunkExtractor.addChunk(chars, lastOffset, Math.max(lastOffset, usageStart), originalAttrs, false, result);
            ChunkExtractor.addChunk(chars, Math.max(lastOffset, usageStart), Math.min(hiEnd, usageEnd), originalAttrs, true, result);
            if (usageEnd > hiEnd) {
                return;
            }
            lastOffset = usageEnd;
        }
        if (lastOffset < hiEnd) {
            ChunkExtractor.addChunk(chars, lastOffset, hiEnd, originalAttrs, false, result);
        }
    }

    private static void addChunk(CharSequence chars, int start, int end, TextAttributes originalAttrs, boolean bold, List<TextChunk> result) {
        if (start >= end) {
            return;
        }
        TextAttributes attrs = bold ? TextAttributes.merge(originalAttrs, new TextAttributes(null, null, null, null, 1)) : originalAttrs;
        result.add(new TextChunk(attrs, new String(((Object)chars.subSequence(start, end)).toString())));
    }

    private static boolean rangeIntersect(int s1, int e1, int s2, int e2) {
        return s2 < s1 && s1 < e2 || s2 < e1 && e1 < e2 || s1 < s2 && s2 < e1 || s1 < e2 && e2 < e1 || s1 == s2 && e1 == e2;
    }

    private TextAttributes convertAttributes(TextAttributesKey[] keys) {
        TextAttributes attrs = this.myColorsScheme.getAttributes(HighlighterColors.TEXT);
        for (TextAttributesKey key : keys) {
            TextAttributes attrs2 = this.myColorsScheme.getAttributes(key);
            if (attrs2 == null) continue;
            attrs = TextAttributes.merge(attrs, attrs2);
        }
        attrs = attrs.clone();
        attrs.setFontType(0);
        return attrs;
    }

    private void appendPrefix(List<TextChunk> result) {
        StringBuilder buffer = new StringBuilder("(");
        buffer.append(this.myLineNumber + 1);
        buffer.append(", ");
        buffer.append(this.myColumnNumber + 1);
        buffer.append(") ");
        TextChunk prefixChunk = new TextChunk(this.myColorsScheme.getAttributes(UsageTreeColors.USAGE_LOCATION), buffer.toString());
        result.add(prefixChunk);
    }
}

