/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usageView;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageInfo {
    public static final UsageInfo[] EMPTY_ARRAY = new UsageInfo[0];
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.usageView.UsageInfo");
    private final SmartPsiElementPointer mySmartPointer;
    private final VirtualFile myVirtualFile;
    public final int startOffset;
    public final int endOffset;
    public final boolean isNonCodeUsage;

    public UsageInfo(@NotNull PsiElement element, int startOffset, int endOffset, boolean isNonCodeUsage) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usageView/UsageInfo.<init> must not be null");
        }
        LOG.assertTrue(element.isValid());
        LOG.assertTrue(element == element.getNavigationElement());
        this.mySmartPointer = SmartPointerManager.getInstance(element.getProject()).createSmartPsiElementPointer(element);
        this.myVirtualFile = element.getContainingFile().getVirtualFile();
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.isNonCodeUsage = isNonCodeUsage;
        LOG.assertTrue(startOffset >= 0, (Object)startOffset);
        LOG.assertTrue(endOffset >= startOffset, (Object)(endOffset - startOffset));
    }

    public UsageInfo(@NotNull PsiElement element, boolean isNonCodeUsage) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usageView/UsageInfo.<init> must not be null");
        }
        LOG.assertTrue(element.isValid());
        element = element.getNavigationElement();
        this.mySmartPointer = SmartPointerManager.getInstance(element.getProject()).createSmartPsiElementPointer(element);
        this.myVirtualFile = element.getContainingFile().getVirtualFile();
        TextRange range = element.getTextRange();
        if (range == null) {
            LOG.error("text range null for " + element + "; " + element.getClass());
        }
        this.startOffset = element.getTextOffset() - range.getStartOffset();
        this.endOffset = range.getEndOffset() - range.getStartOffset();
        this.isNonCodeUsage = isNonCodeUsage;
        LOG.assertTrue(this.startOffset >= 0, (Object)this.startOffset);
        LOG.assertTrue(this.endOffset >= this.startOffset, (Object)(this.endOffset - this.startOffset));
    }

    public UsageInfo(@NotNull PsiElement element, int startOffset, int endOffset) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usageView/UsageInfo.<init> must not be null");
        }
        this(element, startOffset, endOffset, false);
    }

    public UsageInfo(@NotNull PsiReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usageView/UsageInfo.<init> must not be null");
        }
        this(reference.getElement(), reference.getRangeInElement().getStartOffset(), reference.getRangeInElement().getEndOffset());
    }

    public UsageInfo(@NotNull PsiQualifiedReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usageView/UsageInfo.<init> must not be null");
        }
        this((PsiElement)reference);
    }

    public UsageInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usageView/UsageInfo.<init> must not be null");
        }
        this(element, false);
    }

    @Nullable
    public PsiElement getElement() {
        return this.mySmartPointer.getElement();
    }

    @Nullable
    public PsiReference getReference() {
        return this.getElement().getReference();
    }

    public TextRange getRange() {
        return new TextRange(this.startOffset, this.endOffset);
    }

    public String getTooltipText() {
        return null;
    }

    public final void navigateTo(boolean requestFocus) {
        PsiElement element = this.getElement();
        if (element == null) {
            return;
        }
        VirtualFile file = element.getContainingFile().getVirtualFile();
        TextRange range = element.getTextRange();
        int offset = range.getStartOffset() + this.startOffset;
        Project project = element.getProject();
        FileEditorManager.getInstance(project).openTextEditor(new OpenFileDescriptor(project, file, offset), requestFocus);
    }

    public Project getProject() {
        return this.mySmartPointer.getProject();
    }

    public final boolean isWritable() {
        PsiElement element = this.getElement();
        return element == null || element.isWritable();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        UsageInfo usageInfo = (UsageInfo)o;
        if (this.endOffset != usageInfo.endOffset) {
            return false;
        }
        if (this.isNonCodeUsage != usageInfo.isNonCodeUsage) {
            return false;
        }
        if (this.startOffset != usageInfo.startOffset) {
            return false;
        }
        Object thisElement = this.mySmartPointer.getElement();
        Object thatElement = usageInfo.mySmartPointer.getElement();
        return Comparing.equal(thisElement, thatElement);
    }

    public int hashCode() {
        int result = this.mySmartPointer != null ? this.mySmartPointer.hashCode() : 0;
        result = 29 * result + this.startOffset;
        result = 29 * result + this.endOffset;
        result = 29 * result + (this.isNonCodeUsage ? 1 : 0);
        return result;
    }

    @Nullable
    public PsiFile getFile() {
        return this.mySmartPointer.getContainingFile();
    }

    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }
}

