/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Transform;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.openapi.wm.impl.content.GraphicsConfig;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.JBTabsPresentation;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.ui.tabs.impl.DragHelper;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.ShapeTransform;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabLayout;
import com.intellij.ui.tabs.impl.TabsBorder;
import com.intellij.ui.tabs.impl.singleRow.SingleRowLayout;
import com.intellij.ui.tabs.impl.singleRow.SingleRowPassInfo;
import com.intellij.ui.tabs.impl.table.TableLayout;
import com.intellij.ui.tabs.impl.table.TablePassInfo;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.LazyUiDisposable;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBTabsImpl
extends JComponent
implements JBTabs,
PropertyChangeListener,
TimerListener,
DataProvider,
PopupMenuListener,
Disposable,
JBTabsPresentation,
Queryable {
    static DataKey<JBTabsImpl> NAVIGATION_ACTIONS_KEY = DataKey.create("JBTabs");
    ActionManager myActionManager;
    public final List<TabInfo> myVisibleInfos;
    private final Map<TabInfo, Integer> myHiddenInfos;
    private TabInfo mySelectedInfo;
    public final Map<TabInfo, TabLabel> myInfo2Label;
    public final Map<TabInfo, Toolbar> myInfo2Toolbar;
    public Dimension myHeaderFitSize;
    private Insets myInnerInsets;
    private final List<EventListener> myTabMouseListeners;
    private final List<TabsListener> myTabListeners;
    public boolean myFocused;
    private Getter<ActionGroup> myPopupGroup;
    private String myPopupPlace;
    TabInfo myPopupInfo;
    DefaultActionGroup myNavigationActions;
    PopupMenuListener myPopupListener;
    JPopupMenu myActivePopup;
    public boolean myHorizontalSide;
    private boolean myStealthTabMode;
    private DataProvider myDataProvider;
    private final WeakHashMap<Component, Component> myDeferredToRemove;
    private final SingleRowLayout mySingleRowLayout;
    private final TableLayout myTableLayout;
    private TabLayout myLayout;
    LayoutPassInfo myLastLayoutPass;
    private TabInfo myLastPaintedSelection;
    public boolean myForcedRelayout;
    private UiDecorator myUiDecorator;
    static final UiDecorator ourDefaultDecorator = new DefautDecorator();
    private boolean myPaintFocus;
    private boolean myHideTabs;
    @Nullable
    private Project myProject;
    private boolean myRequestFocusOnLastFocusedComponent;
    private boolean myListenerAdded;
    final Set<TabInfo> myAttractions;
    private Animator myAnimator;
    private List<TabInfo> myAllTabs;
    private boolean myPaintBlocked;
    private BufferedImage myImage;
    private IdeFocusManager myFocusManager;
    private boolean myAdjustBorders;
    boolean myAddNavigationGroup;
    private boolean myGhostsAlwaysVisible;
    private boolean myDisposed;
    private boolean myToDrawBorderIfTabsHidden;
    private Color myActiveTabFillIn;
    private boolean myTabLabelActionsAutoHide;
    private final TabActionsAutoHideListener myTabActionsAutoHideListener;
    private IdeGlassPane myGlassPane;
    @NonNls
    private static final String LAYOUT_DONE = "Layout.done";
    private TimedDeadzone.Length myTabActionsMouseDeadzone;
    private long myRemoveDefferredRequest;
    private boolean myTestMode;
    private JBTabsPosition myPosition;
    private final TabsBorder myBorder;
    private BaseNavigationAction myNextAction;
    private BaseNavigationAction myPrevAction;
    private boolean myWasEverShown;
    private boolean myTabDraggingEnabled;
    private DragHelper myDragHelper;
    private boolean myNavigationActionsEnabled;
    private boolean myUseBufferedPaint;

    public JBTabsImpl(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/impl/JBTabsImpl.<init> must not be null");
        }
        this(project, project);
    }

    public JBTabsImpl(@NotNull Project project, @NotNull Disposable parent) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/impl/JBTabsImpl.<init> must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/tabs/impl/JBTabsImpl.<init> must not be null");
        }
        this(project, ActionManager.getInstance(), IdeFocusManager.getInstance(project), parent);
    }

    public JBTabsImpl(@Nullable Project project, IdeFocusManager focusManager, @NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/ui/tabs/impl/JBTabsImpl.<init> must not be null");
        }
        this(project, ActionManager.getInstance(), focusManager, parent);
    }

    public JBTabsImpl(@Nullable Project project, ActionManager actionManager, IdeFocusManager focusManager, @NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/ui/tabs/impl/JBTabsImpl.<init> must not be null");
        }
        this.myVisibleInfos = new ArrayList<TabInfo>();
        this.myHiddenInfos = new HashMap<TabInfo, Integer>();
        this.myInfo2Label = new HashMap<TabInfo, TabLabel>();
        this.myInfo2Toolbar = new HashMap<TabInfo, Toolbar>();
        this.myInnerInsets = new Insets(0, 0, 0, 0);
        this.myTabMouseListeners = new ArrayList<EventListener>();
        this.myTabListeners = new ArrayList<TabsListener>();
        this.myHorizontalSide = true;
        this.myStealthTabMode = false;
        this.myDeferredToRemove = new WeakHashMap();
        this.mySingleRowLayout = new SingleRowLayout(this);
        this.myTableLayout = new TableLayout(this);
        this.myLayout = this.mySingleRowLayout;
        this.myHideTabs = false;
        this.myRequestFocusOnLastFocusedComponent = false;
        this.myAttractions = new HashSet<TabInfo>();
        this.myAdjustBorders = true;
        this.myAddNavigationGroup = true;
        this.myGhostsAlwaysVisible = false;
        this.myToDrawBorderIfTabsHidden = true;
        this.myTabActionsAutoHideListener = new TabActionsAutoHideListener();
        this.myTabActionsMouseDeadzone = TimedDeadzone.DEFAULT;
        this.myPosition = JBTabsPosition.top;
        this.myBorder = new TabsBorder(this);
        this.myNavigationActionsEnabled = true;
        this.myUseBufferedPaint = true;
        this.myProject = project;
        this.myActionManager = actionManager;
        this.myFocusManager = focusManager != null ? focusManager : IdeFocusManager.getGlobalInstance();
        this.setOpaque(true);
        this.setPaintBorder(-1, -1, -1, -1);
        Disposer.register((Disposable)parent, (Disposable)this);
        this.myNavigationActions = new DefaultActionGroup();
        if (this.myActionManager != null) {
            this.myNextAction = new SelectNextAction(this, this.myActionManager);
            this.myPrevAction = new SelectPreviousAction(this, this.myActionManager);
            this.myNavigationActions.add(this.myNextAction);
            this.myNavigationActions.add(this.myPrevAction);
        }
        this.setUiDecorator(null);
        this.myPopupListener = new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                JBTabsImpl.this.disposePopupListener();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                JBTabsImpl.this.disposePopupListener();
            }
        };
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myLastSingRowLayout != null && ((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myLastSingRowLayout.moreRect != null && ((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myLastSingRowLayout.moreRect.contains(e.getPoint())) {
                    JBTabsImpl.this.showMorePopup(e);
                }
            }
        });
        this.myAnimator = new Animator("JBTabs Attractions", 2, 500, true, 0, -1){

            @Override
            public void paintNow(float frame, float totalFrames, float cycle) {
                JBTabsImpl.this.repaintAttractions();
            }
        };
        this.myAnimator.setTakInitialDelay(false);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            @Override
            public Component getDefaultComponent(Container aContainer) {
                return JBTabsImpl.this.getToFocus();
            }
        });
        this.add(this.mySingleRowLayout.myLeftGhost);
        this.add(this.mySingleRowLayout.myRightGhost);
        new LazyUiDisposable<JBTabsImpl>(parent, (JComponent)this, this, project){

            @Override
            protected void initialize(@NotNull Disposable parent, @NotNull JBTabsImpl child, @Nullable Project project) {
                if (parent == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/impl/JBTabsImpl$5.initialize must not be null");
                }
                if (child == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/tabs/impl/JBTabsImpl$5.initialize must not be null");
                }
                JBTabsImpl.this.myProject = project;
                Disposer.register((Disposable)child, (Disposable)JBTabsImpl.this.myAnimator);
                Disposer.register((Disposable)child, (Disposable)new Disposable(){

                    public void dispose() {
                        JBTabsImpl.this.removeTimerUpdate();
                    }
                });
                if (!JBTabsImpl.this.myTestMode) {
                    IdeGlassPane gp = IdeGlassPaneUtil.find(child);
                    if (gp != null) {
                        gp.addMouseMotionPreprocessor(JBTabsImpl.this.myTabActionsAutoHideListener, child);
                        JBTabsImpl.this.myGlassPane = gp;
                    }
                    UIUtil.addAwtListener((AWTEventListener)new AWTEventListener(){

                        @Override
                        public void eventDispatched(AWTEvent event) {
                            if (((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myMorePopup != null) {
                                return;
                            }
                            JBTabsImpl.this.processFocusChange();
                        }
                    }, (long)4L, (Disposable)child);
                    JBTabsImpl.this.myDragHelper = new DragHelper(child);
                    JBTabsImpl.this.myDragHelper.start();
                }
                if (JBTabsImpl.this.myProject != null && JBTabsImpl.this.myFocusManager == IdeFocusManager.getGlobalInstance()) {
                    JBTabsImpl.this.myFocusManager = IdeFocusManager.getInstance(JBTabsImpl.this.myProject);
                }
            }
        };
    }

    @Override
    public JBTabs setNavigationActiondBinding(String prevActionId, String nextActionId) {
        if (this.myNextAction != null) {
            this.myNextAction.reconnect(nextActionId);
        }
        if (this.myPrevAction != null) {
            this.myPrevAction.reconnect(prevActionId);
        }
        return this;
    }

    @Override
    public JBTabs setNavigationActionsEnabled(boolean enabled) {
        this.myNavigationActionsEnabled = enabled;
        return this;
    }

    @Override
    public final boolean isDisposed() {
        return this.myDisposed;
    }

    public void dispose() {
        this.myDisposed = true;
        this.mySelectedInfo = null;
        this.resetTabsCache();
        this.myAttractions.clear();
        this.myVisibleInfos.clear();
        this.myUiDecorator = null;
        this.myImage = null;
        this.myActivePopup = null;
        this.myInfo2Label.clear();
        this.myInfo2Toolbar.clear();
        this.myTabListeners.clear();
    }

    void resetTabsCache() {
        this.myAllTabs = null;
    }

    private void processFocusChange() {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (owner == null) {
            this.setFocused(false);
            return;
        }
        if (owner == this || SwingUtilities.isDescendingFrom(owner, this)) {
            this.setFocused(true);
        } else {
            this.setFocused(false);
        }
    }

    private void repaintAttractions() {
        boolean needsUpdate = false;
        for (TabInfo each : this.myVisibleInfos) {
            TabLabel eachLabel = this.myInfo2Label.get(each);
            needsUpdate |= eachLabel.repaintAttraction();
        }
        if (needsUpdate) {
            this.relayout(true, false);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addTimerUpdate();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.setFocused(false);
        this.removeTimerUpdate();
        if (this.myGlassPane != null) {
            this.myGlassPane.removeMouseMotionPreprocessor(this.myTabActionsAutoHideListener);
            this.myGlassPane = null;
        }
    }

    private void addTimerUpdate() {
        if (this.myActionManager != null && !this.myListenerAdded) {
            this.myActionManager.addTimerListener(500, this);
            this.myListenerAdded = true;
        }
    }

    private void removeTimerUpdate() {
        if (this.myActionManager != null && this.myListenerAdded) {
            this.myActionManager.removeTimerListener(this);
            this.myListenerAdded = false;
        }
    }

    void setTestMode(boolean testMode) {
        this.myTestMode = testMode;
    }

    public void layoutComp(SingleRowPassInfo data, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
        if (data.hToolbar != null) {
            int toolbarHeight = data.hToolbar.getPreferredSize().height;
            Rectangle compRect = this.layoutComp(deltaX, toolbarHeight + deltaY, data.comp, deltaWidth, deltaHeight);
            JBTabsImpl.layout(data.hToolbar, compRect.x, compRect.y - toolbarHeight, compRect.width, toolbarHeight);
        } else if (data.vToolbar != null) {
            int toolbarWidth = data.vToolbar.getPreferredSize().width;
            Rectangle compRect = this.layoutComp(toolbarWidth + deltaX, deltaY, data.comp, deltaWidth, deltaHeight);
            JBTabsImpl.layout(data.vToolbar, compRect.x - toolbarWidth, compRect.y, toolbarWidth, compRect.height);
        } else {
            this.layoutComp(deltaX, deltaY, data.comp, deltaWidth, deltaHeight);
        }
    }

    @Override
    public ModalityState getModalityState() {
        return ModalityState.stateForComponent(this);
    }

    @Override
    public void run() {
        this.updateTabActions(false);
    }

    @Override
    public void updateTabActions(boolean validateNow) {
        final Ref changed = new Ref((Object)Boolean.FALSE);
        for (final TabInfo eachInfo : this.myInfo2Label.keySet()) {
            this.updateTab(new Computable<Boolean>(){

                public Boolean compute() {
                    boolean changes = JBTabsImpl.this.myInfo2Label.get(eachInfo).updateTabActions();
                    changed.set((Object)((Boolean)changed.get() != false || changes ? 1 : 0));
                    return changes;
                }
            }, eachInfo);
        }
        if (((Boolean)changed.get()).booleanValue() && validateNow) {
            this.validate();
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private void showMorePopup(MouseEvent e) {
        this.mySingleRowLayout.myMorePopup = new JPopupMenu();
        for (final TabInfo each : this.myVisibleInfos) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(each.getText());
            this.mySingleRowLayout.myMorePopup.add(item);
            if (this.getSelectedInfo() == each) {
                item.setSelected(true);
            }
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JBTabsImpl.this.select(each, true);
                }
            });
        }
        this.mySingleRowLayout.myMorePopup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myMorePopup = null;
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                ((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myMorePopup = null;
            }
        });
        this.mySingleRowLayout.myMorePopup.show(this, e.getX(), e.getY());
    }

    private JComponent getToFocus() {
        JComponent policyToFocus;
        TabInfo info = this.getSelectedInfo();
        if (info == null) {
            return null;
        }
        JComponent toFocus = null;
        if (this.isRequestFocusOnLastFocusedComponent() && info.getLastFocusOwner() != null && !this.isMyChildIsFocusedNow()) {
            toFocus = info.getLastFocusOwner();
        }
        if (toFocus == null && info.getPreferredFocusableComponent() == null) {
            return null;
        }
        if (toFocus == null && (policyToFocus = this.myFocusManager.getFocusTargetFor(toFocus = info.getPreferredFocusableComponent())) != null) {
            toFocus = policyToFocus;
        }
        return toFocus;
    }

    @Override
    public void requestFocus() {
        JComponent toFocus = this.getToFocus();
        if (toFocus != null) {
            toFocus.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        JComponent toFocus = this.getToFocus();
        if (toFocus != null) {
            return toFocus.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    private JBTabsImpl findTabs(Component c) {
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            if (!(eachParent instanceof JBTabsImpl)) continue;
            return (JBTabsImpl)eachParent;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public TabInfo addTab(TabInfo info, int index) {
        TabInfo tabInfo;
        if (this.getTabs().contains(info)) {
            tabInfo = this.getTabs().get(this.getTabs().indexOf(info));
            if (tabInfo == null) throw new IllegalStateException("@NotNull method com/intellij/ui/tabs/impl/JBTabsImpl.addTab must not return null");
            return tabInfo;
        }
        info.getChangeSupport().addPropertyChangeListener(this);
        TabLabel label = new TabLabel(this, info);
        this.myInfo2Label.put(info, label);
        if (index < 0) {
            this.myVisibleInfos.add(info);
        } else if (index > this.myVisibleInfos.size() - 1) {
            this.myVisibleInfos.add(info);
        } else {
            this.myVisibleInfos.add(index, info);
        }
        this.resetTabsCache();
        this.updateText(info);
        this.updateIcon(info);
        this.updateSideComponent(info);
        this.updateTabActions(info);
        this.add(label);
        this.adjust(info);
        this.updateAll(false, false);
        if (info.isHidden()) {
            this.updateHiding();
        }
        if (this.getTabCount() == 1) {
            this.fireBeforeSelectionChanged(null, info);
            this.fireSelectionChanged(null, info);
        }
        if ((tabInfo = info) != null) return tabInfo;
        throw new IllegalStateException("@NotNull method com/intellij/ui/tabs/impl/JBTabsImpl.addTab must not return null");
    }

    @Override
    @NotNull
    public TabInfo addTab(TabInfo info) {
        TabInfo tabInfo = this.addTab(info, -1);
        if (tabInfo == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/tabs/impl/JBTabsImpl.addTab must not return null");
        }
        return tabInfo;
    }

    @Override
    public ActionGroup getPopupGroup() {
        return this.myPopupGroup != null ? (ActionGroup)this.myPopupGroup.get() : null;
    }

    @Override
    public String getPopupPlace() {
        return this.myPopupPlace;
    }

    @Override
    public JBTabs setPopupGroup(final @NotNull ActionGroup popupGroup, @NotNull String place, boolean addNavigationGroup) {
        if (popupGroup == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/impl/JBTabsImpl.setPopupGroup must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/tabs/impl/JBTabsImpl.setPopupGroup must not be null");
        }
        return this.setPopupGroup(new Getter<ActionGroup>(){

            public ActionGroup get() {
                return popupGroup;
            }
        }, place, addNavigationGroup);
    }

    @Override
    public JBTabs setPopupGroup(@NotNull Getter<ActionGroup> popupGroup, @NotNull String place, boolean addNavigationGroup) {
        if (popupGroup == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/impl/JBTabsImpl.setPopupGroup must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/tabs/impl/JBTabsImpl.setPopupGroup must not be null");
        }
        this.myPopupGroup = popupGroup;
        this.myPopupPlace = place;
        this.myAddNavigationGroup = addNavigationGroup;
        return this;
    }

    private void updateAll(boolean forcedRelayout, boolean now) {
        this.mySelectedInfo = this.getSelectedInfo();
        this.updateContainer(forcedRelayout, now);
        this.removeDeferred();
        this.updateListeners();
        this.updateTabActions(false);
        this.updateEnabling();
    }

    private boolean isMyChildIsFocusedNow() {
        JComponent owner = JBTabsImpl.getFocusOwner();
        if (owner == null) {
            return false;
        }
        if (this.mySelectedInfo != null && !SwingUtilities.isDescendingFrom(owner, this.mySelectedInfo.getComponent())) {
            return false;
        }
        return SwingUtilities.isDescendingFrom(owner, this);
    }

    @Nullable
    private static JComponent getFocusOwner() {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return (JComponent)(owner instanceof JComponent ? owner : null);
    }

    @Override
    public ActionCallback select(@NotNull TabInfo info, boolean requestFocus) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/impl/JBTabsImpl.select must not be null");
        }
        return this._setSelected(info, requestFocus);
    }

    private ActionCallback _setSelected(TabInfo info, boolean requestFocus) {
        if (this.mySelectedInfo != null && this.mySelectedInfo.equals(info)) {
            if (!requestFocus) {
                return new ActionCallback.Done();
            }
            return this.requestFocus(this.getToFocus());
        }
        if (this.myRequestFocusOnLastFocusedComponent && this.mySelectedInfo != null && this.isMyChildIsFocusedNow()) {
            this.mySelectedInfo.setLastFocusOwner(JBTabsImpl.getFocusOwner());
        }
        TabInfo oldInfo = this.mySelectedInfo;
        this.mySelectedInfo = info;
        TabInfo newInfo = this.getSelectedInfo();
        this.fireBeforeSelectionChanged(oldInfo, newInfo);
        this.updateContainer(false, true);
        this.fireSelectionChanged(oldInfo, newInfo);
        if (requestFocus) {
            JComponent toFocus = this.getToFocus();
            if (this.myProject != null && toFocus != null) {
                final ActionCallback result = new ActionCallback();
                this.requestFocus(toFocus).doWhenProcessed(new Runnable(){

                    @Override
                    public void run() {
                        if (JBTabsImpl.this.myDisposed) {
                            result.setRejected();
                        } else {
                            JBTabsImpl.this.removeDeferred().notifyWhenDone(result);
                        }
                    }
                });
                return result;
            }
            this.requestFocus();
            return this.removeDeferred();
        }
        return this.removeDeferred();
    }

    private void fireBeforeSelectionChanged(TabInfo oldInfo, TabInfo newInfo) {
        if (oldInfo != newInfo) {
            for (TabsListener eachListener : this.myTabListeners) {
                eachListener.beforeSelectionChanged(oldInfo, newInfo);
            }
        }
    }

    private void fireSelectionChanged(TabInfo oldInfo, TabInfo newInfo) {
        if (oldInfo != newInfo) {
            for (TabsListener eachListener : this.myTabListeners) {
                if (eachListener == null) continue;
                eachListener.selectionChanged(oldInfo, newInfo);
            }
        }
    }

    private ActionCallback requestFocus(JComponent toFocus) {
        if (toFocus == null) {
            return new ActionCallback.Done();
        }
        if (this.myTestMode) {
            toFocus.requestFocus();
            return new ActionCallback.Done();
        }
        return this.myFocusManager.requestFocus(new FocusCommand.ByComponent(toFocus), true);
    }

    private ActionCallback removeDeferred() {
        final ActionCallback callback = new ActionCallback();
        final long executionRequest = ++this.myRemoveDefferredRequest;
        Runnable onDone = new Runnable(){

            @Override
            public void run() {
                if (JBTabsImpl.this.myRemoveDefferredRequest == executionRequest) {
                    JBTabsImpl.this.removeDeferredNow();
                }
                callback.setDone();
            }
        };
        this.myFocusManager.doWhenFocusSettlesDown(onDone);
        return callback;
    }

    private void queueForRemove(Component c) {
        if (c instanceof JComponent) {
            this.addToDeferredRemove(c);
        } else {
            this.remove(c);
        }
    }

    private void unqueueFromRemove(Component c) {
        this.myDeferredToRemove.remove(c);
    }

    private void removeDeferredNow() {
        for (Component each : this.myDeferredToRemove.keySet()) {
            if (each == null || each.getParent() != this) continue;
            this.remove(each);
        }
        this.myDeferredToRemove.clear();
    }

    private void printRemoveInfo(Component each) {
        TabInfo removingInfo = null;
        List<TabInfo> all = this.getTabs();
        for (TabInfo eachInfo : all) {
            if (eachInfo.getComponent() != each) continue;
            removingInfo = eachInfo;
            break;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        TabInfo tabInfo = (TabInfo)evt.getSource();
        if ("actionGroup".equals(evt.getPropertyName())) {
            this.updateSideComponent(tabInfo);
            this.relayout(false, false);
        } else if ("component".equals(evt.getPropertyName())) {
            this.relayout(true, false);
        } else if ("text".equals(evt.getPropertyName())) {
            this.updateText(tabInfo);
        } else if ("icon".equals(evt.getPropertyName())) {
            this.updateIcon(tabInfo);
        } else if ("color".equals(evt.getPropertyName())) {
            this.updateColor(tabInfo);
        } else if ("alertStatus".equals(evt.getPropertyName())) {
            boolean start = (Boolean)evt.getNewValue();
            this.updateAttraction(tabInfo, start);
        } else if ("tabActionGroup".equals(evt.getPropertyName())) {
            this.updateTabActions(tabInfo);
            this.relayout(false, false);
        } else if ("hidden".equals(evt.getPropertyName())) {
            this.updateHiding();
            this.relayout(false, false);
        } else if ("enabled".equals(evt.getPropertyName())) {
            this.updateEnabling();
        }
    }

    private void updateEnabling() {
        TabInfo toSelect;
        List<TabInfo> all = this.getTabs();
        for (TabInfo each : all) {
            TabLabel eachLabel = this.myInfo2Label.get(each);
            eachLabel.setTabEnabled(each.isEnabled());
        }
        TabInfo selected = this.getSelectedInfo();
        if (selected != null && !selected.isEnabled() && (toSelect = this.getToSelectOnRemoveOf(selected)) != null) {
            this.select(toSelect, this.myFocusManager.getFocusedDescendantFor(this) != null);
        }
    }

    private void updateHiding() {
        boolean update = false;
        Iterator<TabInfo> visible = this.myVisibleInfos.iterator();
        while (visible.hasNext()) {
            TabInfo each = visible.next();
            if (!each.isHidden() || this.myHiddenInfos.containsKey(each)) continue;
            this.myHiddenInfos.put(each, this.myVisibleInfos.indexOf(each));
            visible.remove();
            update = true;
        }
        Iterator<TabInfo> hidden = this.myHiddenInfos.keySet().iterator();
        while (hidden.hasNext()) {
            TabInfo each = hidden.next();
            if (each.isHidden() || !this.myHiddenInfos.containsKey(each)) continue;
            this.myVisibleInfos.add(this.getIndexInVisibleArray(each), each);
            hidden.remove();
            update = true;
        }
        if (update) {
            this.resetTabsCache();
            if (this.mySelectedInfo != null && this.myHiddenInfos.containsKey(this.mySelectedInfo)) {
                this.mySelectedInfo = this.getToSelectOnRemoveOf(this.mySelectedInfo);
            }
            this.updateAll(true, false);
        }
    }

    private int getIndexInVisibleArray(TabInfo each) {
        Integer index = this.myHiddenInfos.get(each);
        if (index == null) {
            index = this.myVisibleInfos.size();
        }
        if (index > this.myVisibleInfos.size()) {
            index = this.myVisibleInfos.size();
        }
        if (index < 0) {
            index = 0;
        }
        return index;
    }

    private void updateIcon(final TabInfo tabInfo) {
        this.updateTab(new Computable<Boolean>(){

            public Boolean compute() {
                JBTabsImpl.this.myInfo2Label.get(tabInfo).setIcon(tabInfo.getIcon());
                return true;
            }
        }, tabInfo);
    }

    private void updateColor(TabInfo tabInfo) {
        this.myInfo2Label.get(tabInfo).setInactiveStateImage(null);
        this.updateTab(new Computable<Boolean>(){

            public Boolean compute() {
                JBTabsImpl.this.repaint();
                return true;
            }
        }, tabInfo);
    }

    private void updateTab(Computable<Boolean> update, TabInfo info) {
        TabLabel label = this.myInfo2Label.get(info);
        Boolean changes = (Boolean)update.compute();
        if (label.getRootPane() != null) {
            if (label.isValid()) {
                if (changes.booleanValue()) {
                    label.repaint();
                }
            } else {
                this.revalidateAndRepaint(false);
            }
        }
    }

    void revalidateAndRepaint(boolean layoutNow) {
        if (this.myVisibleInfos.isEmpty()) {
            this.setOpaque(false);
            Component nonOpaque = UIUtil.findUltimateParent((Component)this);
            if (nonOpaque != null && this.getParent() != null) {
                Rectangle toRepaint = SwingUtilities.convertRectangle(this.getParent(), this.getBounds(), nonOpaque);
                nonOpaque.repaint(toRepaint.x, toRepaint.y, toRepaint.width, toRepaint.height);
            }
        } else {
            this.setOpaque(true);
        }
        if (layoutNow) {
            this.validate();
        } else {
            this.revalidate();
        }
        this.repaint();
    }

    private void updateAttraction(TabInfo tabInfo, boolean start) {
        if (start) {
            this.myAttractions.add(tabInfo);
        } else {
            this.myAttractions.remove(tabInfo);
            tabInfo.setBlinkCount(0);
        }
        if (start && !this.myAnimator.isRunning()) {
            this.myAnimator.resume();
        } else if (!start && this.myAttractions.isEmpty()) {
            this.myAnimator.suspend();
            this.repaintAttractions();
        }
    }

    private void updateText(final TabInfo tabInfo) {
        this.updateTab(new Computable<Boolean>(){

            public Boolean compute() {
                TabLabel label = JBTabsImpl.this.myInfo2Label.get(tabInfo);
                label.setText(tabInfo.getColoredText());
                label.setToolTipText(tabInfo.getTooltipText());
                return true;
            }
        }, tabInfo);
    }

    private void updateSideComponent(TabInfo tabInfo) {
        Toolbar old = this.myInfo2Toolbar.get(tabInfo);
        if (old != null) {
            this.remove(old);
        }
        Toolbar toolbar = this.createToolbarComponent(tabInfo);
        this.myInfo2Toolbar.put(tabInfo, toolbar);
        this.add(toolbar);
    }

    private void updateTabActions(TabInfo info) {
        this.myInfo2Label.get(info).setTabActions(info.getTabLabelActions());
    }

    @Override
    @Nullable
    public TabInfo getSelectedInfo() {
        if (!this.myVisibleInfos.contains(this.mySelectedInfo)) {
            this.mySelectedInfo = null;
        }
        return this.mySelectedInfo != null ? this.mySelectedInfo : (!this.myVisibleInfos.isEmpty() ? this.myVisibleInfos.get(0) : null);
    }

    @Nullable
    private TabInfo getToSelectOnRemoveOf(TabInfo info) {
        if (!this.myVisibleInfos.contains(info)) {
            return null;
        }
        if (this.mySelectedInfo != info) {
            return null;
        }
        if (this.myVisibleInfos.size() == 1) {
            return null;
        }
        int index = this.myVisibleInfos.indexOf(info);
        TabInfo result = null;
        if (index > 0) {
            result = this.findEnabledBackward(index - 1);
        }
        if (result == null) {
            result = this.findEnabledForward(index + 1);
        }
        return result;
    }

    private TabInfo findEnabledForward(int from) {
        for (int index = from; index < this.myVisibleInfos.size() && index >= 0; ++index) {
            TabInfo each = this.myVisibleInfos.get(index);
            if (!each.isEnabled()) continue;
            return each;
        }
        return null;
    }

    private TabInfo findEnabledBackward(int from) {
        for (int index = from; index >= 0 && from < this.myVisibleInfos.size(); --index) {
            TabInfo each = this.myVisibleInfos.get(index);
            if (!each.isEnabled()) continue;
            return each;
        }
        return null;
    }

    protected Toolbar createToolbarComponent(TabInfo tabInfo) {
        return new Toolbar(this, tabInfo);
    }

    @Override
    @NotNull
    public TabInfo getTabAt(int tabIndex) {
        TabInfo tabInfo = this.getTabs().get(tabIndex);
        if (tabInfo == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/tabs/impl/JBTabsImpl.getTabAt must not return null");
        }
        return tabInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public List<TabInfo> getTabs() {
        List<TabInfo> list;
        if (this.myAllTabs != null) {
            list = this.myAllTabs;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/ui/tabs/impl/JBTabsImpl.getTabs must not return null");
            return list;
        }
        ArrayList<TabInfo> result = new ArrayList<TabInfo>();
        result.addAll(this.myVisibleInfos);
        for (TabInfo each : this.myHiddenInfos.keySet()) {
            result.add(this.getIndexInVisibleArray(each), each);
        }
        this.myAllTabs = result;
        list = result;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/ui/tabs/impl/JBTabsImpl.getTabs must not return null");
    }

    @Override
    public TabInfo getTargetInfo() {
        return this.myPopupInfo != null ? this.myPopupInfo : this.getSelectedInfo();
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.resetPopup();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        this.resetPopup();
    }

    private void resetPopup() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JBTabsImpl.this.myPopupInfo = null;
            }
        });
    }

    @Override
    public void setPaintBlocked(boolean blocked, boolean takeSnapshot) {
        if (blocked && !this.myPaintBlocked && takeSnapshot) {
            this.myImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            Graphics2D g = this.myImage.createGraphics();
            super.paint(g);
            g.dispose();
        }
        this.myPaintBlocked = blocked;
        if (!this.myPaintBlocked) {
            if (this.myImage != null) {
                this.myImage.flush();
            }
            this.myImage = null;
            this.repaint();
        }
    }

    private void addToDeferredRemove(Component c) {
        if (!this.myDeferredToRemove.containsKey(c)) {
            this.myDeferredToRemove.put(c, c);
        }
    }

    @Override
    public boolean isToDrawBorderIfTabsHidden() {
        return this.myToDrawBorderIfTabsHidden;
    }

    @Override
    @NotNull
    public JBTabsPresentation setToDrawBorderIfTabsHidden(boolean toDrawBorderIfTabsHidden) {
        this.myToDrawBorderIfTabsHidden = toDrawBorderIfTabsHidden;
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/tabs/impl/JBTabsImpl.setToDrawBorderIfTabsHidden must not return null");
        }
        return jBTabsImpl;
    }

    @Override
    @NotNull
    public JBTabs getJBTabs() {
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/tabs/impl/JBTabsImpl.getJBTabs must not return null");
        }
        return jBTabsImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        try {
            this.myHeaderFitSize = this.computeHeaderFitSize();
            Collection<TabLabel> labels = this.myInfo2Label.values();
            for (TabLabel each : labels) {
                each.setTabActionsAutoHide(this.myTabLabelActionsAutoHide);
            }
            if (this.isSingleRow()) {
                this.myLastLayoutPass = this.mySingleRowLayout.layoutSingleRow();
                this.myTableLayout.myLastTableLayout = null;
            } else {
                this.myLastLayoutPass = this.myTableLayout.layoutTable();
                this.mySingleRowLayout.myLastSingRowLayout = null;
            }
            if (this.isStealthModeEffective() && !this.isHideTabs()) {
                TabLabel label = this.getSelectedLabel();
                Rectangle bounds = label.getBounds();
                Insets insets = this.getLayoutInsets();
                JBTabsImpl.layout(label, insets.left, bounds.y, this.getWidth() - insets.right - insets.left, bounds.height);
            }
            this.moveDraggedTabLabel();
            this.myTabActionsAutoHideListener.processMouseOver();
        }
        finally {
            this.myForcedRelayout = false;
        }
        this.applyResetComponents();
    }

    void moveDraggedTabLabel() {
        TabLabel selectedLabel;
        if (this.myDragHelper != null && this.myDragHelper.myDragRec != null && (selectedLabel = this.myInfo2Label.get(this.getSelectedInfo())) != null) {
            Rectangle bounds = selectedLabel.getBounds();
            if (this.isHorizontalTabs()) {
                selectedLabel.setBounds(this.myDragHelper.myDragRec.x, bounds.y, bounds.width, bounds.height);
            } else {
                selectedLabel.setBounds(bounds.x, this.myDragHelper.myDragRec.y, bounds.width, bounds.height);
            }
        }
    }

    private Dimension computeHeaderFitSize() {
        Max max = this.computeMaxSize();
        if (this.myPosition == JBTabsPosition.top || this.myPosition == JBTabsPosition.bottom) {
            return new Dimension(this.getSize().width, this.myHorizontalSide ? Math.max(max.myLabel.height, max.myToolbar.height) : max.myLabel.height);
        }
        return new Dimension(max.myLabel.width + (this.myHorizontalSide ? 0 : max.myToolbar.width), this.getSize().height);
    }

    public Rectangle layoutComp(int componentX, int componentY, JComponent comp, int deltaWidth, int deltaHeight) {
        boolean noTabsVisible;
        Insets insets = this.getLayoutInsets();
        Insets border = this.isHideTabs() ? new Insets(0, 0, 0, 0) : this.myBorder.getEffectiveBorder();
        boolean bl = noTabsVisible = this.isStealthModeEffective() || this.isHideTabs();
        if (noTabsVisible) {
            border.top = JBTabsImpl.getBorder(-1);
            border.bottom = JBTabsImpl.getBorder(-1);
            border.left = JBTabsImpl.getBorder(-1);
            border.right = JBTabsImpl.getBorder(-1);
        }
        Insets inner = this.getInnerInsets();
        border.top += inner.top;
        border.bottom += inner.bottom;
        border.left += inner.left;
        border.right += inner.right;
        int x = insets.left + componentX + border.left;
        int y = insets.top + componentY + border.top;
        int width = this.getWidth() - insets.left - insets.right - componentX - border.left - border.right;
        int height = this.getHeight() - insets.top - insets.bottom - componentY - border.top - border.bottom;
        if (!noTabsVisible) {
            width += deltaWidth;
            height += deltaHeight;
        }
        return JBTabsImpl.layout(comp, x, y, width, height);
    }

    @Override
    public JBTabsPresentation setInnerInsets(Insets innerInsets) {
        this.myInnerInsets = innerInsets;
        return this;
    }

    @Override
    public Insets getInnerInsets() {
        return this.myInnerInsets;
    }

    public Insets getLayoutInsets() {
        Insets insets = this.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        return insets;
    }

    private int fixInset(int inset, int addin) {
        return inset + addin;
    }

    public int getToolbarInset() {
        return this.getArcSize() + 1;
    }

    public void resetLayout(boolean resetLabels) {
        if (resetLabels) {
            this.mySingleRowLayout.myLeftGhost.reset();
            this.mySingleRowLayout.myRightGhost.reset();
        }
        for (TabInfo each : this.myVisibleInfos) {
            this.reset(each, resetLabels);
        }
        for (TabInfo each : this.myHiddenInfos.keySet()) {
            this.reset(each, resetLabels);
        }
        for (Component eachDeferred : this.myDeferredToRemove.keySet()) {
            JBTabsImpl.resetLayout((JComponent)eachDeferred);
        }
    }

    private void reset(TabInfo each, boolean resetLabels) {
        JComponent c = each.getComponent();
        if (c != null) {
            JBTabsImpl.resetLayout(c);
        }
        JBTabsImpl.resetLayout(this.myInfo2Toolbar.get(each));
        if (resetLabels) {
            JBTabsImpl.resetLayout(this.myInfo2Label.get(each));
        }
    }

    private int getArcSize() {
        return 4;
    }

    public int getGhostTabLength() {
        return 15;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Toolbar toolbarComp;
        Rectangle compBounds;
        super.paintComponent(g);
        if (this.myVisibleInfos.isEmpty()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        GraphicsConfig config = new GraphicsConfig(g2d);
        config.setAntialiasing(true);
        g2d.setColor(this.getBackground());
        Rectangle clip = g2d.getClipBounds();
        g2d.fillRect(clip.x, clip.y, clip.width, clip.height);
        TabInfo selected = this.getSelectedInfo();
        if (selected != null && (compBounds = selected.getComponent().getBounds()).contains(clip) && !compBounds.intersects(clip)) {
            return;
        }
        boolean leftGhostExists = this.isSingleRow();
        boolean rightGhostExists = this.isSingleRow();
        if (!this.isStealthModeEffective() && !this.isHideTabs()) {
            if (this.isSingleRow() && this.mySingleRowLayout.myLastSingRowLayout.lastGhostVisible) {
                this.paintLastGhost(g2d);
            }
            this.paintNonSelectedTabs(g2d, leftGhostExists);
            if (this.isSingleRow() && this.mySingleRowLayout.myLastSingRowLayout.firstGhostVisible) {
                this.paintFirstGhost(g2d);
            }
        }
        config.setAntialiasing(false);
        if (this.isSideComponentVertical() && (toolbarComp = this.myInfo2Toolbar.get(this.mySelectedInfo)) != null && !toolbarComp.isEmpty()) {
            Rectangle toolBounds = toolbarComp.getBounds();
            g2d.setColor(CaptionPanel.CNT_ACTIVE_COLOR);
            g2d.drawLine((int)toolBounds.getMaxX(), toolBounds.y, (int)toolBounds.getMaxX(), (int)toolBounds.getMaxY() - 1);
        }
        config.restore();
    }

    private Color getActiveTabColor(Color c) {
        TabInfo info = this.getSelectedInfo();
        if (info == null) {
            return c;
        }
        Color tabColor = info.getTabColor();
        return tabColor == null ? c : tabColor;
    }

    private void paintSelectionAndBorder(Graphics2D g2d) {
        Color tabColor;
        Color bgColor;
        if (this.getSelectedLabel() == null) {
            return;
        }
        ShapeInfo shapeInfo = this.computeSelectedLabelShape();
        if (!this.isHideTabs()) {
            g2d.setColor(this.getBackground());
            g2d.fill(shapeInfo.fillPath.getShape());
        }
        int paintTopY = shapeInfo.labelTopY;
        int paintBottomY = shapeInfo.labelBottomY;
        boolean paintFocused = this.myPaintFocus && (this.myFocused || this.myActivePopup != null);
        Color bgPreFill = null;
        if (paintFocused) {
            bgColor = this.getActiveTabColor(this.getActiveTabFillIn());
            if (bgColor == null) {
                shapeInfo.from = UIUtil.getFocusedFillColor();
                shapeInfo.to = UIUtil.getFocusedFillColor();
            } else {
                bgPreFill = bgColor;
                int alpha = 255;
                paintBottomY = shapeInfo.labelTopY + shapeInfo.labelPath.deltaY(this.getArcSize() - 2);
                shapeInfo.from = UIUtil.toAlpha((Color)UIUtil.getFocusedFillColor(), (int)alpha);
                shapeInfo.to = UIUtil.toAlpha((Color)this.getActiveTabFillIn(), (int)alpha);
            }
        } else {
            bgColor = this.getActiveTabColor(this.getActiveTabFillIn());
            if (this.isPaintFocus()) {
                if (bgColor == null) {
                    int alpha = 150;
                    shapeInfo.from = UIUtil.toAlpha((Color)UIUtil.getPanelBackgound().brighter(), (int)alpha);
                    shapeInfo.to = UIUtil.toAlpha((Color)UIUtil.getPanelBackgound(), (int)alpha);
                } else {
                    int alpha = 255;
                    shapeInfo.from = UIUtil.toAlpha((Color)bgColor, (int)alpha);
                    shapeInfo.to = UIUtil.toAlpha((Color)bgColor, (int)alpha);
                }
            } else {
                int alpha = 255;
                Color tabColor2 = this.getActiveTabColor(null);
                shapeInfo.from = UIUtil.toAlpha((Color)(tabColor2 == null ? Color.white : tabColor2), (int)alpha);
                shapeInfo.to = UIUtil.toAlpha((Color)(tabColor2 == null ? Color.white : tabColor2), (int)alpha);
            }
        }
        if (!this.isHideTabs()) {
            if (bgPreFill != null) {
                g2d.setColor(bgPreFill);
                g2d.fill(shapeInfo.fillPath.getShape());
            }
            Line2D.Float gradientLine = shapeInfo.fillPath.transformLine(shapeInfo.fillPath.getX(), paintTopY, shapeInfo.fillPath.getX(), paintBottomY);
            g2d.setPaint(new GradientPaint((float)gradientLine.getX1(), (float)gradientLine.getY1(), shapeInfo.fillPath.transformY1(shapeInfo.from, shapeInfo.to), (float)gradientLine.getX2(), (float)gradientLine.getY2(), shapeInfo.fillPath.transformY1(shapeInfo.to, shapeInfo.from)));
            g2d.fill(shapeInfo.fillPath.getShape());
        }
        Color borderColor = (tabColor = this.getActiveTabColor(null)) == null ? UIUtil.getBoundsColor((boolean)paintFocused) : tabColor.darker();
        g2d.setColor(borderColor);
        if (!this.isHideTabs()) {
            g2d.draw(shapeInfo.path.getShape());
        }
        this.paintBorder(g2d, shapeInfo, borderColor);
    }

    private ShapeInfo computeSelectedLabelShape() {
        ShapeInfo shape = new ShapeInfo();
        shape.path = this.getEffectiveLayout().createShapeTransform(this.getSize());
        shape.insets = shape.path.transformInsets(this.getLayoutInsets());
        shape.labelPath = shape.path.createTransform(this.getSelectedLabel().getBounds());
        shape.labelBottomY = shape.labelPath.getMaxY() + shape.labelPath.deltaY(1);
        shape.labelTopY = shape.labelPath.getY();
        shape.labelLeftX = shape.labelPath.getX();
        shape.labelRightX = shape.labelPath.getX() + shape.labelPath.deltaX(shape.labelPath.getWidth());
        shape.path.moveTo(shape.insets.left, shape.labelBottomY);
        shape.path.lineTo(shape.labelLeftX, shape.labelBottomY);
        shape.path.lineTo(shape.labelLeftX, shape.labelTopY + shape.labelPath.deltaY(this.getArcSize()));
        shape.path.quadTo(shape.labelLeftX, shape.labelTopY, shape.labelLeftX + shape.labelPath.deltaX(this.getArcSize()), shape.labelTopY);
        int lastX = shape.path.getWidth() - shape.path.deltaX(shape.insets.right + 1);
        if (this.isStealthModeEffective()) {
            shape.path.lineTo(lastX - shape.path.deltaX(this.getArcSize()), shape.labelTopY);
            shape.path.quadTo(lastX, shape.labelTopY, lastX, shape.labelTopY + shape.path.deltaY(this.getArcSize()));
            shape.path.lineTo(lastX, shape.labelBottomY);
        } else {
            shape.path.lineTo(shape.labelRightX - shape.path.deltaX(this.getArcSize()), shape.labelTopY);
            shape.path.quadTo(shape.labelRightX, shape.labelTopY, shape.labelRightX, shape.labelTopY + shape.path.deltaY(this.getArcSize()));
            if (this.myLastLayoutPass.hasCurveSpaceFor(this.getSelectedInfo())) {
                shape.path.lineTo(shape.labelRightX, shape.labelBottomY - shape.path.deltaY(this.getArcSize()));
                shape.path.quadTo(shape.labelRightX, shape.labelBottomY, shape.labelRightX + shape.path.deltaX(this.getArcSize()), shape.labelBottomY);
            } else {
                shape.path.lineTo(shape.labelRightX, shape.labelBottomY);
            }
        }
        shape.path.lineTo(lastX, shape.labelBottomY);
        if (this.isStealthModeEffective()) {
            shape.path.closePath();
        }
        shape.fillPath = shape.path.copy();
        if (!this.isHideTabs()) {
            shape.fillPath.lineTo(lastX, shape.labelBottomY + shape.fillPath.deltaY(1));
            shape.fillPath.lineTo(shape.labelLeftX, shape.labelBottomY + shape.fillPath.deltaY(1));
            shape.fillPath.closePath();
        }
        return shape;
    }

    private TabLabel getSelectedLabel() {
        return this.myInfo2Label.get(this.getSelectedInfo());
    }

    private void paintFirstGhost(Graphics2D g2d) {
        boolean isLeftFromSelection;
        ShapeTransform path = this.getEffectiveLayout().createShapeTransform(this.mySingleRowLayout.myLastSingRowLayout.firstGhost);
        int topX = path.getX() + path.deltaX(this.getCurveArc());
        int topY = path.getY() + path.deltaY(this.getSelectionTabVShift());
        int bottomX = path.getMaxX() + path.deltaX(1);
        int bottomY = path.getMaxY() + path.deltaY(1);
        path.moveTo(topX, topY);
        boolean bl = isLeftFromSelection = this.mySingleRowLayout.myLastSingRowLayout.toLayout.indexOf(this.getSelectedInfo()) == 0;
        if (isLeftFromSelection) {
            path.lineTo(bottomX, topY);
        } else {
            path.lineTo(bottomX - this.getArcSize(), topY);
            path.quadTo(bottomX, topY, bottomX, topY + path.deltaY(this.getArcSize()));
        }
        path.lineTo(bottomX, bottomY);
        path.lineTo(topX, bottomY);
        path.quadTo(topX - path.deltaX(this.getCurveArc() * 2 - 1), bottomY - path.deltaY(Math.abs(bottomY - topY) / 4), topX, bottomY - path.deltaY(Math.abs(bottomY - topY) / 2));
        path.quadTo(topX + path.deltaX(this.getCurveArc() - 1), topY + path.deltaY(Math.abs(bottomY - topY) / 4), topX, topY);
        path.closePath();
        g2d.setColor(this.getBackground());
        g2d.fill(path.getShape());
        g2d.setColor(this.getBoundsColor());
        g2d.draw(path.getShape());
        g2d.setColor(this.getTopBlickColor());
        g2d.drawLine(topX + path.deltaX(1), topY + path.deltaY(1), bottomX - path.deltaX(this.getArcSize()), topY + path.deltaY(1));
        g2d.setColor(this.getRightBlockColor());
        g2d.drawLine(bottomX - path.deltaX(1), topY + path.deltaY(this.getArcSize()), bottomX - path.deltaX(1), bottomY - path.deltaY(1));
    }

    private void paintLastGhost(Graphics2D g2d) {
        ShapeTransform path = this.getEffectiveLayout().createShapeTransform(this.mySingleRowLayout.myLastSingRowLayout.lastGhost);
        int topX = path.getX() - path.deltaX(this.getArcSize());
        int topY = path.getY() + path.deltaY(this.getSelectionTabVShift());
        int bottomX = path.getMaxX() - path.deltaX(this.getCurveArc());
        int bottomY = path.getMaxY() + path.deltaY(1);
        path.moveTo(topX, topY);
        path.lineTo(bottomX, topY);
        path.quadTo(bottomX - this.getCurveArc(), topY + (bottomY - topY) / 4, bottomX, topY + (bottomY - topY) / 2);
        path.quadTo(bottomX + this.getCurveArc(), bottomY - (bottomY - topY) / 4, bottomX, bottomY);
        path.lineTo(topX, bottomY);
        path.closePath();
        g2d.setColor(this.getBackground());
        g2d.fill(path.getShape());
        g2d.setColor(this.getBoundsColor());
        g2d.draw(path.getShape());
        g2d.setColor(this.getTopBlickColor());
        g2d.drawLine(topX, topY + path.deltaY(1), bottomX - path.deltaX(this.getCurveArc()), topY + path.deltaY(1));
    }

    private int getCurveArc() {
        return 2;
    }

    private Color getBoundsColor() {
        return Color.gray;
    }

    private Color getRightBlockColor() {
        return Color.lightGray;
    }

    private Color getTopBlickColor() {
        return Color.white;
    }

    private void paintNonSelectedTabs(Graphics2D g2d, boolean leftGhostExists) {
        TabInfo selected = this.getSelectedInfo();
        if (this.myLastPaintedSelection == null || !this.myLastPaintedSelection.equals(selected)) {
            List<TabInfo> tabs = this.getTabs();
            for (TabInfo each : tabs) {
                this.myInfo2Label.get(each).setInactiveStateImage(null);
            }
        }
        for (int eachRow = 0; eachRow < this.myLastLayoutPass.getRowCount(); ++eachRow) {
            for (int eachColumn = this.myLastLayoutPass.getColumnCount(eachRow) - 1; eachColumn >= 0; --eachColumn) {
                TabInfo each;
                each = this.myLastLayoutPass.getTabAt(eachRow, eachColumn);
                if (this.getSelectedInfo() == each) continue;
                this.paintNonSelected(g2d, each, leftGhostExists);
            }
        }
        this.myLastPaintedSelection = selected;
    }

    private void paintNonSelected(Graphics2D g2d, TabInfo each, boolean leftGhostExists) {
        TabLabel label = this.myInfo2Label.get(each);
        if (label.getBounds().width == 0) {
            return;
        }
        int imageInsets = this.getArcSize() + 1;
        Rectangle bounds = label.getBounds();
        int x = bounds.x - imageInsets;
        int y = bounds.y;
        int width = bounds.width + imageInsets * 2 + 1;
        int height = bounds.height + this.getArcSize() + 1;
        if (this.isToBufferPainting()) {
            BufferedImage img = label.getInactiveStateImage(bounds);
            if (img == null) {
                img = new BufferedImage(width, height, 2);
                Graphics2D imgG2d = img.createGraphics();
                imgG2d.addRenderingHints(g2d.getRenderingHints());
                this.doPaintInactictive(imgG2d, leftGhostExists, label, new Rectangle(imageInsets, 0, label.getWidth(), label.getHeight()));
                imgG2d.dispose();
            }
            g2d.drawImage(img, x, y, width, height, null);
            label.setInactiveStateImage(img);
        } else {
            this.doPaintInactictive(g2d, leftGhostExists, label, label.getBounds());
            label.setInactiveStateImage(null);
        }
    }

    private boolean isToBufferPainting() {
        return Registry.is("ide.tabbedPane.bufferedPaint") && this.myUseBufferedPaint;
    }

    private void doPaintInactictive(Graphics2D g2d, boolean leftGhostExists, TabLabel label, Rectangle effectiveBounds) {
        TablePassInfo info;
        boolean lastShowing;
        boolean firstShowing;
        int tabIndex = this.myVisibleInfos.indexOf(label.getInfo());
        int arc = this.getArcSize();
        Color topBlickColor = this.getTopBlickColor();
        Color rightBlockColor = this.getRightBlockColor();
        Color boundsColor = this.getBoundsColor();
        Color backgroundColor = this.getBackground();
        Color tabColor = label.getInfo().getTabColor();
        if (tabColor != null) {
            backgroundColor = tabColor;
            boundsColor = tabColor.darker();
            topBlickColor = tabColor.brighter().brighter();
            rightBlockColor = tabColor;
        }
        TabInfo selected = this.getSelectedInfo();
        int selectionTabVShift = this.getSelectionTabVShift();
        TabInfo prev = this.myLastLayoutPass.getPreviousFor(this.myVisibleInfos.get(tabIndex));
        TabInfo next = this.myLastLayoutPass.getNextFor(this.myVisibleInfos.get(tabIndex));
        boolean bl = firstShowing = prev == null;
        if (!firstShowing && !leftGhostExists) {
            firstShowing = this.myInfo2Label.get((Object)prev).getBounds().width == 0;
        }
        boolean bl2 = lastShowing = next == null;
        if (!lastShowing) {
            lastShowing = this.myInfo2Label.get((Object)next).getBounds().width == 0;
        }
        boolean leftFromSelection = selected != null && tabIndex == this.myVisibleInfos.indexOf(selected) - 1;
        Rectangle originalBounds = effectiveBounds;
        ShapeTransform shape = this.getEffectiveLayout().createShapeTransform(originalBounds);
        int leftX = firstShowing ? shape.getX() : shape.getX() - shape.deltaX(arc + 1);
        int topY = shape.getY() + shape.deltaY(selectionTabVShift);
        int rigthX = !lastShowing && leftFromSelection ? shape.getMaxX() + shape.deltaX(arc + 1) : shape.getMaxX();
        int bottomY = shape.getMaxY() + shape.deltaY(1);
        shape.moveTo(leftX, bottomY);
        shape.lineTo(leftX, topY + shape.deltaY(arc));
        shape.quadTo(leftX, topY, leftX + shape.deltaX(arc), topY);
        shape.lineTo(rigthX - shape.deltaX(arc), topY);
        shape.quadTo(rigthX, topY, rigthX, topY + shape.deltaY(arc));
        shape.lineTo(rigthX, bottomY);
        if (!this.isSingleRow() && !(info = this.myTableLayout.myLastTableLayout).isInSelectionRow(label.getInfo())) {
            shape.lineTo(rigthX, bottomY + shape.deltaY(this.getArcSize()));
            shape.lineTo(leftX, bottomY + shape.deltaY(this.getArcSize()));
            shape.lineTo(leftX, bottomY);
        }
        shape.closePath();
        g2d.setColor(backgroundColor);
        g2d.fill(shape.getShape());
        Line2D.Float gradientLine = shape.transformLine(0, topY, 0, topY + shape.deltaY((int)((double)shape.getHeight() / 1.5)));
        GradientPaint gp = new GradientPaint(gradientLine.x1, gradientLine.y1, shape.transformY1(backgroundColor.brighter().brighter(), backgroundColor), gradientLine.x2, gradientLine.y2, shape.transformY1(backgroundColor, backgroundColor.brighter().brighter()));
        Paint old = g2d.getPaint();
        g2d.setPaint(gp);
        g2d.fill(shape.getShape());
        g2d.setPaint(old);
        g2d.setColor(topBlickColor);
        g2d.draw(shape.transformLine(leftX + shape.deltaX(arc + 1), topY + shape.deltaY(1), rigthX - shape.deltaX(arc - 1), topY + shape.deltaY(1)));
        g2d.setColor(rightBlockColor);
        g2d.draw(shape.transformLine(rigthX - shape.deltaX(1), topY + shape.deltaY(arc - 1), rigthX - shape.deltaX(1), bottomY));
        g2d.setColor(boundsColor);
        g2d.draw(shape.getShape());
    }

    public int getSelectionTabVShift() {
        return 2;
    }

    private void paintBorder(Graphics2D g2d, ShapeInfo shape, Color borderColor) {
        ShapeTransform shaper = shape.path.copy().reset();
        Insets paintBorder = shape.path.transformInsets(this.myBorder.getEffectiveBorder());
        int topY = shape.labelPath.getMaxY() + shape.labelPath.deltaY(1);
        int bottomY = topY + paintBorder.top - 2;
        int middleY = topY + (bottomY - topY) / 2;
        int boundsX = shape.path.getX() + shape.path.deltaX(shape.insets.left);
        int boundsY = this.isHideTabs() ? shape.path.getY() + shape.path.deltaY(shape.insets.top) : shape.labelPath.getMaxY() + shape.path.deltaY(1);
        int boundsHeight = Math.abs(shape.path.getMaxY() - boundsY) - shape.insets.bottom - paintBorder.bottom;
        int boundsWidth = Math.abs(shape.path.getMaxX() - (shape.insets.left + shape.insets.right));
        if (paintBorder.top > 0) {
            if (this.isHideTabs()) {
                if (this.isToDrawBorderIfTabsHidden()) {
                    g2d.setColor(borderColor);
                    g2d.fill(shaper.reset().doRect(boundsX, boundsY, boundsWidth, 1).getShape());
                }
            } else {
                Color tabFillColor = this.getActiveTabColor(null);
                if (tabFillColor == null) {
                    tabFillColor = shape.path.transformY1(shape.to, shape.from);
                }
                g2d.setColor(tabFillColor);
                g2d.fill(shaper.reset().doRect(boundsX, topY + shape.path.deltaY(1), boundsWidth, paintBorder.top - 1).getShape());
                g2d.setColor(borderColor);
                if (paintBorder.top == 2) {
                    Line2D.Float line = shape.path.transformLine(boundsX, topY, boundsX + shape.path.deltaX(boundsWidth - 1), topY);
                    g2d.drawLine((int)line.x1, (int)line.y1, (int)line.x2, (int)line.y2);
                } else if (paintBorder.top > 2) {
                    int deltaY = 0;
                    if (this.myPosition == JBTabsPosition.bottom || this.myPosition == JBTabsPosition.right) {
                        deltaY = 1;
                    }
                    int topLine = topY + shape.path.deltaY(paintBorder.top - 1);
                    g2d.fill(shaper.reset().doRect(boundsX, topLine + deltaY, boundsWidth - 1, 1).getShape());
                }
            }
        }
        g2d.setColor(borderColor);
        g2d.fill(shaper.reset().doRect(boundsX, Math.abs(shape.path.getMaxY() - shape.insets.bottom - paintBorder.bottom), boundsWidth, paintBorder.bottom).getShape());
        g2d.fill(shaper.reset().doRect(boundsX, boundsY, paintBorder.left, boundsHeight).getShape());
        g2d.fill(shaper.reset().doRect(shape.path.getMaxX() - shape.insets.right - paintBorder.right, boundsY, paintBorder.right, boundsHeight).getShape());
    }

    public boolean isStealthModeEffective() {
        return this.myStealthTabMode && this.getTabCount() == 1 && this.isSideComponentVertical() && this.getTabsPosition() == JBTabsPosition.top;
    }

    private boolean isNavigationVisible() {
        if (this.myStealthTabMode && this.getTabCount() == 1) {
            return false;
        }
        return !this.myVisibleInfos.isEmpty();
    }

    @Override
    public void paint(Graphics g) {
        Rectangle clip = g.getClipBounds();
        if (clip == null) {
            return;
        }
        if (this.myPaintBlocked) {
            if (this.myImage != null) {
                g.drawImage(this.myImage, 0, 0, this.getWidth(), this.getHeight(), null);
            }
            return;
        }
        super.paint(g);
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        GraphicsConfig config = new GraphicsConfig(g);
        config.setAntialiasing(true);
        this.paintSelectionAndBorder((Graphics2D)g);
        config.restore();
        TabLabel selected = this.getSelectedLabel();
        if (selected != null) {
            selected.paintImage(g);
        }
        this.mySingleRowLayout.myMoreIcon.paintIcon(this, g);
    }

    private Max computeMaxSize() {
        Max max = new Max();
        for (TabInfo eachInfo : this.myVisibleInfos) {
            TabLabel label = this.myInfo2Label.get(eachInfo);
            max.myLabel.height = Math.max(max.myLabel.height, label.getPreferredSize().height);
            max.myLabel.width = Math.max(max.myLabel.width, label.getPreferredSize().width);
            Toolbar toolbar = this.myInfo2Toolbar.get(eachInfo);
            if (!this.myLayout.isSideComponentOnTabs() || toolbar == null || toolbar.isEmpty()) continue;
            max.myToolbar.height = Math.max(max.myToolbar.height, toolbar.getPreferredSize().height);
            max.myToolbar.width = Math.max(max.myToolbar.width, toolbar.getPreferredSize().width);
        }
        ++max.myToolbar.height;
        return max;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.computeSize(new Transform<JComponent, Dimension>(){

            public Dimension transform(JComponent component) {
                return component.getMinimumSize();
            }
        }, 1);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.computeSize(new Transform<JComponent, Dimension>(){

            public Dimension transform(JComponent component) {
                return component.getPreferredSize();
            }
        }, 3);
    }

    private Dimension computeSize(Transform<JComponent, Dimension> transform, int tabCount) {
        Dimension size = new Dimension();
        for (TabInfo each : this.myVisibleInfos) {
            JComponent c = each.getComponent();
            if (c == null) continue;
            Dimension eachSize = (Dimension)transform.transform((Object)c);
            size.width = Math.max(eachSize.width, size.width);
            size.height = Math.max(eachSize.height, size.height);
        }
        this.addHeaderSize(size, tabCount);
        return size;
    }

    private void addHeaderSize(Dimension size, int tabsCount) {
        Dimension header = this.computeHeaderPreferredSize(tabsCount);
        size.height += header.height;
        size.width += header.width;
        Insets insets = this.getLayoutInsets();
        size.width += insets.left + insets.right + 1;
        size.height += insets.top + insets.bottom + 1;
    }

    private Dimension computeHeaderPreferredSize(int tabsCount) {
        boolean horizontal;
        Iterator<TabInfo> infos = this.myInfo2Label.keySet().iterator();
        Dimension size = new Dimension();
        int currentTab = 0;
        boolean bl = horizontal = this.getTabsPosition() == JBTabsPosition.top || this.getTabsPosition() == JBTabsPosition.bottom;
        while (infos.hasNext()) {
            boolean canGrow = currentTab < tabsCount;
            TabInfo eachInfo = infos.next();
            TabLabel eachLabel = this.myInfo2Label.get(eachInfo);
            Dimension eachPrefSize = eachLabel.getPreferredSize();
            if (horizontal) {
                if (canGrow) {
                    size.width += eachPrefSize.width;
                }
                size.height = Math.max(size.height, eachPrefSize.height);
            } else {
                size.width = Math.max(size.width, eachPrefSize.width);
                if (canGrow) {
                    size.height += eachPrefSize.height;
                }
            }
            ++currentTab;
        }
        if (this.isSingleRow() && this.isGhostsAlwaysVisible()) {
            if (horizontal) {
                size.width += this.getGhostTabLength() * 2;
            } else {
                size.height += this.getGhostTabLength() * 2;
            }
        }
        if (horizontal) {
            size.height += this.myBorder.getTabBorderSize();
        } else {
            size.width += this.myBorder.getTabBorderSize();
        }
        return size;
    }

    @Override
    public int getTabCount() {
        return this.getTabs().size();
    }

    @Override
    @NotNull
    public JBTabsPresentation getPresentation() {
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/tabs/impl/JBTabsImpl.getPresentation must not return null");
        }
        return jBTabsImpl;
    }

    public ActionCallback removeTab(JComponent component) {
        return this.removeTab(this.findInfo(component));
    }

    @Override
    public ActionCallback removeTab(TabInfo info) {
        return this.removeTab(info, null);
    }

    @Override
    public ActionCallback removeTab(TabInfo info, @Nullable TabInfo forcedSelectionTranfer) {
        return this.removeTab(info, forcedSelectionTranfer, true);
    }

    @Override
    public ActionCallback removeTab(TabInfo info, @Nullable TabInfo forcedSelectionTranfer, boolean transferFocus) {
        TabInfo toSelect;
        if (info == null || !this.getTabs().contains(info)) {
            return new ActionCallback.Done();
        }
        final ActionCallback result = new ActionCallback();
        if (forcedSelectionTranfer == null) {
            toSelect = this.getToSelectOnRemoveOf(info);
        } else {
            assert (this.myVisibleInfos.contains(forcedSelectionTranfer)) : "Cannot find tab for selection transfer, tab=" + forcedSelectionTranfer;
            toSelect = forcedSelectionTranfer;
        }
        if (toSelect != null) {
            this.processRemove(info, false);
            this._setSelected(toSelect, transferFocus).doWhenProcessed(new Runnable(){

                @Override
                public void run() {
                    JBTabsImpl.this.removeDeferred().notifyWhenDone(result);
                }
            });
        } else {
            this.processRemove(info, true);
            this.removeDeferred().notifyWhenDone(result);
        }
        if (this.myVisibleInfos.isEmpty()) {
            this.removeDeferredNow();
        }
        this.revalidateAndRepaint(true);
        return result;
    }

    private void processRemove(TabInfo info, boolean forcedNow) {
        this.remove(this.myInfo2Label.get(info));
        this.remove(this.myInfo2Toolbar.get(info));
        JComponent tabComponent = info.getComponent();
        if (!this.isToDeferRemoveForLater(tabComponent) || forcedNow) {
            this.remove(tabComponent);
        } else {
            this.queueForRemove(tabComponent);
        }
        this.myVisibleInfos.remove(info);
        this.myHiddenInfos.remove(info);
        this.myInfo2Label.remove(info);
        this.myInfo2Toolbar.remove(info);
        this.resetTabsCache();
        this.updateAll(false, false);
    }

    @Override
    public TabInfo findInfo(Component component) {
        for (TabInfo each : this.getTabs()) {
            if (each.getComponent() != component) continue;
            return each;
        }
        return null;
    }

    public TabInfo findInfo(String text) {
        if (text == null) {
            return null;
        }
        for (TabInfo each : this.getTabs()) {
            if (!text.equals(each.getText())) continue;
            return each;
        }
        return null;
    }

    @Override
    public TabInfo findInfo(MouseEvent event) {
        return this.findInfo(event, false);
    }

    private TabInfo findInfo(MouseEvent event, boolean labelsOnly) {
        Point point = SwingUtilities.convertPoint(event.getComponent(), event.getPoint(), this);
        return this._findInfo(point, labelsOnly);
    }

    @Override
    public TabInfo findInfo(Object object) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            TabInfo each = this.getTabAt(i);
            Object eachObject = each.getObject();
            if (eachObject == null || !eachObject.equals(object)) continue;
            return each;
        }
        return null;
    }

    public TabInfo findTabLabelBy(Point point) {
        return this._findInfo(point, true);
    }

    private TabInfo _findInfo(Point point, boolean labelsOnly) {
        Component component = this.findComponentAt(point);
        if (component == null) {
            return null;
        }
        while (component != this || component != null) {
            TabInfo info;
            if (component instanceof TabLabel) {
                return ((TabLabel)component).getInfo();
            }
            if (!labelsOnly && (info = this.findInfo(component)) != null) {
                return info;
            }
            if (component == null) break;
            component = component.getParent();
        }
        return null;
    }

    @Override
    public void removeAllTabs() {
        for (TabInfo each : this.getTabs()) {
            this.removeTab(each);
        }
    }

    private void updateContainer(boolean forced, boolean layoutNow) {
        TabLabel selectedLabel = this.getSelectedLabel();
        for (TabInfo each : this.myVisibleInfos) {
            JComponent eachComponent = each.getComponent();
            if (this.getSelectedInfo() == each && this.getSelectedInfo() != null) {
                this.unqueueFromRemove(eachComponent);
                Container parent = eachComponent.getParent();
                if (parent != null && parent != this) {
                    parent.remove(eachComponent);
                }
                if (eachComponent.getParent() != null) continue;
                this.add(eachComponent);
                continue;
            }
            if (eachComponent.getParent() == null) continue;
            if (this.isToDeferRemoveForLater(eachComponent)) {
                this.queueForRemove(eachComponent);
                continue;
            }
            this.remove(eachComponent);
        }
        this.relayout(forced, layoutNow);
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        this.unqueueFromRemove(comp);
        if (comp instanceof TabLabel) {
            ((TabLabel)comp).apply(this.myUiDecorator.getDecoration());
        }
        super.addImpl(comp, constraints, index);
    }

    private boolean isToDeferRemoveForLater(JComponent c) {
        return c.getRootPane() != null;
    }

    void relayout(boolean forced, boolean layoutNow) {
        if (!this.myForcedRelayout) {
            this.myForcedRelayout = forced;
        }
        this.revalidateAndRepaint(layoutNow);
    }

    ActionManager getActionManager() {
        return this.myActionManager;
    }

    public TabsBorder getTabsBorder() {
        return this.myBorder;
    }

    @NotNull
    public JBTabs addTabMouseMotionListener(@NotNull MouseMotionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/impl/JBTabsImpl.addTabMouseMotionListener must not be null");
        }
        this.removeListeners();
        this.myTabMouseListeners.add(listener);
        this.addListeners();
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/tabs/impl/JBTabsImpl.addTabMouseMotionListener must not return null");
        }
        return jBTabsImpl;
    }

    @Override
    @NotNull
    public JBTabs addTabMouseListener(@NotNull MouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/impl/JBTabsImpl.addTabMouseListener must not be null");
        }
        this.removeListeners();
        this.myTabMouseListeners.add(listener);
        this.addListeners();
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/tabs/impl/JBTabsImpl.addTabMouseListener must not return null");
        }
        return jBTabsImpl;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/tabs/impl/JBTabsImpl.getComponent must not return null");
        }
        return jBTabsImpl;
    }

    @Override
    @NotNull
    public JBTabs removeTabMouseListener(@NotNull MouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/impl/JBTabsImpl.removeTabMouseListener must not be null");
        }
        this.removeListeners();
        this.myTabMouseListeners.remove(listener);
        this.addListeners();
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/tabs/impl/JBTabsImpl.removeTabMouseListener must not return null");
        }
        return jBTabsImpl;
    }

    private void addListeners() {
        for (TabInfo eachInfo : this.myVisibleInfos) {
            TabLabel label = this.myInfo2Label.get(eachInfo);
            for (EventListener eachListener : this.myTabMouseListeners) {
                if (eachListener instanceof MouseListener) {
                    label.addMouseListener((MouseListener)eachListener);
                    continue;
                }
                if (eachListener instanceof MouseMotionListener) {
                    label.addMouseMotionListener((MouseMotionListener)eachListener);
                    continue;
                }
                assert (false);
            }
        }
    }

    private void removeListeners() {
        for (TabInfo eachInfo : this.myVisibleInfos) {
            TabLabel label = this.myInfo2Label.get(eachInfo);
            for (EventListener eachListener : this.myTabMouseListeners) {
                if (eachListener instanceof MouseListener) {
                    label.removeMouseListener((MouseListener)eachListener);
                    continue;
                }
                if (eachListener instanceof MouseMotionListener) {
                    label.removeMouseMotionListener((MouseMotionListener)eachListener);
                    continue;
                }
                assert (false);
            }
        }
    }

    private void updateListeners() {
        this.removeListeners();
        this.addListeners();
    }

    @Override
    public JBTabs addListener(@NotNull TabsListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/impl/JBTabsImpl.addListener must not be null");
        }
        this.myTabListeners.add(listener);
        return this;
    }

    @Override
    public JBTabs removeListener(@NotNull TabsListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/impl/JBTabsImpl.removeListener must not be null");
        }
        this.myTabListeners.remove(listener);
        return this;
    }

    protected void onPopup(TabInfo popupInfo) {
    }

    @Override
    public void setFocused(boolean focused) {
        if (this.myFocused == focused) {
            return;
        }
        this.myFocused = focused;
        if (this.myPaintFocus) {
            this.repaint();
        }
    }

    @Override
    public int getIndexOf(@Nullable TabInfo tabInfo) {
        return this.myVisibleInfos.indexOf(tabInfo);
    }

    @Override
    public boolean isHideTabs() {
        return this.myHideTabs;
    }

    @Override
    public void setHideTabs(boolean hideTabs) {
        if (this.isHideTabs() == hideTabs) {
            return;
        }
        this.myHideTabs = hideTabs;
        this.relayout(true, false);
    }

    @Override
    public JBTabsPresentation setPaintBorder(int top, int left, int right, int bottom) {
        return this.myBorder.setPaintBorder(top, left, right, bottom);
    }

    @Override
    public JBTabsPresentation setTabSidePaintBorder(int size) {
        return this.myBorder.setTabSidePaintBorder(size);
    }

    static int getBorder(int size) {
        return size == -1 ? 1 : size;
    }

    @Override
    public boolean isPaintFocus() {
        return this.myPaintFocus;
    }

    @Override
    @NotNull
    public JBTabsPresentation setAdjustBorders(boolean adjust) {
        this.myAdjustBorders = adjust;
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/tabs/impl/JBTabsImpl.setAdjustBorders must not return null");
        }
        return jBTabsImpl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public JBTabsPresentation setActiveTabFillIn(@Nullable Color color) {
        JBTabsImpl jBTabsImpl;
        if (!this.isChanged(this.myActiveTabFillIn, color)) {
            jBTabsImpl = this;
            if (jBTabsImpl == null) throw new IllegalStateException("@NotNull method com/intellij/ui/tabs/impl/JBTabsImpl.setActiveTabFillIn must not return null");
            return jBTabsImpl;
        }
        this.myActiveTabFillIn = color;
        this.revalidateAndRepaint(false);
        jBTabsImpl = this;
        if (jBTabsImpl != null) return jBTabsImpl;
        throw new IllegalStateException("@NotNull method com/intellij/ui/tabs/impl/JBTabsImpl.setActiveTabFillIn must not return null");
    }

    private boolean isChanged(Object oldObject, Object newObject) {
        if (oldObject == null && newObject == null) {
            return false;
        }
        return oldObject != null && !oldObject.equals(newObject) || newObject != null && !newObject.equals(oldObject);
    }

    @Override
    @NotNull
    public JBTabsPresentation setTabLabelActionsAutoHide(boolean autoHide) {
        if (this.myTabLabelActionsAutoHide != autoHide) {
            this.myTabLabelActionsAutoHide = autoHide;
            this.revalidateAndRepaint(false);
        }
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/tabs/impl/JBTabsImpl.setTabLabelActionsAutoHide must not return null");
        }
        return jBTabsImpl;
    }

    @Nullable
    public Color getActiveTabFillIn() {
        return this.myActiveTabFillIn;
    }

    @Override
    public JBTabsPresentation setFocusCycle(boolean root) {
        this.setFocusCycleRoot(root);
        return this;
    }

    @Override
    public JBTabsPresentation setPaintFocus(boolean paintFocus) {
        this.myPaintFocus = paintFocus;
        return this;
    }

    private void disposePopupListener() {
        if (this.myActivePopup != null) {
            this.myActivePopup.removePopupMenuListener(this.myPopupListener);
            this.myActivePopup = null;
        }
    }

    @Override
    public JBTabsPresentation setStealthTabMode(boolean stealthTabMode) {
        this.myStealthTabMode = stealthTabMode;
        this.relayout(true, false);
        return this;
    }

    @Override
    public boolean isStealthTabMode() {
        return this.myStealthTabMode;
    }

    @Override
    public JBTabsPresentation setSideComponentVertical(boolean vertical) {
        this.myHorizontalSide = !vertical;
        for (TabInfo each : this.myVisibleInfos) {
            each.getChangeSupport().firePropertyChange("actionGroup", "new1", "new2");
        }
        this.relayout(true, false);
        return this;
    }

    @Override
    public JBTabsPresentation setSingleRow(boolean singleRow) {
        this.myLayout = singleRow ? this.mySingleRowLayout : this.myTableLayout;
        this.relayout(true, false);
        return this;
    }

    @Override
    public JBTabsPresentation setGhostsAlwaysVisible(boolean visible) {
        this.myGhostsAlwaysVisible = visible;
        this.relayout(true, false);
        return this;
    }

    @Override
    public boolean isGhostsAlwaysVisible() {
        return this.myGhostsAlwaysVisible;
    }

    @Override
    public boolean isSingleRow() {
        return this.getEffectiveLayout() == this.mySingleRowLayout;
    }

    @Override
    public boolean isSideComponentVertical() {
        return !this.myHorizontalSide;
    }

    private TabLayout getEffectiveLayout() {
        if (this.myLayout == this.myTableLayout && this.getTabsPosition() == JBTabsPosition.top) {
            return this.myTableLayout;
        }
        return this.mySingleRowLayout;
    }

    @Override
    public JBTabsPresentation setUiDecorator(UiDecorator decorator) {
        this.myUiDecorator = decorator == null ? ourDefaultDecorator : decorator;
        this.applyDecoration();
        return this;
    }

    @Override
    protected void setUI(ComponentUI newUI) {
        super.setUI(newUI);
        this.applyDecoration();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JBTabsImpl.this.applyDecoration();
                JBTabsImpl.this.revalidateAndRepaint(false);
            }
        });
    }

    private void applyDecoration() {
        if (this.myUiDecorator != null) {
            UiDecorator.UiDecoration uiDecoration = this.myUiDecorator.getDecoration();
            for (TabLabel each : this.myInfo2Label.values()) {
                each.apply(uiDecoration);
            }
        }
        for (TabInfo each : this.getTabs()) {
            this.adjust(each);
        }
        this.relayout(true, false);
    }

    private void adjust(TabInfo each) {
        if (this.myAdjustBorders) {
            UIUtil.removeScrollBorder((Component)each.getComponent());
        }
    }

    @Override
    public void sortTabs(Comparator<TabInfo> comparator) {
        Collections.sort(this.myVisibleInfos, comparator);
        this.relayout(true, false);
    }

    @Override
    public boolean isRequestFocusOnLastFocusedComponent() {
        return this.myRequestFocusOnLastFocusedComponent;
    }

    @Override
    public JBTabsPresentation setRequestFocusOnLastFocusedComponent(boolean requestFocusOnLastFocusedComponent) {
        this.myRequestFocusOnLastFocusedComponent = requestFocusOnLastFocusedComponent;
        return this;
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        Object value;
        if (this.myDataProvider != null && (value = this.myDataProvider.getData(dataId)) != null) {
            return value;
        }
        return NAVIGATION_ACTIONS_KEY.is(dataId) ? this : null;
    }

    @Override
    public DataProvider getDataProvider() {
        return this.myDataProvider;
    }

    @Override
    public JBTabsImpl setDataProvider(@NotNull DataProvider dataProvider) {
        if (dataProvider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/impl/JBTabsImpl.setDataProvider must not be null");
        }
        this.myDataProvider = dataProvider;
        return this;
    }

    public boolean isSelectionClick(MouseEvent e, boolean canBeQuick) {
        if ((e.getClickCount() == 1 || canBeQuick) && !e.isPopupTrigger()) {
            return e.getButton() == 1 && !e.isControlDown() && !e.isAltDown() && !e.isMetaDown();
        }
        return false;
    }

    public static Rectangle layout(JComponent c, Rectangle bounds) {
        Rectangle now = c.getBounds();
        if (!bounds.equals(now)) {
            c.setBounds(bounds);
        }
        c.putClientProperty(LAYOUT_DONE, Boolean.TRUE);
        return bounds;
    }

    public static Rectangle layout(JComponent c, int x, int y, int width, int height) {
        return JBTabsImpl.layout(c, new Rectangle(x, y, width, height));
    }

    public static void resetLayout(JComponent c) {
        if (c == null) {
            return;
        }
        c.putClientProperty(LAYOUT_DONE, null);
    }

    private void applyResetComponents() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            JComponent jc;
            Object done;
            Component each = this.getComponent(i);
            if (!(each instanceof JComponent) || Boolean.TRUE.equals(done = (jc = (JComponent)each).getClientProperty(LAYOUT_DONE))) continue;
            JBTabsImpl.layout(jc, new Rectangle(0, 0, 0, 0));
        }
    }

    @Override
    @NotNull
    public JBTabsPresentation setTabLabelActionsMouseDeadzone(TimedDeadzone.Length length) {
        this.myTabActionsMouseDeadzone = length;
        List<TabInfo> all = this.getTabs();
        for (TabInfo each : all) {
            TabLabel eachLabel = this.myInfo2Label.get(each);
            eachLabel.updateTabActions();
        }
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/tabs/impl/JBTabsImpl.setTabLabelActionsMouseDeadzone must not return null");
        }
        return jBTabsImpl;
    }

    @Override
    @NotNull
    public JBTabsPresentation setTabsPosition(JBTabsPosition position) {
        this.myPosition = position;
        this.relayout(true, false);
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/tabs/impl/JBTabsImpl.setTabsPosition must not return null");
        }
        return jBTabsImpl;
    }

    @Override
    public JBTabsPosition getTabsPosition() {
        return this.myPosition;
    }

    public TimedDeadzone.Length getTabActionsMouseDeadzone() {
        return this.myTabActionsMouseDeadzone;
    }

    @Override
    public JBTabsPresentation setTabDraggingEnabled(boolean enabled) {
        this.myTabDraggingEnabled = enabled;
        return this;
    }

    @Override
    public boolean isTabDraggingEnabled() {
        return this.myTabDraggingEnabled && this.isSingleRow();
    }

    void reallocate(TabInfo source, TabInfo target, boolean before) {
        if (source == target || source == null || target == null) {
            return;
        }
        int targetIndex = this.myVisibleInfos.indexOf(target);
        int sourceIndex = this.myVisibleInfos.indexOf(source);
        boolean needsValidation = false;
        this.myVisibleInfos.remove(source);
        this.myVisibleInfos.add(targetIndex, source);
        needsValidation = true;
        if (needsValidation) {
            this.invalidate();
            this.relayout(true, true);
        }
    }

    boolean isHorizontalTabs() {
        return this.getTabsPosition() == JBTabsPosition.top || this.getTabsPosition() == JBTabsPosition.bottom;
    }

    @Override
    public void putInfo(Map<String, String> info) {
        TabInfo selected = this.getSelectedInfo();
        if (selected != null) {
            selected.putInfo(info);
        }
    }

    public boolean isUseBufferedPaint() {
        return this.myUseBufferedPaint;
    }

    public void setUseBufferedPaint(boolean useBufferedPaint) {
        this.myUseBufferedPaint = useBufferedPaint;
        this.revalidate();
        this.repaint();
    }

    private static class DefautDecorator
    implements UiDecorator {
        private DefautDecorator() {
        }

        @Override
        @NotNull
        public UiDecorator.UiDecoration getDecoration() {
            UiDecorator.UiDecoration uiDecoration = new UiDecorator.UiDecoration(null, new Insets(1, 4, 1, 5));
            if (uiDecoration == null) {
                throw new IllegalStateException("@NotNull method com/intellij/ui/tabs/impl/JBTabsImpl$DefautDecorator.getDecoration must not return null");
            }
            return uiDecoration;
        }
    }

    private static class SelectPreviousAction
    extends BaseNavigationAction {
        private SelectPreviousAction(JBTabsImpl tabs, ActionManager mgr) {
            super("PreviousTab", tabs, mgr);
        }

        @Override
        protected void _update(AnActionEvent e, JBTabsImpl tabs, int selectedIndex) {
            e.getPresentation().setEnabled(tabs.findEnabledBackward(selectedIndex - 1) != null);
        }

        @Override
        protected void _actionPerformed(AnActionEvent e, JBTabsImpl tabs, int selectedIndex) {
            tabs.select(tabs.findEnabledBackward(selectedIndex - 1), true);
        }
    }

    private static class SelectNextAction
    extends BaseNavigationAction {
        private SelectNextAction(JBTabsImpl tabs, ActionManager mgr) {
            super("NextTab", tabs, mgr);
        }

        @Override
        protected void _update(AnActionEvent e, JBTabsImpl tabs, int selectedIndex) {
            e.getPresentation().setEnabled(tabs.findEnabledForward(selectedIndex + 1) != null);
        }

        @Override
        protected void _actionPerformed(AnActionEvent e, JBTabsImpl tabs, int selectedIndex) {
            tabs.select(tabs.findEnabledForward(selectedIndex + 1), true);
        }
    }

    private static abstract class BaseNavigationAction
    extends AnAction {
        private final ShadowAction myShadow;
        private final ActionManager myActionManager;
        private final JBTabsImpl myTabs;

        protected BaseNavigationAction(String copyFromID, JBTabsImpl tabs, ActionManager mgr) {
            this.myActionManager = mgr;
            this.myTabs = tabs;
            this.myShadow = new ShadowAction(this, this.myActionManager.getAction(copyFromID), tabs);
            Disposer.register((Disposable)tabs, (Disposable)this.myShadow);
            this.setEnabledInModalContext(true);
        }

        @Override
        public final void update(AnActionEvent e) {
            JBTabsImpl tabs = e.getData(NAVIGATION_ACTIONS_KEY);
            e.getPresentation().setVisible(tabs != null);
            if (tabs == null) {
                return;
            }
            int selectedIndex = tabs.myVisibleInfos.indexOf(tabs.getSelectedInfo());
            boolean enabled = tabs == this.myTabs && this.myTabs.isNavigationVisible() && selectedIndex >= 0 && this.myTabs.myNavigationActionsEnabled;
            e.getPresentation().setEnabled(enabled);
            if (enabled) {
                this._update(e, tabs, selectedIndex);
            }
        }

        public void reconnect(String actionId) {
            this.myShadow.reconnect(this.myActionManager.getAction(actionId));
        }

        protected abstract void _update(AnActionEvent var1, JBTabsImpl var2, int var3);

        @Override
        public final void actionPerformed(AnActionEvent e) {
            JBTabsImpl tabs = e.getData(NAVIGATION_ACTIONS_KEY);
            if (tabs == null) {
                return;
            }
            int index = tabs.myVisibleInfos.indexOf(tabs.getSelectedInfo());
            if (index == -1) {
                return;
            }
            this._actionPerformed(e, tabs, index);
        }

        protected abstract void _actionPerformed(AnActionEvent var1, JBTabsImpl var2, int var3);
    }

    private static class Max {
        Dimension myLabel = new Dimension();
        Dimension myToolbar = new Dimension();

        private Max() {
        }
    }

    static class ShapeInfo {
        ShapeTransform path;
        ShapeTransform fillPath;
        ShapeTransform labelPath;
        int labelBottomY;
        int labelTopY;
        int labelLeftX;
        int labelRightX;
        Insets insets;
        Color from;
        Color to;

        ShapeInfo() {
        }
    }

    public static class Toolbar
    extends JPanel {
        private final JBTabsImpl myTabs;
        private final TabInfo myInfo;

        public Toolbar(JBTabsImpl tabs, TabInfo info) {
            this.myTabs = tabs;
            this.myInfo = info;
            this.setLayout(new BorderLayout());
            ActionGroup group = info.getGroup();
            JComponent side = info.getSideComponent();
            if (group != null && this.myTabs.myActionManager != null) {
                String place = info.getPlace();
                ActionToolbar toolbar = this.myTabs.myActionManager.createActionToolbar(place != null ? place : "unknown", group, this.myTabs.myHorizontalSide);
                toolbar.setTargetComponent(info.getActionsContextComponent());
                JComponent actionToolbar = toolbar.getComponent();
                this.add((Component)actionToolbar, "Center");
            }
            if (side != null) {
                if (group != null) {
                    this.add((Component)side, "East");
                } else {
                    this.add((Component)side, "Center");
                }
            }
        }

        public boolean isEmpty() {
            return this.getComponentCount() == 0;
        }
    }

    class TabActionsAutoHideListener
    extends MouseMotionAdapter {
        private TabLabel myCurrentOverLabel;
        private Point myLastOverPoint;

        TabActionsAutoHideListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point point;
            if (!JBTabsImpl.this.myTabLabelActionsAutoHide) {
                return;
            }
            this.myLastOverPoint = point = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), JBTabsImpl.this);
            this.processMouseOver();
        }

        void processMouseOver() {
            TabLabel label;
            if (!JBTabsImpl.this.myTabLabelActionsAutoHide) {
                return;
            }
            if (this.myLastOverPoint == null) {
                return;
            }
            if (this.myLastOverPoint.x >= 0 && this.myLastOverPoint.x < JBTabsImpl.this.getWidth() && this.myLastOverPoint.y > 0 && this.myLastOverPoint.y < JBTabsImpl.this.getHeight() && (label = JBTabsImpl.this.myInfo2Label.get(JBTabsImpl.this._findInfo(this.myLastOverPoint, true))) != null) {
                if (this.myCurrentOverLabel != null) {
                    this.myCurrentOverLabel.toggleShowActions(false);
                }
                label.toggleShowActions(true);
                this.myCurrentOverLabel = label;
                return;
            }
            if (this.myCurrentOverLabel != null) {
                this.myCurrentOverLabel.toggleShowActions(false);
                this.myCurrentOverLabel = null;
            }
        }
    }
}

