/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.util.Condition;
import com.intellij.ui.LightColors;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.util.Function;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class ListWithFilter<T>
extends JPanel {
    private final JList myList;
    private final JTextField mySpeedSearchPatternField;
    private final NameFilteringListModel<T> myModel;
    private final JScrollPane myScroller;
    private final MySpeedSearch mySpeedSearch;

    public static JComponent wrap(JList list) {
        return ListWithFilter.wrap(list, new JScrollPane(list), new Function<Object, String>(){

            public String fun(Object o) {
                return o.toString();
            }
        });
    }

    public static <T> JComponent wrap(JList list, JScrollPane scroller, Function<T, String> namer) {
        return new ListWithFilter<T>(list, scroller, namer);
    }

    private ListWithFilter(JList list, JScrollPane scroller, Function<T, String> namer) {
        super(new BorderLayout());
        this.myList = list;
        this.myScroller = scroller;
        this.mySpeedSearchPatternField = new JTextField();
        this.mySpeedSearchPatternField.setFocusable(false);
        this.mySpeedSearchPatternField.setVisible(false);
        this.add((Component)this.mySpeedSearchPatternField, "North");
        this.add((Component)this.myScroller, "Center");
        this.mySpeedSearch = new MySpeedSearch();
        this.mySpeedSearch.setEnabled(namer != null);
        this.myList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ListWithFilter.this.mySpeedSearch.process(e);
            }
        });
        this.myModel = new NameFilteringListModel<T>(this.myList, namer, new Condition<String>(){

            public boolean value(String s) {
                return ListWithFilter.this.mySpeedSearch.shouldBeShowing(s);
            }
        }, this.mySpeedSearch);
        this.setBackground(list.getBackground());
    }

    public boolean resetFilter() {
        boolean hadPattern = this.mySpeedSearch.isHoldingFilter();
        this.mySpeedSearch.reset();
        return hadPattern;
    }

    protected void onSpeedSearchPatternChanged() {
        this.myModel.refilter();
        if (this.myModel.getSize() > 0) {
            int fullMatchIndex = this.myModel.getClosestMatchIndex();
            if (fullMatchIndex != -1) {
                this.myList.setSelectedIndex(fullMatchIndex);
            }
            if (this.myModel.getSize() <= this.myList.getSelectedIndex() || !this.myModel.contains(this.myList.getSelectedValue())) {
                this.myList.setSelectedIndex(0);
            }
        } else {
            this.mySpeedSearchPatternField.setBackground(LightColors.RED);
        }
    }

    public JList getList() {
        return this.myList;
    }

    public JScrollPane getScrollPane() {
        return this.myScroller;
    }

    @Override
    public void requestFocus() {
        this.myList.requestFocus();
    }

    private class MySpeedSearch
    extends SpeedSearch {
        boolean searchFieldShown = false;

        private MySpeedSearch() {
        }

        @Override
        protected void update() {
            ListWithFilter.this.mySpeedSearchPatternField.setBackground(new JTextField().getBackground());
            ListWithFilter.this.onSpeedSearchPatternChanged();
            ListWithFilter.this.mySpeedSearchPatternField.setText(this.getFilter());
            if (this.isHoldingFilter() && !this.searchFieldShown) {
                ListWithFilter.this.mySpeedSearchPatternField.setVisible(true);
                this.searchFieldShown = true;
                ListWithFilter.this.revalidate();
            } else if (!this.isHoldingFilter() && this.searchFieldShown) {
                ListWithFilter.this.mySpeedSearchPatternField.setVisible(false);
                this.searchFieldShown = false;
                ListWithFilter.this.revalidate();
            }
        }
    }
}

