/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;

public class GuiUtils {
    private static final Insets paddingFromDialogBoundaries = new Insets(7, 5, 7, 5);
    private static final Insets paddingInsideDialog = new Insets(5, 5, 5, 5);
    public static final int lengthForFileField = 25;

    public static JPanel constructFieldWithBrowseButton(JComponent aComponent, ActionListener aActionListener) {
        return GuiUtils.constructFieldWithBrowseButton(aComponent, aActionListener, 0);
    }

    public static JPanel constructFieldWithBrowseButton(TextFieldWithHistory aComponent, ActionListener aActionListener) {
        return GuiUtils.constructFieldWithBrowseButton(aComponent, aActionListener, 0);
    }

    private static JPanel constructFieldWithBrowseButton(JComponent aComponent, ActionListener aActionListener, int delta) {
        JPanel result = new JPanel(new GridBagLayout());
        result.add((Component)aComponent, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        FixedSizeButton browseButton = new FixedSizeButton(aComponent.getPreferredSize().height - delta);
        ComponentWithBrowseButton.MyDoClickAction.addTo(browseButton, aComponent);
        result.add((Component)browseButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        browseButton.addActionListener(aActionListener);
        return result;
    }

    public static JPanel constructDirectoryBrowserField(final JTextField aTextField, final String aSearchedObjectName) {
        return GuiUtils.constructFieldWithBrowseButton(aTextField, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.getDirectoryChooserDescriptor(aSearchedObjectName);
                VirtualFile[] files = FileChooser.chooseFiles(aTextField, descriptor);
                if (files.length != 0) {
                    aTextField.setText(FileUtil.toSystemDependentName((String)files[0].getPath()));
                    aTextField.postActionEvent();
                }
            }
        });
    }

    public static JPanel constructFileURLBrowserField(final TextFieldWithHistory aFieldWithHistory, final String aSearchedObjectName) {
        return GuiUtils.constructFieldWithBrowseButton(aFieldWithHistory, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.getFileChooserDescriptor(aSearchedObjectName);
                VirtualFile[] files = FileChooser.chooseFiles(aFieldWithHistory, descriptor);
                if (files.length != 0) {
                    try {
                        aFieldWithHistory.setText(VfsUtil.virtualToIoFile(files[0]).toURL().toString());
                    }
                    catch (MalformedURLException e1) {
                        aFieldWithHistory.setText("");
                    }
                }
            }
        });
    }

    public static JComponent constructLabeledComponent(String aLabelText, JComponent aComponent, int aAxis) {
        JPanel result = new JPanel();
        BoxLayout boxLayout = new BoxLayout(result, aAxis);
        result.setLayout(boxLayout);
        result.add(new JLabel(aLabelText));
        result.add(aComponent);
        return result;
    }

    public static JPanel makeDialogPanel(JPanel aPanel) {
        JPanel emptyBordered = GuiUtils.makePaddedPanel(aPanel, paddingFromDialogBoundaries);
        return GuiUtils.wrapWithBorder(emptyBordered, IdeBorderFactory.createBorder());
    }

    public static JPanel makeTitledPanel(JComponent aComponent, String aTitle) {
        JPanel result = GuiUtils.makePaddedPanel(aComponent, false, true, false, true);
        return GuiUtils.wrapWithBorder(result, IdeBorderFactory.createTitledBorder(aTitle));
    }

    private static JPanel wrapWithBorder(JComponent aPanel, Border aBorder) {
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)aPanel, "Center");
        wrapper.setBorder(aBorder);
        return wrapper;
    }

    public static BorderLayout createBorderLayout() {
        return new BorderLayout(GuiUtils.paddingInsideDialog.left, GuiUtils.paddingInsideDialog.top);
    }

    public static GridLayout createGridLayout(int aRows, int aColumns) {
        return new GridLayout(aRows, aColumns, GuiUtils.paddingInsideDialog.left, GuiUtils.paddingInsideDialog.top);
    }

    public static Component createVerticalStrut() {
        return Box.createRigidArea(new Dimension(0, GuiUtils.paddingInsideDialog.top));
    }

    public static Component createHorisontalStrut() {
        return Box.createRigidArea(new Dimension(GuiUtils.paddingInsideDialog.left, 0));
    }

    private static JPanel makePaddedPanel(JComponent aComponent, Insets aInsets) {
        return GuiUtils.wrapWithBorder(aComponent, BorderFactory.createEmptyBorder(aInsets.top, aInsets.left, aInsets.bottom, aInsets.right));
    }

    private static JPanel makePaddedPanel(JComponent aComponent, boolean aTop, boolean aLeft, boolean aBottom, boolean aRight) {
        return GuiUtils.wrapWithBorder(aComponent, BorderFactory.createEmptyBorder(aTop ? GuiUtils.paddingInsideDialog.top : 0, aLeft ? GuiUtils.paddingInsideDialog.left : 0, aBottom ? GuiUtils.paddingInsideDialog.bottom : 0, aRight ? GuiUtils.paddingInsideDialog.right : 0));
    }

    public static void setAdditionalIcon(JRadioButton button, Icon icon) {
        Icon defaultIcon = UIUtil.getRadioButtonIcon();
        LayeredIcon deficon = new LayeredIcon(2);
        deficon.setIcon(defaultIcon, 0);
        deficon.setIcon(icon, 1, defaultIcon.getIconWidth() + 5, 0);
        button.setIcon(deficon);
        LayeredIcon pressed = new LayeredIcon(2);
        pressed.setIcon(defaultIcon, 0);
        pressed.setIcon(icon, 1, defaultIcon.getIconWidth() + 5, 0);
        button.setPressedIcon(pressed);
        LayeredIcon selected = new LayeredIcon(2);
        selected.setIcon(defaultIcon, 0);
        selected.setIcon(icon, 1, defaultIcon.getIconWidth() + 5, 0);
        button.setSelectedIcon(selected);
    }

    public static String getTextWithoutMnemonicEscaping(String text) {
        return StringUtil.replace((String)text, (String)String.valueOf('\u001b'), (String)"");
    }

    public static char getDisplayedMnemonic(String text) {
        int i = GuiUtils.getDisplayedMnemonicIndex(text);
        return i == -1 ? (char)'\uffff' : text.charAt(i + 1);
    }

    public static int getDisplayedMnemonicIndex(String text) {
        return text.indexOf("&");
    }

    public static void packParentDialog(Component component) {
        while (component != null) {
            if (component instanceof JDialog) {
                component.setVisible(true);
                break;
            }
            component = component.getParent();
        }
    }

    public static void replaceJSplitPaneWithIDEASplitter(JComponent root) {
        final Container parent = root.getParent();
        if (root instanceof JSplitPane) {
            if (parent.getComponents().length != 1 && !(parent instanceof Splitter)) {
                return;
            }
            final JSplitPane pane = (JSplitPane)root;
            Component component1 = pane.getTopComponent();
            Component component2 = pane.getBottomComponent();
            int orientation = pane.getOrientation();
            final Splitter splitter = new Splitter(orientation == 0);
            splitter.setFirstComponent((JComponent)component1);
            splitter.setSecondComponent((JComponent)component2);
            splitter.setShowDividerControls(pane.isOneTouchExpandable());
            splitter.setHonorComponentsMinimumSize(true);
            if (pane.getDividerLocation() > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        double proportion = pane.getOrientation() == 0 ? (double)pane.getDividerLocation() / (double)(parent.getHeight() - pane.getDividerSize()) : (double)pane.getDividerLocation() / (double)(parent.getWidth() - pane.getDividerSize());
                        if (proportion > 0.0 && proportion < 1.0) {
                            splitter.setProportion((float)proportion);
                        }
                    }
                });
            }
            if (parent instanceof Splitter) {
                Splitter psplitter = (Splitter)parent;
                if (psplitter.getFirstComponent() == root) {
                    psplitter.setFirstComponent((JComponent)splitter);
                } else {
                    psplitter.setSecondComponent((JComponent)splitter);
                }
            } else {
                parent.remove(0);
                parent.setLayout(new BorderLayout());
                parent.add((Component)splitter, "Center");
            }
            GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)component1);
            GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)component2);
        } else {
            Component[] components;
            for (Component component : components = root.getComponents()) {
                if (!(component instanceof JComponent)) continue;
                GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)component);
            }
        }
    }

    public static void iterateChildren(Component container, Consumer<Component> consumer, JComponent ... excludeComponents) {
        if (excludeComponents != null && ArrayUtil.find((Object[])excludeComponents, (Object)container) != -1) {
            return;
        }
        consumer.consume((Object)container);
        if (container instanceof Container) {
            Component[] components;
            for (Component child : components = ((Container)container).getComponents()) {
                GuiUtils.iterateChildren(child, consumer, excludeComponents);
            }
        }
    }

    public static void iterateChildren(Consumer<Component> consumer, Component ... components) {
        for (Component component : components) {
            GuiUtils.iterateChildren(component, consumer, new JComponent[0]);
        }
    }

    public static void enableChildren(boolean enabled, Component ... components) {
        for (Component component : components) {
            GuiUtils.enableChildren(component, enabled, new JComponent[0]);
        }
    }

    public static void showComponents(boolean visible, Component ... components) {
        for (Component component : components) {
            component.setVisible(visible);
        }
    }

    public static void enableChildren(Component container, final boolean enabled, JComponent ... excludeComponents) {
        GuiUtils.iterateChildren(container, new Consumer<Component>(){

            public void consume(Component t) {
                GuiUtils.enableComponent(t, enabled);
            }
        }, excludeComponents);
    }

    private static void enableComponent(Component component, boolean enabled) {
        if (component.isEnabled() == enabled) {
            return;
        }
        component.setEnabled(enabled);
        if (component instanceof JPanel) {
            Border border = ((JPanel)component).getBorder();
            if (border instanceof TitledBorder) {
                Color color = enabled ? component.getForeground() : UIUtil.getTextInactiveTextColor();
                ((TitledBorder)border).setTitleColor(color);
            }
        } else if (component instanceof JLabel) {
            Color color = UIUtil.getTextInactiveTextColor();
            if (color == null) {
                color = component.getForeground();
            }
            String changeColorString = "<font color=#" + GuiUtils.colorToHex(color) + ">";
            JLabel label = (JLabel)component;
            String text = label.getText();
            if (text != null && text.startsWith("<html>")) {
                if (StringUtil.startsWithConcatenationOf((String)text, (String)"<html>", (String)changeColorString) && enabled) {
                    text = "<html>" + text.substring(("<html>" + changeColorString).length());
                } else if (!StringUtil.startsWithConcatenationOf((String)text, (String)"<html>", (String)changeColorString) && !enabled) {
                    text = "<html>" + changeColorString + text.substring("<html>".length());
                }
                label.setText(text);
            }
        } else if (component instanceof JTable) {
            TableColumnModel columnModel = ((JTable)component).getColumnModel();
            for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                TableCellRenderer cellRenderer = columnModel.getColumn(0).getCellRenderer();
                if (!(cellRenderer instanceof Component)) continue;
                GuiUtils.enableComponent((Component)((Object)cellRenderer), enabled);
            }
        }
    }

    public static String colorToHex(Color color) {
        return GuiUtils.to2DigitsHex(color.getRed()) + GuiUtils.to2DigitsHex(color.getGreen()) + GuiUtils.to2DigitsHex(color.getBlue());
    }

    private static String to2DigitsHex(int i) {
        String s = Integer.toHexString(i);
        if (s.length() < 2) {
            s = "0" + s;
        }
        return s;
    }

    public static void invokeAndWait(@NotNull Runnable runnable) throws InvocationTargetException, InterruptedException {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/GuiUtils.invokeAndWait must not be null");
        }
        Application application = ApplicationManager.getApplication();
        assert (!application.isDispatchThread()) : "Must not be invoked from AWT dispatch thread";
        if (application.isReadAccessAllowed()) {
            application.invokeAndWait(runnable, application.getDefaultModalityState());
            return;
        }
        SwingUtilities.invokeAndWait(runnable);
    }

    public static void runOrInvokeAndWait(@NotNull Runnable runnable) throws InvocationTargetException, InterruptedException {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/GuiUtils.runOrInvokeAndWait must not be null");
        }
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            runnable.run();
        } else {
            GuiUtils.invokeAndWait(runnable);
        }
    }
}

