/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class ColoredListCellRenderer
extends SimpleColoredComponent
implements ListCellRenderer {
    protected boolean mySelected;

    public ColoredListCellRenderer() {
        this.setFocusBorderAroundIcon(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
        this.clear();
        this.mySelected = selected;
        if (UIUtil.isWinLafOnVista()) {
            if (index == -1) {
                this.setOpaque(false);
                this.mySelected = false;
            } else {
                this.setOpaque(true);
                this.setBackground(selected ? list.getSelectionBackground() : null);
            }
        } else if (selected) {
            this.setBackground(list.getSelectionBackground());
        } else {
            this.setBackground(null);
        }
        this.setPaintFocusBorder(hasFocus);
        this.customizeCellRenderer(list, value, index, selected, hasFocus);
        return this;
    }

    @Override
    public final void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, boolean isMainText) {
        if (fragment == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/ColoredListCellRenderer.append must not be null");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/ColoredListCellRenderer.append must not be null");
        }
        if (this.mySelected) {
            super.append(fragment, new SimpleTextAttributes(attributes.getStyle(), UIUtil.getListSelectionForeground()), isMainText);
        } else if (attributes.getFgColor() == null) {
            super.append(fragment, new SimpleTextAttributes(attributes.getStyle(), UIUtil.getListForeground()), isMainText);
        } else {
            super.append(fragment, attributes, isMainText);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Font oldFont = this.getFont();
        if (oldFont == null) {
            this.setFont(UIUtil.getListFont());
        }
        Dimension result = super.getPreferredSize();
        if (oldFont == null) {
            this.setFont(null);
        }
        return result;
    }

    protected abstract void customizeCellRenderer(JList var1, Object var2, int var3, boolean var4, boolean var5);
}

