/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public interface PsiReferenceProcessor {
    public boolean execute(PsiReference var1);

    public static class FindElement
    implements PsiReferenceProcessor {
        private volatile PsiReference myFoundElement = null;

        public boolean isFound() {
            return this.myFoundElement != null;
        }

        public PsiReference getFoundReference() {
            return this.myFoundElement;
        }

        @Override
        public boolean execute(PsiReference element) {
            this.myFoundElement = element;
            return false;
        }
    }

    public static class CollectElements
    implements PsiReferenceProcessor {
        private final Collection<PsiReference> myCollection;

        public CollectElements(Collection<PsiReference> collection) {
            this.myCollection = Collections.synchronizedCollection(collection);
        }

        public CollectElements() {
            this(new ArrayList<PsiReference>());
        }

        public PsiReference[] toArray() {
            return this.myCollection.toArray(new PsiReference[this.myCollection.size()]);
        }

        public PsiReference[] toArray(PsiReference[] array) {
            return this.myCollection.toArray(array);
        }

        @Override
        public boolean execute(PsiReference element) {
            this.myCollection.add(element);
            return true;
        }
    }
}

