/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.ref;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiChildLink;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationAttributeChildLink
extends PsiChildLink<PsiAnnotation, PsiAnnotationMemberValue> {
    private final String myAttributeName;

    public AnnotationAttributeChildLink(@NotNull @NonNls String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/ref/AnnotationAttributeChildLink.<init> must not be null");
        }
        this.myAttributeName = attributeName;
    }

    @NotNull
    public String getAttributeName() {
        String string = this.myAttributeName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/ref/AnnotationAttributeChildLink.getAttributeName must not return null");
        }
        return string;
    }

    @Override
    public PsiAnnotationMemberValue findLinkedChild(@Nullable PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            return null;
        }
        psiAnnotation.getText();
        return psiAnnotation.findDeclaredAttributeValue(this.myAttributeName);
    }

    @Override
    @NotNull
    public PsiAnnotationMemberValue createChild(@NotNull PsiAnnotation psiAnnotation) throws IncorrectOperationException {
        if (psiAnnotation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/ref/AnnotationAttributeChildLink.createChild must not be null");
        }
        psiAnnotation.getText();
        PsiExpression nullValue = JavaPsiFacade.getElementFactory(psiAnnotation.getProject()).createExpressionFromText("null", null);
        psiAnnotation.setDeclaredAttributeValue(this.myAttributeName, nullValue);
        PsiAnnotationMemberValue psiAnnotationMemberValue = (PsiAnnotationMemberValue)ObjectUtils.assertNotNull((Object)psiAnnotation.findDeclaredAttributeValue(this.myAttributeName));
        if (psiAnnotationMemberValue == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/ref/AnnotationAttributeChildLink.createChild must not return null");
        }
        return psiAnnotationMemberValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationAttributeChildLink link = (AnnotationAttributeChildLink)o;
        return this.myAttributeName.equals(link.myAttributeName);
    }

    public int hashCode() {
        return this.myAttributeName.hashCode();
    }
}

