/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class VirtualFilePattern
extends TreeElementPattern<VirtualFile, VirtualFile, VirtualFilePattern> {
    public VirtualFilePattern() {
        super(VirtualFile.class);
    }

    public VirtualFilePattern ofType(final FileType type) {
        return (VirtualFilePattern)this.with(new PatternCondition<VirtualFile>("ofType"){

            @Override
            public boolean accepts(@NotNull VirtualFile virtualFile, ProcessingContext context) {
                if (virtualFile == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/VirtualFilePattern$1.accepts must not be null");
                }
                return type.equals(virtualFile.getFileType());
            }
        });
    }

    public VirtualFilePattern withName(String name) {
        return this.withName((ElementPattern<String>)PlatformPatterns.string().equalTo(name));
    }

    public VirtualFilePattern withExtension(final @NotNull String extension) {
        if (extension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/VirtualFilePattern.withExtension must not be null");
        }
        return (VirtualFilePattern)this.with(new PatternCondition<VirtualFile>("withExtension"){

            @Override
            public boolean accepts(@NotNull VirtualFile virtualFile, ProcessingContext context) {
                if (virtualFile == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/VirtualFilePattern$2.accepts must not be null");
                }
                return extension.equals(virtualFile.getExtension());
            }
        });
    }

    public VirtualFilePattern withName(final ElementPattern<String> namePattern) {
        return (VirtualFilePattern)this.with(new PatternCondition<VirtualFile>("withName"){

            @Override
            public boolean accepts(@NotNull VirtualFile virtualFile, ProcessingContext context) {
                if (virtualFile == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/VirtualFilePattern$3.accepts must not be null");
                }
                return namePattern.getCondition().accepts(virtualFile.getName(), context);
            }
        });
    }

    public VirtualFilePattern xmlWithRootTag(final ElementPattern<String> tagNamePattern) {
        return (VirtualFilePattern)this.with(new PatternCondition<VirtualFile>("xmlWithRootTag"){

            @Override
            public boolean accepts(@NotNull VirtualFile virtualFile, ProcessingContext context) {
                if (virtualFile == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/VirtualFilePattern$4.accepts must not be null");
                }
                try {
                    String tagName = NanoXmlUtil.parseHeaderWithException(virtualFile).getRootTagLocalName();
                    return tagName != null && tagNamePattern.getCondition().accepts(tagName, context);
                }
                catch (IOException e) {
                    return false;
                }
            }
        });
    }

    public VirtualFilePattern xmlWithRootTagNamespace(String ... namespace) {
        StringPattern namespacePattern = StandardPatterns.string().oneOf(namespace);
        return this.xmlWithRootTagNamespace(namespacePattern);
    }

    public VirtualFilePattern xmlWithRootTagNamespace(final ElementPattern<String> namespacePattern) {
        return (VirtualFilePattern)this.with(new PatternCondition<VirtualFile>("xmlWithRootTagNamespace"){

            @Override
            public boolean accepts(@NotNull VirtualFile virtualFile, ProcessingContext context) {
                if (virtualFile == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/VirtualFilePattern$5.accepts must not be null");
                }
                try {
                    String rootTagNamespace = NanoXmlUtil.parseHeaderWithException(virtualFile).getRootTagNamespace();
                    return rootTagNamespace != null && namespacePattern.getCondition().accepts(rootTagNamespace, context);
                }
                catch (IOException e) {
                    return false;
                }
            }
        });
    }

    @Override
    protected VirtualFile getParent(@NotNull VirtualFile t) {
        if (t == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/VirtualFilePattern.getParent must not be null");
        }
        return t.getParent();
    }

    protected VirtualFile[] getChildren(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/VirtualFilePattern.getChildren must not be null");
        }
        return file.getChildren();
    }
}

