/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.patterns.ElementPattern;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PatternCondition<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.patterns.PatternCondition");
    @NonNls
    private static final String PARAMETER_FIELD_PREFIX = "val$";
    private final String myDebugMethodName;

    public PatternCondition(@Nullable @NonNls String debugMethodName) {
        this.myDebugMethodName = debugMethodName;
    }

    private void appendFieldValue(StringBuilder builder, Field field, String indent) {
        try {
            field.setAccessible(true);
            PatternCondition.appendValue(builder, indent, field.get(this));
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void appendValue(StringBuilder builder, String indent, Object obj) {
        if (obj instanceof ElementPattern) {
            ((ElementPattern)obj).getCondition().append(builder, indent + "  ");
        } else if (obj instanceof Object[]) {
            PatternCondition.appendArray(builder, indent, (Object[])obj);
        } else if (obj instanceof Collection) {
            PatternCondition.appendArray(builder, indent, ((Collection)obj).toArray());
        } else {
            builder.append(obj);
        }
    }

    protected static void appendArray(StringBuilder builder, String indent, Object[] objects) {
        builder.append("[");
        boolean first = true;
        for (Object o : objects) {
            if (!first) {
                builder.append(", ");
            }
            first = false;
            PatternCondition.appendValue(builder, indent, o);
        }
        builder.append("]");
    }

    public abstract boolean accepts(@NotNull T var1, ProcessingContext var2);

    @NonNls
    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.append(builder, "");
        return builder.toString();
    }

    public void append(StringBuilder builder, String indent) {
        builder.append(this.myDebugMethodName);
        builder.append("(");
        this.appendParams(builder, indent);
        builder.append(")");
    }

    private void appendParams(StringBuilder builder, String indent) {
        SmartList params = new SmartList();
        for (Class<?> aClass = this.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            for (Field field : aClass.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || ((field.getModifiers() & 0x1000) != 0 || aClass.equals(PatternCondition.class)) && !field.getName().startsWith(PARAMETER_FIELD_PREFIX)) continue;
                params.add(field);
            }
        }
        if (params.size() == 1) {
            this.appendFieldValue(builder, (Field)params.get(0), indent);
        } else if (!params.isEmpty()) {
            boolean first = true;
            for (Field field : params) {
                if (!first) {
                    builder.append(", ");
                }
                first = false;
                String name = field.getName();
                if (name.startsWith(PARAMETER_FIELD_PREFIX)) {
                    name = name.substring(PARAMETER_FIELD_PREFIX.length());
                }
                builder.append(name).append("=");
                this.appendFieldValue(builder, field, indent);
            }
        }
    }
}

