/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class PassThroughtIdeFocusManager
extends IdeFocusManager {
    private static final PassThroughtIdeFocusManager ourInstance = new PassThroughtIdeFocusManager();

    public static PassThroughtIdeFocusManager getInstance() {
        return ourInstance;
    }

    @Override
    @NotNull
    public ActionCallback requestFocus(@NotNull Component c, boolean forced) {
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/PassThroughtIdeFocusManager.requestFocus must not be null");
        }
        c.requestFocus();
        ActionCallback.Done done = new ActionCallback.Done();
        if (done == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/wm/PassThroughtIdeFocusManager.requestFocus must not return null");
        }
        return done;
    }

    @Override
    @NotNull
    public ActionCallback requestFocus(@NotNull FocusCommand command, boolean forced) {
        if (command == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/PassThroughtIdeFocusManager.requestFocus must not be null");
        }
        ActionCallback actionCallback = command.run();
        if (actionCallback == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/wm/PassThroughtIdeFocusManager.requestFocus must not return null");
        }
        return actionCallback;
    }

    @Override
    public JComponent getFocusTargetFor(@NotNull JComponent comp) {
        if (comp == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/PassThroughtIdeFocusManager.getFocusTargetFor must not be null");
        }
        return comp;
    }

    @Override
    public void doWhenFocusSettlesDown(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/PassThroughtIdeFocusManager.doWhenFocusSettlesDown must not be null");
        }
        runnable.run();
    }

    @Override
    public Component getFocusedDescendantFor(Component comp) {
        Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focused == null) {
            return null;
        }
        if (focused == comp || SwingUtilities.isDescendingFrom(focused, comp)) {
            return focused;
        }
        return null;
    }

    @Override
    public boolean dispatch(KeyEvent e) {
        return false;
    }

    @Override
    public ActionCallback requestDefaultFocus(boolean forced) {
        return new ActionCallback.Done();
    }

    @Override
    public Expirable getTimestamp(boolean trackOnlyForcedCommands) {
        return new Expirable(){

            @Override
            public boolean isExpired() {
                return false;
            }
        };
    }

    @Override
    public void suspendKeyProcessingUntil(@NotNull ActionCallback done) {
        if (done == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/PassThroughtIdeFocusManager.suspendKeyProcessingUntil must not be null");
        }
    }

    @Override
    public boolean isFocusBeingTransferred() {
        return false;
    }
}

