/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsRootSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDirectoryMapping {
    private String myDirectory;
    private String mySystemIdependentPath;
    private String myVcs;
    private VcsRootSettings myRootSettings;

    public VcsDirectoryMapping() {
    }

    public VcsDirectoryMapping(@NotNull String directory, String vcs) {
        if (directory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/VcsDirectoryMapping.<init> must not be null");
        }
        this.setDirectory(directory);
        this.myVcs = vcs;
    }

    public VcsDirectoryMapping(String directory, String vcs, VcsRootSettings rootSettings) {
        this.setDirectory(directory);
        this.myVcs = vcs;
        this.myRootSettings = rootSettings;
    }

    @NotNull
    public String getDirectory() {
        String string = this.myDirectory;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/VcsDirectoryMapping.getDirectory must not return null");
        }
        return string;
    }

    private void initSystemIndependentPath() {
        this.mySystemIdependentPath = FileUtil.toSystemIndependentName((String)this.myDirectory);
    }

    public String systemIndependentPath() {
        return this.mySystemIdependentPath;
    }

    public String getVcs() {
        return this.myVcs;
    }

    public void setVcs(String vcs) {
        this.myVcs = vcs;
    }

    public void setDirectory(@NotNull String directory) {
        if (directory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/VcsDirectoryMapping.setDirectory must not be null");
        }
        this.myDirectory = directory;
        this.initSystemIndependentPath();
    }

    @Nullable
    public VcsRootSettings getRootSettings() {
        return this.myRootSettings;
    }

    public void setRootSettings(VcsRootSettings rootSettings) {
        this.myRootSettings = rootSettings;
    }

    public boolean isDefaultMapping() {
        return this.myDirectory.length() == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsDirectoryMapping mapping = (VcsDirectoryMapping)o;
        if (this.myDirectory != null ? !this.myDirectory.equals(mapping.myDirectory) : mapping.myDirectory != null) {
            return false;
        }
        if (this.myVcs != null ? !this.myVcs.equals(mapping.myVcs) : mapping.myVcs != null) {
            return false;
        }
        return !(this.myRootSettings != null ? !this.myRootSettings.equals(mapping.myRootSettings) : mapping.myRootSettings != null);
    }

    public int hashCode() {
        int result = this.myDirectory != null ? this.myDirectory.hashCode() : 0;
        result = 31 * result + (this.myVcs != null ? this.myVcs.hashCode() : 0);
        return result;
    }
}

