/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.popup;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PopupChooserBuilder {
    private JComponent myChooserComponent;
    private String myTitle;
    private final ArrayList<KeyStroke> myAdditionalKeystrokes;
    private Runnable myItemChoosenRunnable;
    private JComponent mySouthComponent;
    private JComponent myEastComponent;
    private JBPopup myPopup;
    private boolean myRequestFocus;
    private boolean myForceResizable;
    private boolean myForceMovable;
    private String myDimensionServiceKey;
    private Computable<Boolean> myCancelCallback;
    private boolean myAutoselect;
    private float myAlpha;
    private Component[] myFocusOwners;
    private boolean myCancelKeyEnabled;
    ArrayList<JBPopupListener> myListeners;
    private String myAd;
    private Dimension myMinSize;
    private InplaceButton myCommandButton;
    private final List<Pair<ActionListener, KeyStroke>> myKeyboardActions;
    private Component mySettingsButtons;
    private boolean myAutoselectOnMouseMove;
    private Function<Object, String> myItemsNamer;

    public PopupChooserBuilder(@NotNull JList list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/ui/popup/PopupChooserBuilder.<init> must not be null");
        }
        this.myAdditionalKeystrokes = new ArrayList();
        this.myRequestFocus = true;
        this.myForceResizable = false;
        this.myForceMovable = false;
        this.myDimensionServiceKey = null;
        this.myAutoselect = true;
        this.myFocusOwners = new Component[0];
        this.myCancelKeyEnabled = true;
        this.myListeners = new ArrayList();
        this.myKeyboardActions = new ArrayList<Pair<ActionListener, KeyStroke>>();
        this.myAutoselectOnMouseMove = true;
        this.myItemsNamer = null;
        this.myChooserComponent = list;
    }

    public PopupChooserBuilder(@NotNull JTable table) {
        if (table == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/ui/popup/PopupChooserBuilder.<init> must not be null");
        }
        this.myAdditionalKeystrokes = new ArrayList();
        this.myRequestFocus = true;
        this.myForceResizable = false;
        this.myForceMovable = false;
        this.myDimensionServiceKey = null;
        this.myAutoselect = true;
        this.myFocusOwners = new Component[0];
        this.myCancelKeyEnabled = true;
        this.myListeners = new ArrayList();
        this.myKeyboardActions = new ArrayList<Pair<ActionListener, KeyStroke>>();
        this.myAutoselectOnMouseMove = true;
        this.myItemsNamer = null;
        this.myChooserComponent = table;
    }

    public PopupChooserBuilder(@NotNull JTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/ui/popup/PopupChooserBuilder.<init> must not be null");
        }
        this.myAdditionalKeystrokes = new ArrayList();
        this.myRequestFocus = true;
        this.myForceResizable = false;
        this.myForceMovable = false;
        this.myDimensionServiceKey = null;
        this.myAutoselect = true;
        this.myFocusOwners = new Component[0];
        this.myCancelKeyEnabled = true;
        this.myListeners = new ArrayList();
        this.myKeyboardActions = new ArrayList<Pair<ActionListener, KeyStroke>>();
        this.myAutoselectOnMouseMove = true;
        this.myItemsNamer = null;
        this.myChooserComponent = tree;
    }

    @NotNull
    public PopupChooserBuilder setTitle(@NotNull @Nls String title) {
        if (title == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/ui/popup/PopupChooserBuilder.setTitle must not be null");
        }
        this.myTitle = title;
        PopupChooserBuilder popupChooserBuilder = this;
        if (popupChooserBuilder == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/ui/popup/PopupChooserBuilder.setTitle must not return null");
        }
        return popupChooserBuilder;
    }

    @NotNull
    public PopupChooserBuilder addAdditionalChooseKeystroke(@Nullable KeyStroke keyStroke) {
        if (keyStroke != null) {
            this.myAdditionalKeystrokes.add(keyStroke);
        }
        PopupChooserBuilder popupChooserBuilder = this;
        if (popupChooserBuilder == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/ui/popup/PopupChooserBuilder.addAdditionalChooseKeystroke must not return null");
        }
        return popupChooserBuilder;
    }

    @NotNull
    public PopupChooserBuilder setItemChoosenCallback(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/ui/popup/PopupChooserBuilder.setItemChoosenCallback must not be null");
        }
        this.myItemChoosenRunnable = runnable;
        PopupChooserBuilder popupChooserBuilder = this;
        if (popupChooserBuilder == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/ui/popup/PopupChooserBuilder.setItemChoosenCallback must not return null");
        }
        return popupChooserBuilder;
    }

    @NotNull
    public PopupChooserBuilder setSouthComponent(@NotNull JComponent cmp) {
        if (cmp == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/ui/popup/PopupChooserBuilder.setSouthComponent must not be null");
        }
        this.mySouthComponent = cmp;
        PopupChooserBuilder popupChooserBuilder = this;
        if (popupChooserBuilder == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/ui/popup/PopupChooserBuilder.setSouthComponent must not return null");
        }
        return popupChooserBuilder;
    }

    @NotNull
    public PopupChooserBuilder setEastComponent(@NotNull JComponent cmp) {
        if (cmp == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/ui/popup/PopupChooserBuilder.setEastComponent must not be null");
        }
        this.myEastComponent = cmp;
        PopupChooserBuilder popupChooserBuilder = this;
        if (popupChooserBuilder == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/ui/popup/PopupChooserBuilder.setEastComponent must not return null");
        }
        return popupChooserBuilder;
    }

    public PopupChooserBuilder setRequestFocus(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
        return this;
    }

    public PopupChooserBuilder setResizable(boolean forceResizable) {
        this.myForceResizable = forceResizable;
        return this;
    }

    public PopupChooserBuilder setMovable(boolean forceMovable) {
        this.myForceMovable = forceMovable;
        return this;
    }

    public PopupChooserBuilder setDimensionServiceKey(@NonNls String key) {
        this.myDimensionServiceKey = key;
        return this;
    }

    public PopupChooserBuilder setCancelCallback(Computable<Boolean> callback) {
        this.myCancelCallback = callback;
        return this;
    }

    public PopupChooserBuilder setCommandButton(@NotNull InplaceButton commandButton) {
        if (commandButton == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/ui/popup/PopupChooserBuilder.setCommandButton must not be null");
        }
        this.myCommandButton = commandButton;
        return this;
    }

    public PopupChooserBuilder setAlpha(float alpha) {
        this.myAlpha = alpha;
        return this;
    }

    public PopupChooserBuilder setAutoselectOnMouseMove(boolean doAutoSelect) {
        this.myAutoselectOnMouseMove = doAutoSelect;
        return this;
    }

    public PopupChooserBuilder setFilteringEnabled(Function<Object, String> namer) {
        this.myItemsNamer = namer;
        return this;
    }

    @NotNull
    public JBPopup createPopup() {
        JScrollPane scrollPane;
        JList list = null;
        if (this.myChooserComponent instanceof JList) {
            list = (JList)this.myChooserComponent;
            this.myChooserComponent = ListWithFilter.wrap(list, new MyListWrapper(list), this.myItemsNamer);
        }
        JPanel contentPane = new JPanel(new BorderLayout());
        if (!this.myForceMovable && this.myTitle != null) {
            JLabel label = new JLabel(this.myTitle);
            label.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
            label.setHorizontalAlignment(0);
            contentPane.add((Component)label, "North");
        }
        if (list != null && list.getSelectedIndex() == -1 && this.myAutoselect) {
            list.setSelectedIndex(0);
        }
        this.myChooserComponent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        (list != null ? list : this.myChooserComponent).addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (UIUtil.isActionClick((MouseEvent)e) && !PopupChooserBuilder.isSelectionButtonDown(e) && !e.isConsumed()) {
                    PopupChooserBuilder.this.closePopup(true, e);
                }
            }
        });
        this.registerClosePopupKeyboardAction(KeyStroke.getKeyStroke(27, 0), false);
        this.registerClosePopupKeyboardAction(KeyStroke.getKeyStroke(10, 0), true);
        for (KeyStroke keystroke : this.myAdditionalKeystrokes) {
            this.registerClosePopupKeyboardAction(keystroke, true);
        }
        if (this.myChooserComponent instanceof ListWithFilter) {
            scrollPane = ((ListWithFilter)this.myChooserComponent).getScrollPane();
        } else if (this.myChooserComponent instanceof JTable) {
            scrollPane = this.createScrollPane((JTable)this.myChooserComponent);
        } else if (this.myChooserComponent instanceof JTree) {
            scrollPane = this.createScrollPane((JTree)this.myChooserComponent);
        } else {
            throw new IllegalStateException("PopupChooserBuilder is intended to be constructed with one of JTable, JTree, JList components");
        }
        scrollPane.getViewport().setCursor(Cursor.getPredefinedCursor(12));
        if (this.myChooserComponent instanceof ListWithFilter) {
            contentPane.add((Component)this.myChooserComponent, "Center");
        } else {
            contentPane.add((Component)scrollPane, "Center");
        }
        if (this.mySouthComponent != null) {
            contentPane.add((Component)this.mySouthComponent, "South");
        }
        if (this.myEastComponent != null) {
            contentPane.add((Component)this.myEastComponent, "East");
        }
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder(contentPane, this.myChooserComponent);
        for (JBPopupListener each : this.myListeners) {
            builder.addListener(each);
        }
        builder.setDimensionServiceKey(null, this.myDimensionServiceKey, false).setRequestFocus(this.myRequestFocus).setResizable(this.myForceResizable).setMovable(this.myForceMovable).setTitle(this.myForceMovable ? this.myTitle : null).setCancelCallback(this.myCancelCallback).setAlpha(this.myAlpha).setFocusOwners(this.myFocusOwners).setCancelKeyEnabled(this.myCancelKeyEnabled && !(this.myChooserComponent instanceof ListWithFilter)).setAdText(this.myAd).setKeyboardActions(this.myKeyboardActions);
        if (this.myCommandButton != null) {
            builder.setCommandButton(this.myCommandButton);
        }
        if (this.myMinSize != null) {
            builder.setMinSize(this.myMinSize);
        }
        if (this.mySettingsButtons != null) {
            builder.setSettingButtons(this.mySettingsButtons);
        }
        JBPopup jBPopup = this.myPopup = builder.createPopup();
        if (jBPopup == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/ui/popup/PopupChooserBuilder.createPopup must not return null");
        }
        return jBPopup;
    }

    public PopupChooserBuilder setMinSize(Dimension dimension) {
        this.myMinSize = dimension;
        return this;
    }

    public PopupChooserBuilder registerKeyboardAction(KeyStroke keyStroke, ActionListener actionListener) {
        this.myKeyboardActions.add((Pair<ActionListener, KeyStroke>)Pair.create((Object)actionListener, (Object)keyStroke));
        return this;
    }

    private void registerClosePopupKeyboardAction(KeyStroke keyStroke, final boolean shouldPerformAction) {
        this.myChooserComponent.registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!shouldPerformAction && PopupChooserBuilder.this.myChooserComponent instanceof ListWithFilter && ((ListWithFilter)PopupChooserBuilder.this.myChooserComponent).resetFilter()) {
                    return;
                }
                PopupChooserBuilder.this.closePopup(shouldPerformAction, null);
            }
        }, keyStroke, 1);
    }

    private void closePopup(boolean shouldPerformAction, MouseEvent e) {
        if (shouldPerformAction) {
            this.myPopup.setFinalRunnable(this.myItemChoosenRunnable);
        }
        this.myPopup.cancel(e);
    }

    @NotNull
    private JScrollPane createScrollPane(final JTable table) {
        if (table instanceof TreeTable) {
            TreeUtil.expandAll(((TreeTable)((Object)table)).getTree());
        }
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        if (table.getSelectedRow() == -1) {
            table.getSelectionModel().setSelectionInterval(0, 0);
        }
        if (table.getRowCount() >= 20) {
            scrollPane.getViewport().setPreferredSize(new Dimension(table.getPreferredScrollableViewportSize().width, 300));
        } else {
            scrollPane.getViewport().setPreferredSize(table.getPreferredSize());
        }
        if (this.myAutoselectOnMouseMove) {
            table.addMouseMotionListener(new MouseMotionAdapter(){
                boolean myIsEngaged = false;

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (this.myIsEngaged) {
                        int index = table.rowAtPoint(e.getPoint());
                        table.getSelectionModel().setSelectionInterval(index, index);
                    } else {
                        this.myIsEngaged = true;
                    }
                }
            });
        }
        JScrollPane jScrollPane = scrollPane;
        if (jScrollPane == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/ui/popup/PopupChooserBuilder.createScrollPane must not return null");
        }
        return jScrollPane;
    }

    @NotNull
    private JScrollPane createScrollPane(final JTree tree) {
        TreeUtil.expandAll(tree);
        JScrollPane scrollPane = new JScrollPane(tree);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        if (tree.getSelectionCount() == 0) {
            tree.setSelectionRow(0);
        }
        if (tree.getRowCount() >= 20) {
            scrollPane.getViewport().setPreferredSize(new Dimension(tree.getPreferredScrollableViewportSize().width, 300));
        } else {
            scrollPane.getViewport().setPreferredSize(tree.getPreferredSize());
        }
        if (this.myAutoselectOnMouseMove) {
            tree.addMouseMotionListener(new MouseMotionAdapter(){
                boolean myIsEngaged = false;

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (this.myIsEngaged) {
                        Point p = e.getPoint();
                        int index = tree.getRowForLocation(p.x, p.y);
                        tree.setSelectionRow(index);
                    } else {
                        this.myIsEngaged = true;
                    }
                }
            });
        }
        JScrollPane jScrollPane = scrollPane;
        if (jScrollPane == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/ui/popup/PopupChooserBuilder.createScrollPane must not return null");
        }
        return jScrollPane;
    }

    public PopupChooserBuilder setAutoSelectIfEmpty(boolean autoselect) {
        this.myAutoselect = autoselect;
        return this;
    }

    public PopupChooserBuilder setCancelKeyEnabled(boolean enabled) {
        this.myCancelKeyEnabled = enabled;
        return this;
    }

    public PopupChooserBuilder addListener(JBPopupListener listener) {
        this.myListeners.add(listener);
        return this;
    }

    private static boolean isSelectionButtonDown(MouseEvent e) {
        return e.isShiftDown() || e.isControlDown() || e.isMetaDown();
    }

    public PopupChooserBuilder setSettingButton(Component abutton) {
        this.mySettingsButtons = abutton;
        return this;
    }

    @NotNull
    public PopupChooserBuilder setFocusOwners(@NotNull Component[] focusOwners) {
        if (focusOwners == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/ui/popup/PopupChooserBuilder.setFocusOwners must not be null");
        }
        this.myFocusOwners = focusOwners;
        PopupChooserBuilder popupChooserBuilder = this;
        if (popupChooserBuilder == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/ui/popup/PopupChooserBuilder.setFocusOwners must not return null");
        }
        return popupChooserBuilder;
    }

    @NotNull
    public PopupChooserBuilder setAdText(String ad) {
        this.myAd = ad;
        PopupChooserBuilder popupChooserBuilder = this;
        if (popupChooserBuilder == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/ui/popup/PopupChooserBuilder.setAdText must not return null");
        }
        return popupChooserBuilder;
    }

    private class MyListWrapper
    extends JScrollPane
    implements DataProvider {
        private final JList myList;

        private MyListWrapper(final JList list) {
            super(list);
            if (PopupChooserBuilder.this.myAutoselectOnMouseMove) {
                list.addMouseMotionListener(new MouseMotionAdapter(){
                    boolean myIsEngaged = false;

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        if (this.myIsEngaged && !PopupChooserBuilder.isSelectionButtonDown(e)) {
                            Point point = e.getPoint();
                            int index = list.locationToIndex(point);
                            list.setSelectedIndex(index);
                        } else {
                            this.myIsEngaged = true;
                        }
                    }
                });
            }
            ListScrollingUtil.installActions(list);
            int modelSize = list.getModel().getSize();
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            if (modelSize > 0 && modelSize <= 20) {
                list.setVisibleRowCount(0);
                this.getViewport().setPreferredSize(list.getPreferredSize());
            } else {
                list.setVisibleRowCount(20);
            }
            this.myList = list;
        }

        @Override
        @Nullable
        public Object getData(@NonNls String dataId) {
            if (PlatformDataKeys.SELECTED_ITEM.is(dataId)) {
                return this.myList.getSelectedValue();
            }
            return null;
        }

        @Override
        public void setBorder(Border border) {
            if (this.myList != null) {
                this.myList.setBorder(border);
            }
        }

        @Override
        public void requestFocus() {
            this.myList.requestFocus();
        }

        @Override
        public synchronized void addMouseListener(MouseListener l) {
            this.myList.addMouseListener(l);
        }
    }
}

