/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.ui.TextFieldWithHistory;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public interface TextComponentAccessor<T extends Component> {
    public static final TextComponentAccessor<JTextField> TEXT_FIELD_WHOLE_TEXT = new TextComponentAccessor<JTextField>(){

        @Override
        public String getText(JTextField textField) {
            return textField.getText();
        }

        @Override
        public void setText(JTextField textField, String text) {
            textField.setText(text);
        }
    };
    public static final TextComponentAccessor<JTextField> TEXT_FIELD_SELECTED_TEXT = new TextComponentAccessor<JTextField>(){

        @Override
        public String getText(JTextField textField) {
            String selectedText = textField.getSelectedText();
            return selectedText != null ? selectedText : textField.getText();
        }

        @Override
        public void setText(JTextField textField, String text) {
            if (textField.getSelectedText() != null) {
                textField.replaceSelection(text);
            } else {
                textField.setText(text);
            }
        }
    };
    public static final TextComponentAccessor<JComboBox> STRING_COMBOBOX_WHOLE_TEXT = new TextComponentAccessor<JComboBox>(){

        @Override
        public String getText(JComboBox comboBox) {
            Object item = comboBox.getEditor().getItem();
            return item.toString();
        }

        @Override
        public void setText(JComboBox comboBox, String text) {
            comboBox.getEditor().setItem(text);
        }
    };
    public static final TextComponentAccessor<TextFieldWithHistory> TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT = new TextComponentAccessor<TextFieldWithHistory>(){

        @Override
        public String getText(TextFieldWithHistory textField) {
            return textField.getText();
        }

        @Override
        public void setText(TextFieldWithHistory textField, String text) {
            textField.setText(text);
        }
    };

    public String getText(T var1);

    public void setText(T var1, String var2);
}

