/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.Alarm;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public class LoadingDecorator {
    JLayeredPane myPane = new MyLayeredPane();
    LoadingLayer myLoadingLayer = new LoadingLayer();
    Animator myFadeOutAnimator;
    int myDelay;
    Alarm myStartAlarm;
    boolean myStartRequest;

    public LoadingDecorator(JComponent content, Disposable parent, int startDelayMs) {
        this.myDelay = startDelayMs;
        this.myStartAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD, parent);
        this.setLoadingText("Loading...");
        this.myFadeOutAnimator = new Animator("Loading", 10, 500, false, 0, 1){

            @Override
            public void paintNow(float frame, float totalFrames, float cycle) {
                LoadingDecorator.this.myLoadingLayer.setAlpha(1.0f - frame / totalFrames);
            }

            @Override
            protected void paintCycleEnd() {
                LoadingDecorator.this.myLoadingLayer.setVisible(false);
                LoadingDecorator.this.myLoadingLayer.setAlpha(-1.0f);
            }
        };
        Disposer.register((Disposable)parent, (Disposable)this.myFadeOutAnimator);
        this.myPane.add(content, 0, JLayeredPane.DEFAULT_LAYER);
        this.myPane.add(this.myLoadingLayer, 1, JLayeredPane.DRAG_LAYER);
        Disposer.register((Disposable)parent, (Disposable)this.myLoadingLayer.myProgress);
    }

    public JComponent getComponent() {
        return this.myPane;
    }

    public void startLoading(final boolean takeSnapshot) {
        if (this.isLoading() || this.myStartRequest) {
            return;
        }
        this.myStartRequest = true;
        if (this.myDelay > 0) {
            this.myStartAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (!LoadingDecorator.this.myStartRequest) {
                                return;
                            }
                            LoadingDecorator.this._startLoading(takeSnapshot);
                        }
                    });
                }
            }, this.myDelay);
        } else {
            this._startLoading(takeSnapshot);
        }
    }

    private void _startLoading(boolean takeSnapshot) {
        this.myLoadingLayer.setVisible(true, takeSnapshot);
    }

    public void stopLoading() {
        this.myStartRequest = false;
        this.myStartAlarm.cancelAllRequests();
        if (!this.isLoading()) {
            return;
        }
        this.myLoadingLayer.setVisible(false, false);
    }

    public String getLoadingText() {
        return this.myLoadingLayer.myText.getText();
    }

    public void setLoadingText(String loadingText) {
        this.myLoadingLayer.myText.setText(loadingText);
    }

    public boolean isLoading() {
        return this.myLoadingLayer.isVisible();
    }

    public static void main(String[] args) {
        IconLoader.activate();
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout());
        JPanel content = new JPanel(new BorderLayout());
        final LoadingDecorator loadingTree = new LoadingDecorator(new JComboBox(), Disposer.newDisposable(), -1);
        content.add((Component)loadingTree.getComponent(), "Center");
        JCheckBox loadingCheckBox = new JCheckBox("Loading");
        loadingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (loadingTree.isLoading()) {
                    loadingTree.stopLoading();
                } else {
                    loadingTree.startLoading(false);
                }
            }
        });
        content.add((Component)loadingCheckBox, "South");
        frame.getContentPane().add((Component)content, "Center");
        frame.setBounds(300, 300, 300, 300);
        frame.show();
    }

    private static class MyLayeredPane
    extends JLayeredPane {
        private MyLayeredPane() {
        }

        @Override
        public void doLayout() {
            super.doLayout();
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component each = this.getComponent(i);
                each.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    private class LoadingLayer
    extends JPanel {
        private final JLabel myText;
        private BufferedImage mySnapshot;
        private Color mySnapshotBg;
        private final AsyncProcessIcon myProgress = new AsyncProcessIcon.Big("Loading");
        private boolean myVisible;
        private float myCurrentAlpha;
        private final NonOpaquePanel myTextComponent;

        private LoadingLayer() {
            this.setOpaque(false);
            this.setVisible(false);
            this.setLayout(new GridBagLayout());
            this.myText = new JLabel("", 0);
            Font font = this.myText.getFont();
            this.myText.setFont(font.deriveFont(font.getStyle(), font.getSize() + 8));
            this.myText.setForeground(Color.black);
            this.myProgress.setOpaque(false);
            int gap = new JLabel().getIconTextGap();
            this.myTextComponent = new NonOpaquePanel(new FlowLayout(1, gap * 3, 0));
            this.myTextComponent.add(this.myProgress);
            this.myTextComponent.add(this.myText);
            this.add(this.myTextComponent);
            this.myProgress.suspend();
        }

        public void setVisible(boolean visible, boolean takeSnapshot) {
            if (this.myVisible == visible) {
                return;
            }
            if (this.myVisible && !visible && this.myCurrentAlpha != -1.0f) {
                return;
            }
            this.myVisible = visible;
            if (this.myVisible) {
                this.setVisible(this.myVisible);
                this.myCurrentAlpha = -1.0f;
            }
            if (this.myVisible) {
                if (takeSnapshot && this.getWidth() > 0 && this.getHeight() > 0) {
                    this.mySnapshot = new BufferedImage(this.getWidth(), this.getHeight(), 1);
                    Graphics2D g = this.mySnapshot.createGraphics();
                    LoadingDecorator.this.myPane.paint(g);
                    Component opaque = UIUtil.findNearestOpaque((JComponent)this);
                    this.mySnapshotBg = opaque != null ? opaque.getBackground() : UIUtil.getPanelBackgound();
                    g.dispose();
                }
                this.myProgress.resume();
            } else {
                this.disposeSnapshot();
                this.myProgress.suspend();
                LoadingDecorator.this.myFadeOutAnimator.reset();
                LoadingDecorator.this.myFadeOutAnimator.resume();
            }
        }

        private void disposeSnapshot() {
            if (this.mySnapshot != null) {
                this.mySnapshot.flush();
                this.mySnapshot = null;
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.mySnapshot != null) {
                if (this.mySnapshot.getWidth() == this.getWidth() && this.mySnapshot.getHeight() == this.getHeight()) {
                    g.drawImage(this.mySnapshot, 0, 0, this.getWidth(), this.getHeight(), null);
                    g.setColor(new Color(200, 200, 200, 240));
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    return;
                }
                this.disposeSnapshot();
            }
            if (this.mySnapshotBg != null) {
                g.setColor(this.mySnapshotBg);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }

        public void setAlpha(float alpha) {
            this.myCurrentAlpha = alpha;
            this.paintImmediately(this.myTextComponent.getBounds());
        }

        @Override
        protected void paintChildren(Graphics g) {
            if (this.myCurrentAlpha != -1.0f) {
                ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, this.myCurrentAlpha));
            }
            super.paintChildren(g);
        }
    }
}

