/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.util;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.roots.ui.util.CellAppearance;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.roots.ui.util.HttpUrlCellAppearance;
import com.intellij.openapi.roots.ui.util.JarSubfileCellAppearance;
import com.intellij.openapi.roots.ui.util.SimpleTextCellAppearance;
import com.intellij.openapi.roots.ui.util.ValidFileCellAppearance;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Icons;
import java.io.File;
import javax.swing.Icon;

public class CellAppearanceUtils {
    public static final Icon INVALID_ICON = IconLoader.getIcon((String)"/nodes/ppInvalid.png");
    public static final CellAppearance EMPTY = new EmptyAppearance();

    private CellAppearanceUtils() {
    }

    public static SimpleTextAttributes createSimpleCellAttributes(boolean isSelected) {
        return isSelected ? SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
    }

    public static CellAppearance forVirtualFile(VirtualFile virtualFile) {
        return virtualFile.isValid() ? CellAppearanceUtils.forValidVirtualFile(virtualFile) : SimpleTextCellAppearance.invalid(virtualFile.getPresentableUrl(), INVALID_ICON);
    }

    public static CellAppearance forValidVirtualFile(VirtualFile virtualFile) {
        VirtualFileSystem fileSystem = virtualFile.getFileSystem();
        if (fileSystem.getProtocol().equals("jar")) {
            return new JarSubfileCellAppearance(virtualFile);
        }
        if (fileSystem instanceof HttpFileSystem) {
            return new HttpUrlCellAppearance(virtualFile);
        }
        if (virtualFile.isDirectory()) {
            return SimpleTextCellAppearance.normal(virtualFile.getPresentableUrl(), Icons.FOLDER_ICON);
        }
        return new ValidFileCellAppearance(virtualFile);
    }

    public static Icon iconForFile(VirtualFile file) {
        if (file.getFileSystem().getProtocol().equals("jar") && file.getParent() == null) {
            return file.getIcon();
        }
        if (file.isDirectory()) {
            return Icons.FOLDER_ICON;
        }
        return file.getIcon();
    }

    public static Icon excludeIcon(Icon icon) {
        return IconLoader.getDisabledIcon((Icon)icon);
    }

    public static CompositeAppearance forFile(File file) {
        String absolutePath = file.getAbsolutePath();
        if (!file.exists()) {
            return CompositeAppearance.invalid(absolutePath);
        }
        if (file.isDirectory()) {
            CompositeAppearance appearance = CompositeAppearance.single(absolutePath);
            appearance.setIcon(Icons.FOLDER_ICON);
            return appearance;
        }
        String name = file.getName();
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(name);
        File parent = file.getParentFile();
        CompositeAppearance appearance = CompositeAppearance.textComment(name, parent.getAbsolutePath());
        appearance.setIcon(fileType.getIcon());
        return appearance;
    }

    private static class EmptyAppearance
    implements CellAppearance {
        private EmptyAppearance() {
        }

        @Override
        public void customize(SimpleColoredComponent component) {
        }

        @Override
        public String getText() {
            return "";
        }
    }
}

