/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import org.jdom.Element;

public enum DependencyScope {
    COMPILE{

        public String toString() {
            return "Compile";
        }
    }
    ,
    TEST{

        public String toString() {
            return "Test";
        }
    }
    ,
    RUNTIME{

        public String toString() {
            return "Runtime";
        }
    }
    ,
    PROVIDED{

        public String toString() {
            return "Provided";
        }
    };

    private static final String SCOPE_ATTR = "scope";

    public static DependencyScope readExternal(Element element) {
        String scope = element.getAttributeValue(SCOPE_ATTR);
        if (scope != null) {
            try {
                return DependencyScope.valueOf(scope);
            }
            catch (IllegalArgumentException e) {
                return COMPILE;
            }
        }
        return COMPILE;
    }

    public void writeExternal(Element element) {
        if (this != COMPILE) {
            element.setAttribute(SCOPE_ATTR, this.name());
        }
    }
}

