/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleJdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.HashSet;
import com.intellij.util.graph.Graph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleUtil {
    public static final Key<Module> KEY_MODULE = new Key("Module");

    public static boolean projectContainsFile(Project project, VirtualFile file, boolean isLibraryElement) {
        Module[] modules;
        for (Module module : modules = ModuleManager.getInstance(project).getModules()) {
            if (!ModuleUtil.moduleContainsFile(module, file, isLibraryElement)) continue;
            return true;
        }
        return false;
    }

    private ModuleUtil() {
    }

    public static String getModuleNameInReadAction(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/ModuleUtil.getModuleNameInReadAction must not be null");
        }
        return (String)new ReadAction<String>(){

            @Override
            protected void run(Result<String> result) throws Throwable {
                result.setResult(module.getName());
            }
        }.execute().getResultObject();
    }

    public static boolean isModuleDisposed(PsiElement element) {
        Module module;
        if (!element.isValid()) {
            return true;
        }
        Project project = element.getProject();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return true;
        }
        VirtualFile vFile = file.getVirtualFile();
        Module module2 = module = vFile == null ? null : projectFileIndex.getModuleForFile(vFile);
        return module == null ? !projectFileIndex.isInLibraryClasses(vFile) : module.isDisposed();
    }

    @Nullable
    public static Module getParentModuleOfType(ModuleType expectedModuleType, Module module) {
        if (module == null) {
            return null;
        }
        if (expectedModuleType.equals(module.getModuleType())) {
            return module;
        }
        List<Module> parents = ModuleUtil.getParentModulesOfType(expectedModuleType, module);
        return parents.isEmpty() ? null : parents.get(0);
    }

    @NotNull
    public static List<Module> getParentModulesOfType(ModuleType expectedModuleType, Module module) {
        List<Module> parents = ModuleManager.getInstance(module.getProject()).getModuleDependentModules(module);
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Module parent : parents) {
            if (!expectedModuleType.equals(parent.getModuleType())) continue;
            modules.add(parent);
        }
        ArrayList<Module> arrayList = modules;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/module/ModuleUtil.getParentModulesOfType must not return null");
        }
        return arrayList;
    }

    @Nullable
    public static Module findModuleForFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/ModuleUtil.findModuleForFile must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/module/ModuleUtil.findModuleForFile must not be null");
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        return fileIndex.getModuleForFile(file);
    }

    @Nullable
    public static Module findModuleForPsiElement(@NotNull PsiElement element) {
        ProjectFileIndex fileIndex;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/ModuleUtil.findModuleForPsiElement must not be null");
        }
        if (!element.isValid()) {
            return null;
        }
        Project project = element.getProject();
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance(project);
        ProjectFileIndex projectFileIndex = fileIndex = projectRootManager == null ? null : projectRootManager.getFileIndex();
        if (element instanceof PsiDirectory) {
            VirtualFile vFile = ((PsiDirectory)element).getVirtualFile();
            if (fileIndex.isInLibrarySource(vFile) || fileIndex.isInLibraryClasses(vFile)) {
                List<OrderEntry> orderEntries = fileIndex.getOrderEntriesForFile(vFile);
                if (orderEntries.isEmpty()) {
                    return null;
                }
                HashSet modules = new HashSet();
                for (OrderEntry orderEntry : orderEntries) {
                    modules.add(orderEntry.getOwnerModule());
                }
                Module[] candidates = modules.toArray(new Module[modules.size()]);
                Arrays.sort(candidates, ModuleManager.getInstance(project).moduleDependencyComparator());
                return candidates[0];
            }
            return fileIndex.getModuleForFile(vFile);
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile != null) {
            PsiFile file;
            PsiElement context;
            while ((context = containingFile.getContext()) != null && (file = context.getContainingFile()) != null) {
                containingFile = file;
            }
            if (containingFile.getUserData(KEY_MODULE) != null) {
                return (Module)containingFile.getUserData(KEY_MODULE);
            }
            PsiFile originalFile = containingFile.getOriginalFile();
            if (originalFile.getUserData(KEY_MODULE) != null) {
                return (Module)originalFile.getUserData(KEY_MODULE);
            }
            VirtualFile virtualFile = originalFile.getVirtualFile();
            if (fileIndex != null && virtualFile != null) {
                return fileIndex.getModuleForFile(virtualFile);
            }
        }
        return (Module)element.getUserData(KEY_MODULE);
    }

    public static void getDependencies(@NotNull Module module, Set<Module> modules) {
        Module[] dependencies;
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/ModuleUtil.getDependencies must not be null");
        }
        if (modules.contains(module)) {
            return;
        }
        modules.add(module);
        for (Module dependency : dependencies = ModuleRootManager.getInstance(module).getDependencies()) {
            ModuleUtil.getDependencies(dependency, modules);
        }
    }

    public static Collection<Module> collectModulesDependsOn(@NotNull Collection<Module> modules) {
        if (modules == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/ModuleUtil.collectModulesDependsOn must not be null");
        }
        if (modules.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet result = new HashSet();
        Project project = modules.iterator().next().getProject();
        ModuleManager moduleManager = ModuleManager.getInstance(project);
        for (Module module : modules) {
            result.add((Object)module);
            result.addAll(moduleManager.getModuleDependentModules(module));
        }
        return result;
    }

    @NotNull
    public static List<Module> getAllDependentModules(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/ModuleUtil.getAllDependentModules must not be null");
        }
        ArrayList<Module> list = new ArrayList<Module>();
        Graph<Module> graph = ModuleManager.getInstance(module.getProject()).moduleGraph();
        Iterator i = graph.getOut((Object)module);
        while (i.hasNext()) {
            list.add((Module)i.next());
        }
        ArrayList<Module> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/module/ModuleUtil.getAllDependentModules must not return null");
        }
        return arrayList;
    }

    public static boolean visitMeAndDependentModules(@NotNull Module module, ModuleVisitor visitor) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/ModuleUtil.visitMeAndDependentModules must not be null");
        }
        if (!visitor.visit(module)) {
            return false;
        }
        List<Module> list = ModuleUtil.getAllDependentModules(module);
        for (Module dependentModule : list) {
            if (visitor.visit(dependentModule)) continue;
            return false;
        }
        return true;
    }

    public static boolean moduleContainsFile(Module module, VirtualFile file, boolean isLibraryElement) {
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
        if (isLibraryElement) {
            OrderEntry orderEntry = moduleRootManager.getFileIndex().getOrderEntryForFile(file);
            return orderEntry instanceof ModuleJdkOrderEntry || orderEntry instanceof JdkOrderEntry || orderEntry instanceof LibraryOrderEntry;
        }
        return moduleRootManager.getFileIndex().isInContent(file);
    }

    public static interface ModuleVisitor {
        public boolean visit(Module var1);
    }
}

