/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import org.jetbrains.annotations.NotNull;

public class LanguageLevelUtil {
    private LanguageLevelUtil() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static LanguageLevel getEffectiveLanguageLevel(@NotNull Module module) {
        LanguageLevel languageLevel;
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/LanguageLevelUtil.getEffectiveLanguageLevel must not be null");
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LanguageLevel level = LanguageLevelModuleExtension.getInstance(module).getLanguageLevel();
        if (level != null) {
            languageLevel = level;
            if (languageLevel == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/module/LanguageLevelUtil.getEffectiveLanguageLevel must not return null");
            return languageLevel;
        }
        languageLevel = LanguageLevelProjectExtension.getInstance(module.getProject()).getLanguageLevel();
        if (languageLevel != null) return languageLevel;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/module/LanguageLevelUtil.getEffectiveLanguageLevel must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static LanguageLevel getLanguageLevelForFile(VirtualFile file) {
        LanguageLevel languageLevel;
        if (file == null) {
            languageLevel = LanguageLevel.HIGHEST;
            if (languageLevel == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/module/LanguageLevelUtil.getLanguageLevelForFile must not return null");
            return languageLevel;
        }
        if (file.isDirectory()) {
            LanguageLevel ll = (LanguageLevel)((Object)file.getUserData(LanguageLevel.KEY));
            languageLevel = ll != null ? ll : LanguageLevel.HIGHEST;
            if (languageLevel == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/module/LanguageLevelUtil.getLanguageLevelForFile must not return null");
            return languageLevel;
        }
        languageLevel = LanguageLevelUtil.getLanguageLevelForFile(file.getParent());
        if (languageLevel != null) return languageLevel;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/module/LanguageLevelUtil.getLanguageLevelForFile must not return null");
    }

    public static LanguageLevel getDefaultLanguageLevel(@NotNull String versionString) {
        if (versionString == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/LanguageLevelUtil.getDefaultLanguageLevel must not be null");
        }
        if (LanguageLevelUtil.isOfVersionOrHigher(versionString, "1.7") || LanguageLevelUtil.isOfVersionOrHigher(versionString, "7.0")) {
            return LanguageLevel.JDK_1_7;
        }
        if (LanguageLevelUtil.isOfVersionOrHigher(versionString, "1.6") || LanguageLevelUtil.isOfVersionOrHigher(versionString, "6.0")) {
            return LanguageLevel.JDK_1_6;
        }
        if (LanguageLevelUtil.isOfVersionOrHigher(versionString, "1.5") || LanguageLevelUtil.isOfVersionOrHigher(versionString, "5.0")) {
            return LanguageLevel.JDK_1_5;
        }
        if (LanguageLevelUtil.isOfVersionOrHigher(versionString, "1.4")) {
            return LanguageLevel.JDK_1_4;
        }
        return LanguageLevel.JDK_1_3;
    }

    public static boolean isOfVersionOrHigher(@NotNull String versionString, String checkedVersion) {
        if (versionString == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/LanguageLevelUtil.isOfVersionOrHigher must not be null");
        }
        return JavaSdk.getInstance().compareTo(versionString, checkedVersion) >= 0;
    }
}

