/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.MockLanguageFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class MockFileTypeManager
extends FileTypeManager {
    MockFileTypeManager() {
    }

    @Override
    public void registerFileType(@NotNull FileType type, @NotNull List<FileNameMatcher> defaultAssociations) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/MockFileTypeManager.registerFileType must not be null");
        }
        if (defaultAssociations == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileTypes/MockFileTypeManager.registerFileType must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public FileType getFileTypeByFileName(@NotNull @NonNls String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/MockFileTypeManager.getFileTypeByFileName must not be null");
        }
        LanguageFileType languageFileType = MockLanguageFileType.INSTANCE;
        if (languageFileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/MockFileTypeManager.getFileTypeByFileName must not return null");
        }
        return languageFileType;
    }

    @Override
    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/MockFileTypeManager.getFileTypeByFile must not be null");
        }
        LanguageFileType languageFileType = MockLanguageFileType.INSTANCE;
        if (languageFileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/MockFileTypeManager.getFileTypeByFile must not return null");
        }
        return languageFileType;
    }

    @Override
    @NotNull
    public FileType getFileTypeByExtension(@NonNls @NotNull String extension) {
        if (extension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/MockFileTypeManager.getFileTypeByExtension must not be null");
        }
        LanguageFileType languageFileType = MockLanguageFileType.INSTANCE;
        if (languageFileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/MockFileTypeManager.getFileTypeByExtension must not return null");
        }
        return languageFileType;
    }

    @Override
    @NotNull
    public FileType[] getRegisteredFileTypes() {
        FileType[] fileTypeArray = new FileType[]{MockLanguageFileType.INSTANCE};
        if (fileTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/MockFileTypeManager.getRegisteredFileTypes must not return null");
        }
        return fileTypeArray;
    }

    @Override
    public boolean isFileIgnored(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/MockFileTypeManager.isFileIgnored must not be null");
        }
        return false;
    }

    @Override
    @NotNull
    public String[] getAssociatedExtensions(@NotNull FileType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/MockFileTypeManager.getAssociatedExtensions must not be null");
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/MockFileTypeManager.getAssociatedExtensions must not return null");
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    @NotNull
    public List<FileNameMatcher> getAssociations(@NotNull FileType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/MockFileTypeManager.getAssociations must not be null");
        }
        List<FileNameMatcher> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/MockFileTypeManager.getAssociations must not return null");
        }
        return list;
    }

    @Override
    public void addFileTypeListener(@NotNull FileTypeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/MockFileTypeManager.addFileTypeListener must not be null");
        }
    }

    @Override
    public void removeFileTypeListener(@NotNull FileTypeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/MockFileTypeManager.removeFileTypeListener must not be null");
        }
    }

    @Override
    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/MockFileTypeManager.getKnownFileTypeOrAssociate must not be null");
        }
        return file.getFileType();
    }

    @Override
    @NotNull
    public String getIgnoredFilesList() {
        if ("" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/MockFileTypeManager.getIgnoredFilesList must not return null");
        }
        return "";
    }

    @Override
    public void setIgnoredFilesList(@NotNull String list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/MockFileTypeManager.setIgnoredFilesList must not be null");
        }
    }

    @Override
    public void associate(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/MockFileTypeManager.associate must not be null");
        }
        if (matcher == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileTypes/MockFileTypeManager.associate must not be null");
        }
    }

    @Override
    public void removeAssociation(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/MockFileTypeManager.removeAssociation must not be null");
        }
        if (matcher == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileTypes/MockFileTypeManager.removeAssociation must not be null");
        }
    }

    @Override
    @NotNull
    public FileType getStdFileType(@NotNull @NonNls String fileTypeName) {
        if (fileTypeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/MockFileTypeManager.getStdFileType must not be null");
        }
        LanguageFileType languageFileType = MockLanguageFileType.INSTANCE;
        if (languageFileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/MockFileTypeManager.getStdFileType must not return null");
        }
        return languageFileType;
    }

    @Override
    public boolean isFileOfType(VirtualFile file, FileType type) {
        return false;
    }
}

