/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.event;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import org.jetbrains.annotations.NotNull;

public class MockDocumentEvent
extends DocumentEvent {
    private final int myOffset;
    private final long myTimestamp;

    public MockDocumentEvent(Document document, int offset) {
        super(document);
        this.myOffset = offset;
        this.myTimestamp = document.getModificationStamp();
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = (Document)this.getSource();
        if (document == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/event/MockDocumentEvent.getDocument must not return null");
        }
        return document;
    }

    @Override
    public int getOffset() {
        return this.myOffset;
    }

    @Override
    public int getOldLength() {
        return 0;
    }

    @Override
    public int getNewLength() {
        return 0;
    }

    @Override
    public CharSequence getOldFragment() {
        return "";
    }

    @Override
    public CharSequence getNewFragment() {
        return "";
    }

    @Override
    public long getOldTimeStamp() {
        return this.myTimestamp;
    }
}

