/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.WeakList;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class LazyRangeMarkerFactory
extends AbstractProjectComponent {
    private final WeakList<LazyMarker> myMarkers = new WeakList();

    public LazyRangeMarkerFactory(Project project, final FileDocumentManager fdm) {
        super(project);
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentAdapter(){

            @Override
            public void beforeDocumentChange(DocumentEvent e) {
                Iterator it = LazyRangeMarkerFactory.this.myMarkers.iterator();
                while (it.hasNext()) {
                    LazyMarker marker = (LazyMarker)it.next();
                    VirtualFile docFile = fdm.getFile(e.getDocument());
                    if (marker.getFile() != docFile) continue;
                    marker.ensureDelegate();
                    it.remove();
                }
            }
        }, project);
    }

    public static LazyRangeMarkerFactory getInstance(Project project) {
        return project.getComponent(LazyRangeMarkerFactory.class);
    }

    public RangeMarker createRangeMarker(VirtualFile file, int offset) {
        FileDocumentManager fdm = FileDocumentManager.getInstance();
        Document document = fdm.getCachedDocument(file);
        if (document != null) {
            int _offset = Math.min(offset, document.getTextLength());
            return document.createRangeMarker(_offset, _offset);
        }
        OffsetLazyMarker marker = new OffsetLazyMarker(file, offset);
        this.myMarkers.add((Object)marker);
        return marker;
    }

    public RangeMarker createRangeMarker(VirtualFile file, int line, int column) {
        FileDocumentManager fdm = FileDocumentManager.getInstance();
        Document document = fdm.getCachedDocument(file);
        if (document != null) {
            int offset = LazyRangeMarkerFactory.calculateOffset(this.myProject, file, document, line, column);
            return document.createRangeMarker(offset, offset);
        }
        LineColumnLazyMarker marker = new LineColumnLazyMarker(file, line, column);
        this.myMarkers.add((Object)marker);
        return marker;
    }

    private static int calculateOffset(Project project, VirtualFile file, Document document, int line, int column) {
        int offset;
        if (line < document.getLineCount()) {
            int lineStart = document.getLineStartOffset(line);
            int lineEnd = document.getLineEndOffset(line);
            CharSequence docText = document.getCharsSequence();
            int tabSize = CodeStyleFacade.getInstance(project).getTabSize(FileTypeManager.getInstance().getFileTypeByFile(file));
            offset = lineStart;
            for (int col = 0; offset < lineEnd && col < column; col += docText.charAt(offset) == '\t' ? tabSize : 1, ++offset) {
            }
        } else {
            offset = document.getTextLength();
        }
        return offset;
    }

    private class LineColumnLazyMarker
    extends LazyMarker {
        private final int myLine;
        private final int myColumn;

        private LineColumnLazyMarker(VirtualFile file, int line, int column) {
            super(file, -1);
            this.myLine = line;
            this.myColumn = column;
        }

        @Override
        public RangeMarker createDelegate(VirtualFile file, Document document) {
            int offset = LazyRangeMarkerFactory.calculateOffset(LazyRangeMarkerFactory.this.myProject, file, document, this.myLine, this.myColumn);
            return document.createRangeMarker(offset, offset);
        }
    }

    private static class OffsetLazyMarker
    extends LazyMarker {
        private OffsetLazyMarker(VirtualFile file, int offset) {
            super(file, offset);
        }

        @Override
        public RangeMarker createDelegate(VirtualFile file, Document document) {
            int offset = Math.min(this.myInitialOffset, document.getTextLength());
            return document.createRangeMarker(offset, offset);
        }
    }

    private static abstract class LazyMarker
    extends UserDataHolderBase
    implements RangeMarker {
        private RangeMarker myDelegate = null;
        private VirtualFile myFile;
        protected final int myInitialOffset;

        private LazyMarker(VirtualFile file, int offset) {
            this.myFile = file;
            this.myInitialOffset = offset;
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public final RangeMarker ensureDelegate() {
            if (this.myDelegate == null) {
                this.myDelegate = this.createDelegate(this.myFile, FileDocumentManager.getInstance().getDocument(this.myFile));
            }
            return this.myDelegate;
        }

        protected abstract RangeMarker createDelegate(VirtualFile var1, Document var2);

        @Override
        @NotNull
        public Document getDocument() {
            Document document = this.ensureDelegate().getDocument();
            if (document == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/LazyRangeMarkerFactory$LazyMarker.getDocument must not return null");
            }
            return document;
        }

        @Override
        public int getStartOffset() {
            return this.myDelegate != null ? this.myDelegate.getStartOffset() : this.myInitialOffset;
        }

        @Override
        public int getEndOffset() {
            return this.myDelegate != null ? this.myDelegate.getEndOffset() : this.myInitialOffset;
        }

        @Override
        public boolean isValid() {
            return this.myDelegate != null ? this.myDelegate.isValid() : this.myFile.isValid();
        }

        @Override
        public void setGreedyToLeft(boolean greedy) {
            this.ensureDelegate().setGreedyToLeft(greedy);
        }

        @Override
        public void setGreedyToRight(boolean greedy) {
            this.ensureDelegate().setGreedyToRight(greedy);
        }

        @Override
        public boolean isGreedyToRight() {
            return this.ensureDelegate().isGreedyToRight();
        }

        @Override
        public boolean isGreedyToLeft() {
            return this.ensureDelegate().isGreedyToLeft();
        }
    }
}

