/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diff.LineTokenizer;
import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.fragments.LineFragment;
import com.intellij.openapi.diff.impl.patch.AirContentRevision;
import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import com.intellij.openapi.diff.impl.patch.PathDescription;
import com.intellij.openapi.diff.impl.patch.StaticPathDescription;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.processing.DiffCorrection;
import com.intellij.openapi.diff.impl.processing.DiffFragmentsProcessor;
import com.intellij.openapi.diff.impl.processing.DiffPolicy;
import com.intellij.openapi.diff.impl.util.TextDiffTypeEnum;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.util.BeforeAfter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextPatchBuilder {
    private static final int CONTEXT_LINES = 3;
    @NonNls
    private static final String REVISION_NAME_TEMPLATE = "(revision {0})";
    private final String myBasePath;
    private final boolean myIsReversePath;
    private final boolean myIsCaseSensitive;
    @Nullable
    private final Runnable myCancelChecker;

    private TextPatchBuilder(String basePath, boolean isReversePath, boolean isCaseSensitive, @Nullable Runnable cancelChecker) {
        this.myBasePath = basePath;
        this.myIsReversePath = isReversePath;
        this.myIsCaseSensitive = isCaseSensitive;
        this.myCancelChecker = cancelChecker;
    }

    private void checkCanceled() {
        if (this.myCancelChecker != null) {
            this.myCancelChecker.run();
        }
    }

    public static List<FilePatch> buildPatch(Collection<Change> changes, String basePath, boolean reversePatch) throws VcsException {
        ArrayList<BeforeAfter<AirContentRevision>> revisions = new ArrayList<BeforeAfter<AirContentRevision>>(changes.size());
        for (Change change : changes) {
            revisions.add((BeforeAfter<AirContentRevision>)new BeforeAfter((Object)TextPatchBuilder.convertRevision(change.getBeforeRevision()), (Object)TextPatchBuilder.convertRevision(change.getAfterRevision())));
        }
        return TextPatchBuilder.buildPatch(revisions, basePath, reversePatch, SystemInfo.isFileSystemCaseSensitive, new Runnable(){

            @Override
            public void run() {
                ProgressManager.checkCanceled();
            }
        });
    }

    public static List<FilePatch> buildPatch(Collection<BeforeAfter<AirContentRevision>> changes, String basePath, boolean reversePatch, boolean isCaseSensitive, @Nullable Runnable cancelChecker) throws VcsException {
        TextPatchBuilder builder = new TextPatchBuilder(basePath, reversePatch, isCaseSensitive, cancelChecker);
        return builder.build(changes);
    }

    private List<FilePatch> build(Collection<BeforeAfter<AirContentRevision>> changes) throws VcsException {
        ArrayList<FilePatch> result = new ArrayList<FilePatch>();
        for (BeforeAfter<AirContentRevision> c : changes) {
            AirContentRevision afterRevision;
            AirContentRevision beforeRevision;
            this.checkCanceled();
            if (this.myIsReversePath) {
                beforeRevision = (AirContentRevision)c.getAfter();
                afterRevision = (AirContentRevision)c.getBefore();
            } else {
                beforeRevision = (AirContentRevision)c.getBefore();
                afterRevision = (AirContentRevision)c.getAfter();
            }
            if (beforeRevision != null && beforeRevision.getPath().isDirectory() || afterRevision != null && afterRevision.getPath().isDirectory()) continue;
            if (beforeRevision != null && beforeRevision.isBinary() || afterRevision != null && afterRevision.isBinary()) {
                result.add(this.buildBinaryPatch(this.myBasePath, beforeRevision, afterRevision));
                continue;
            }
            if (beforeRevision == null) {
                result.add(this.buildAddedFile(this.myBasePath, afterRevision));
                continue;
            }
            if (afterRevision == null) {
                result.add(this.buildDeletedFile(this.myBasePath, beforeRevision));
                continue;
            }
            String beforeContent = beforeRevision.getContentAsString();
            if (beforeContent == null) {
                throw new VcsException("Failed to fetch old content for changed file " + beforeRevision.getPath());
            }
            String afterContent = afterRevision.getContentAsString();
            if (afterContent == null) {
                throw new VcsException("Failed to fetch new content for changed file " + afterRevision.getPath());
            }
            String[] beforeLines = new LineTokenizer(beforeContent).execute();
            String[] afterLines = new LineTokenizer(afterContent).execute();
            DiffFragment[] woFormattingBlocks = DiffPolicy.LINES_WO_FORMATTING.buildFragments(beforeContent, afterContent);
            DiffFragment[] step1lineFragments = new DiffCorrection.TrueLineBlocks(ComparisonPolicy.DEFAULT).correctAndNormalize(woFormattingBlocks);
            ArrayList fragments = new DiffFragmentsProcessor().process(step1lineFragments);
            if (fragments.size() > 1 || fragments.size() == 1 && ((LineFragment)fragments.get(0)).getType() != null && ((LineFragment)fragments.get(0)).getType() != TextDiffTypeEnum.NONE) {
                TextFilePatch patch = this.buildPatchHeading(this.myBasePath, beforeRevision, afterRevision);
                result.add(patch);
                int lastLine1 = 0;
                int lastLine2 = 0;
                while (fragments.size() > 0) {
                    this.checkCanceled();
                    List<LineFragment> adjacentFragments = TextPatchBuilder.getAdjacentFragments(fragments);
                    if (adjacentFragments.size() <= 0) continue;
                    LineFragment first = adjacentFragments.get(0);
                    LineFragment last = adjacentFragments.get(adjacentFragments.size() - 1);
                    int start1 = first.getStartingLine1();
                    int start2 = first.getStartingLine2();
                    int end1 = last.getStartingLine1() + last.getModifiedLines1();
                    int end2 = last.getStartingLine2() + last.getModifiedLines2();
                    int contextStart1 = Math.max(start1 - 3, lastLine1);
                    int contextStart2 = Math.max(start2 - 3, lastLine2);
                    int contextEnd1 = Math.min(end1 + 3, beforeLines.length);
                    int contextEnd2 = Math.min(end2 + 3, afterLines.length);
                    PatchHunk hunk = new PatchHunk(contextStart1, contextEnd1, contextStart2, contextEnd2);
                    patch.addHunk(hunk);
                    for (LineFragment fragment : adjacentFragments) {
                        int i;
                        this.checkCanceled();
                        for (i = contextStart1; i < fragment.getStartingLine1(); ++i) {
                            TextPatchBuilder.addLineToHunk(hunk, beforeLines[i], PatchLine.Type.CONTEXT);
                        }
                        for (i = fragment.getStartingLine1(); i < fragment.getStartingLine1() + fragment.getModifiedLines1(); ++i) {
                            TextPatchBuilder.addLineToHunk(hunk, beforeLines[i], PatchLine.Type.REMOVE);
                        }
                        for (i = fragment.getStartingLine2(); i < fragment.getStartingLine2() + fragment.getModifiedLines2(); ++i) {
                            TextPatchBuilder.addLineToHunk(hunk, afterLines[i], PatchLine.Type.ADD);
                        }
                        contextStart1 = fragment.getStartingLine1() + fragment.getModifiedLines1();
                    }
                    for (int i = contextStart1; i < contextEnd1; ++i) {
                        TextPatchBuilder.addLineToHunk(hunk, beforeLines[i], PatchLine.Type.CONTEXT);
                    }
                }
                continue;
            }
            if (beforeRevision.getPath().equals(afterRevision.getPath())) continue;
            result.add(this.buildMovedFile(this.myBasePath, beforeRevision, afterRevision, beforeLines));
        }
        return result;
    }

    @Nullable
    private static AirContentRevision convertRevision(final ContentRevision cr) {
        if (cr == null) {
            return null;
        }
        final StaticPathDescription description = TextPatchBuilder.fromFilePath(cr.getFile());
        if (cr instanceof BinaryContentRevision) {
            return new AirContentRevision(){

                @Override
                public boolean isBinary() {
                    return true;
                }

                @Override
                public String getContentAsString() {
                    throw new IllegalStateException();
                }

                @Override
                public byte[] getContentAsBytes() throws VcsException {
                    return ((BinaryContentRevision)cr).getBinaryContent();
                }

                @Override
                public String getRevisionNumber() {
                    return cr.getRevisionNumber().asString();
                }

                @Override
                @NotNull
                public PathDescription getPath() {
                    StaticPathDescription staticPathDescription = description;
                    if (staticPathDescription == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/openapi/diff/impl/patch/TextPatchBuilder$2.getPath must not return null");
                    }
                    return staticPathDescription;
                }
            };
        }
        return new AirContentRevision(){

            @Override
            public boolean isBinary() {
                return false;
            }

            @Override
            public String getContentAsString() throws VcsException {
                return cr.getContent();
            }

            @Override
            public byte[] getContentAsBytes() throws VcsException {
                throw new IllegalStateException();
            }

            @Override
            public String getRevisionNumber() {
                return cr.getRevisionNumber().asString();
            }

            @Override
            @NotNull
            public PathDescription getPath() {
                StaticPathDescription staticPathDescription = description;
                if (staticPathDescription == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/openapi/diff/impl/patch/TextPatchBuilder$3.getPath must not return null");
                }
                return staticPathDescription;
            }
        };
    }

    private static StaticPathDescription fromFilePath(@NotNull FilePath fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/diff/impl/patch/TextPatchBuilder.fromFilePath must not be null");
        }
        return new StaticPathDescription(fp.isDirectory(), fp.getIOFile().lastModified(), fp.getPath());
    }

    private FilePatch buildBinaryPatch(String basePath, AirContentRevision beforeRevision, AirContentRevision afterRevision) throws VcsException {
        AirContentRevision headingBeforeRevision = beforeRevision != null ? beforeRevision : afterRevision;
        AirContentRevision headingAfterRevision = afterRevision != null ? afterRevision : beforeRevision;
        byte[] beforeContent = beforeRevision != null ? beforeRevision.getContentAsBytes() : null;
        byte[] afterContent = afterRevision != null ? afterRevision.getContentAsBytes() : null;
        BinaryFilePatch patch = new BinaryFilePatch(beforeContent, afterContent);
        this.setPatchHeading(patch, basePath, headingBeforeRevision, headingAfterRevision);
        return patch;
    }

    private static void addLineToHunk(PatchHunk hunk, String line, PatchLine.Type type) {
        PatchLine patchLine;
        if (!line.endsWith("\n")) {
            patchLine = new PatchLine(type, line);
            patchLine.setSuppressNewLine(true);
        } else {
            patchLine = new PatchLine(type, line.substring(0, line.length() - 1));
        }
        hunk.addLine(patchLine);
    }

    private TextFilePatch buildMovedFile(String basePath, AirContentRevision beforeRevision, AirContentRevision afterRevision, String[] lines) throws VcsException {
        TextFilePatch result = this.buildPatchHeading(basePath, beforeRevision, afterRevision);
        PatchHunk hunk = new PatchHunk(0, 0, 0, 0);
        result.addHunk(hunk);
        return result;
    }

    private TextFilePatch buildAddedFile(String basePath, AirContentRevision afterRevision) throws VcsException {
        String content = afterRevision.getContentAsString();
        if (content == null) {
            throw new VcsException("Failed to fetch content for added file " + afterRevision.getPath());
        }
        String[] lines = new LineTokenizer(content).execute();
        TextFilePatch result = this.buildPatchHeading(basePath, afterRevision, afterRevision);
        PatchHunk hunk = new PatchHunk(-1, -1, 0, lines.length);
        for (String line : lines) {
            this.checkCanceled();
            TextPatchBuilder.addLineToHunk(hunk, line, PatchLine.Type.ADD);
        }
        result.addHunk(hunk);
        return result;
    }

    private TextFilePatch buildDeletedFile(String basePath, AirContentRevision beforeRevision) throws VcsException {
        String content = beforeRevision.getContentAsString();
        if (content == null) {
            throw new VcsException("Failed to fetch old content for deleted file " + beforeRevision.getPath());
        }
        String[] lines = new LineTokenizer(content).execute();
        TextFilePatch result = this.buildPatchHeading(basePath, beforeRevision, beforeRevision);
        PatchHunk hunk = new PatchHunk(0, lines.length, -1, -1);
        for (String line : lines) {
            this.checkCanceled();
            TextPatchBuilder.addLineToHunk(hunk, line, PatchLine.Type.REMOVE);
        }
        result.addHunk(hunk);
        return result;
    }

    private static List<LineFragment> getAdjacentFragments(ArrayList<LineFragment> fragments) {
        ArrayList<LineFragment> result = new ArrayList<LineFragment>();
        int endLine = -1;
        while (!fragments.isEmpty()) {
            LineFragment fragment = fragments.get(0);
            if (fragment.getType() == null || fragment.getType() == TextDiffTypeEnum.NONE) {
                fragments.remove(0);
                continue;
            }
            if (!result.isEmpty() && endLine + 3 < fragment.getStartingLine1() - 3) break;
            result.add(fragment);
            fragments.remove(0);
            endLine = fragment.getStartingLine1() + fragment.getModifiedLines1();
        }
        return result;
    }

    private String getRelativePath(String basePath, String secondPath) {
        String secondModified;
        String baseModified = FileUtil.toSystemIndependentName((String)basePath);
        String relPath = FileUtil.getRelativePath((String)baseModified, (String)(secondModified = FileUtil.toSystemIndependentName((String)secondPath)), (char)'/', (boolean)this.myIsCaseSensitive);
        if (relPath == null) {
            return secondModified;
        }
        return relPath;
    }

    private static String getRevisionName(AirContentRevision revision) {
        String revisionName = revision.getRevisionNumber();
        if (revisionName != null) {
            return MessageFormat.format(REVISION_NAME_TEMPLATE, revisionName);
        }
        return new Date(revision.getPath().lastModified()).toString();
    }

    private TextFilePatch buildPatchHeading(String basePath, AirContentRevision beforeRevision, AirContentRevision afterRevision) {
        TextFilePatch result = new TextFilePatch();
        this.setPatchHeading(result, basePath, beforeRevision, afterRevision);
        return result;
    }

    private void setPatchHeading(FilePatch result, String basePath, @NotNull AirContentRevision beforeRevision, @NotNull AirContentRevision afterRevision) {
        if (beforeRevision == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/diff/impl/patch/TextPatchBuilder.setPatchHeading must not be null");
        }
        if (afterRevision == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/diff/impl/patch/TextPatchBuilder.setPatchHeading must not be null");
        }
        result.setBeforeName(this.getRelativePath(basePath, beforeRevision.getPath().getPath()));
        result.setBeforeVersionId(TextPatchBuilder.getRevisionName(beforeRevision));
        result.setAfterName(this.getRelativePath(basePath, afterRevision.getPath().getPath()));
        result.setAfterVersionId(TextPatchBuilder.getRevisionName(afterRevision));
    }
}

