/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.ex;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.OrderedSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Collection;

public class CompilerPathsEx
extends CompilerPaths {
    public static File getZippedOutputPath(Project project, String outputDirectoryPath) {
        File outputDir = new File(outputDirectoryPath);
        return new File(CompilerPathsEx.getZipStoreDirectory(project), "_" + outputDir.getName() + Integer.toHexString(outputDirectoryPath.hashCode()) + ".zip");
    }

    public static File getZipStoreDirectory(Project project) {
        return new File(CompilerPathsEx.getCompilerSystemDirectory(project), ".zip");
    }

    public static void visitFiles(VirtualFile[] directories, final FileVisitor visitor) {
        for (final VirtualFile outputDir : directories) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    String path = outputDir.getPath();
                    visitor.accept(outputDir, path, path);
                }
            });
        }
    }

    public static String[] getOutputPaths(Module[] modules) {
        OrderedSet outputPaths = new OrderedSet(TObjectHashingStrategy.CANONICAL);
        for (Module module : modules) {
            String outputPathForTestsUrl;
            CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance(module);
            if (compilerModuleExtension == null) continue;
            String outputPathUrl = compilerModuleExtension.getCompilerOutputUrl();
            if (outputPathUrl != null) {
                outputPaths.add(VirtualFileManager.extractPath(outputPathUrl).replace('/', File.separatorChar));
            }
            if ((outputPathForTestsUrl = compilerModuleExtension.getCompilerOutputUrlForTests()) == null) continue;
            outputPaths.add(VirtualFileManager.extractPath(outputPathForTestsUrl).replace('/', File.separatorChar));
        }
        return ArrayUtil.toStringArray((Collection)outputPaths);
    }

    public static VirtualFile[] getOutputDirectories(Module[] modules) {
        OrderedSet dirs = new OrderedSet(TObjectHashingStrategy.CANONICAL);
        for (Module module : modules) {
            VirtualFile testsOutputDir;
            VirtualFile outputDir = CompilerPathsEx.getModuleOutputDirectory(module, false);
            if (outputDir != null) {
                dirs.add(outputDir);
            }
            if ((testsOutputDir = CompilerPathsEx.getModuleOutputDirectory(module, true)) == null) continue;
            dirs.add(testsOutputDir);
        }
        return VfsUtil.toVirtualFileArray((Collection<? extends VirtualFile>)dirs);
    }

    public static class FileVisitor {
        protected void accept(VirtualFile file, String fileRoot, String filePath) {
            if (file.isDirectory()) {
                this.acceptDirectory(file, fileRoot, filePath);
            } else {
                this.acceptFile(file, fileRoot, filePath);
            }
        }

        protected void acceptFile(VirtualFile file, String fileRoot, String filePath) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void acceptDirectory(VirtualFile file, String fileRoot, String filePath) {
            VirtualFile[] children;
            ProgressManager.checkCanceled();
            for (VirtualFile child : children = file.getChildren()) {
                String _filePath;
                String name = child.getName();
                StringBuilder buf = StringBuilderSpinAllocator.alloc();
                try {
                    buf.append(filePath).append("/").append(name);
                    _filePath = buf.toString();
                }
                finally {
                    StringBuilderSpinAllocator.dispose((StringBuilder)buf);
                }
                this.accept(child, fileRoot, _filePath);
            }
        }
    }
}

