/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ConcurrentHashMap;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Language
extends UserDataHolderBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.Language");
    private static final Map<Class<? extends Language>, Language> ourRegisteredLanguages = new THashMap();
    private static final Map<String, Language> ourRegisteredIDs = new THashMap();
    private final Language myBaseLanguage;
    private final String myID;
    private final String[] myMimeTypes;
    public static final Language ANY = new Language(""){};

    protected Language(@NotNull @NonNls String id) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/Language.<init> must not be null");
        }
        this(id, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    protected Language(@NotNull @NonNls String ID2, String ... mimeTypes) {
        if (ID2 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/Language.<init> must not be null");
        }
        if (mimeTypes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/Language.<init> must not be null");
        }
        this((Language)null, ID2, mimeTypes);
    }

    protected Language(@Nullable Language baseLanguage, @NotNull @NonNls String ID2, String ... mimeTypes) {
        if (ID2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/Language.<init> must not be null");
        }
        if (mimeTypes == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/lang/Language.<init> must not be null");
        }
        this.myBaseLanguage = baseLanguage;
        this.myID = ID2;
        this.myMimeTypes = mimeTypes;
        Class<?> langClass = ((Object)((Object)this)).getClass();
        Language prev = ourRegisteredLanguages.put(langClass, this);
        if (prev != null) {
            LOG.error("Language of '" + langClass + "' is already registered: " + (Object)((Object)prev));
            return;
        }
        prev = ourRegisteredIDs.put(ID2, this);
        if (prev != null) {
            LOG.error("Language with ID '" + ID2 + "' is already registered: " + ((Object)((Object)prev)).getClass());
        }
    }

    protected ConcurrentMap<Key, Object> createDataMap() {
        return new ConcurrentHashMap();
    }

    public static Collection<Language> getRegisteredLanguages() {
        return Collections.unmodifiableCollection(ourRegisteredLanguages.values());
    }

    public static <T extends Language> T findInstance(Class<T> klass) {
        return (T)((Object)ourRegisteredLanguages.get(klass));
    }

    public String toString() {
        return "Language: " + this.myID;
    }

    @NotNull
    public String[] getMimeTypes() {
        if (this.myMimeTypes == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/Language.getMimeTypes must not return null");
        }
        return this.myMimeTypes;
    }

    @NotNull
    public String getID() {
        String string = this.myID;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/Language.getID must not return null");
        }
        return string;
    }

    @Nullable
    public FileType getAssociatedFileType() {
        FileType[] types;
        for (FileType fileType : types = FileTypeManager.getInstance().getRegisteredFileTypes()) {
            if (!(fileType instanceof LanguageFileType) || ((LanguageFileType)fileType).getLanguage() != this) continue;
            return fileType;
        }
        for (FileType fileType : types) {
            if (!(fileType instanceof LanguageFileType) || !this.isKindOf(((LanguageFileType)fileType).getLanguage())) continue;
            return fileType;
        }
        return null;
    }

    @Nullable
    public Language getBaseLanguage() {
        return this.myBaseLanguage;
    }

    public String getDisplayName() {
        return this.getID();
    }

    public final boolean is(Language another) {
        return this == another;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public final boolean isKindOf(Language another) {
        for (Language l = this; l != null; l = l.getBaseLanguage()) {
            if (!l.is(another)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Language findLanguageByID(String id) {
        Collection<Language> languages = Language.getRegisteredLanguages();
        for (Language language : languages) {
            if (!language.getID().equals(id)) continue;
            return language;
        }
        return null;
    }
}

