/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView;

import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionCache;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextEditorBasedStructureViewModel
implements StructureViewModel {
    private final Editor myEditor;
    private final PsiFile myPsiFile;
    private final CaretListener myCaretListener;
    private final List<FileEditorPositionListener> myListeners;

    protected TextEditorBasedStructureViewModel(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/structureView/TextEditorBasedStructureViewModel.<init> must not be null");
        }
        this(TextEditorBasedStructureViewModel.getEditorForFile(psiFile), psiFile);
    }

    protected TextEditorBasedStructureViewModel(Editor editor) {
        this(editor, null);
    }

    private TextEditorBasedStructureViewModel(Editor editor, PsiFile file) {
        this.myListeners = ContainerUtil.createEmptyCOWList();
        this.myEditor = editor;
        this.myPsiFile = file;
        this.myCaretListener = new CaretListener(){

            @Override
            public void caretPositionChanged(CaretEvent e) {
                if (Comparing.equal((Object)e.getEditor(), (Object)TextEditorBasedStructureViewModel.this.myEditor)) {
                    this.fireCaretPositionChanged();
                }
            }

            private void fireCaretPositionChanged() {
                for (FileEditorPositionListener listener : TextEditorBasedStructureViewModel.this.myListeners) {
                    listener.onCurrentElementChanged();
                }
            }
        };
        EditorFactory.getInstance().getEventMulticaster().addCaretListener(this.myCaretListener);
    }

    @Nullable
    private static Editor getEditorForFile(@NotNull PsiFile psiFile) {
        FileEditor[] editors;
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/structureView/TextEditorBasedStructureViewModel.getEditorForFile must not be null");
        }
        VirtualFile virtualFile = psiFile.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        for (FileEditor editor : editors = FileEditorManager.getInstance(psiFile.getProject()).getEditors(virtualFile)) {
            if (!(editor instanceof TextEditor)) continue;
            return ((TextEditor)editor).getEditor();
        }
        return null;
    }

    @Override
    public final void addEditorPositionListener(FileEditorPositionListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public final void removeEditorPositionListener(FileEditorPositionListener listener) {
        this.myListeners.remove(listener);
    }

    @Override
    public void dispose() {
        EditorFactory.getInstance().getEventMulticaster().removeCaretListener(this.myCaretListener);
    }

    @Override
    public boolean shouldEnterElement(Object element) {
        return false;
    }

    @Override
    public Object getCurrentEditorElement() {
        if (this.myEditor == null) {
            return null;
        }
        int offset = this.myEditor.getCaretModel().getOffset();
        PsiFile file = this.getPsiFile();
        return this.findAcceptableElement(file.getViewProvider().findElementAt(offset, file.getLanguage()));
    }

    protected Object findAcceptableElement(PsiElement element) {
        while (element != null && !(element instanceof PsiFile)) {
            if (this.isSuitable(element)) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    protected PsiFile getPsiFile() {
        return this.myPsiFile;
    }

    protected boolean isSuitable(PsiElement element) {
        Class[] suitableClasses;
        if (element == null) {
            return false;
        }
        for (Class suitableClass : suitableClasses = this.getSuitableClasses()) {
            if (!ReflectionCache.isAssignable((Class)suitableClass, element.getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addModelListener(ModelListener modelListener) {
    }

    @Override
    public void removeModelListener(ModelListener modelListener) {
    }

    @NotNull
    protected Class[] getSuitableClasses() {
        if (ArrayUtil.EMPTY_CLASS_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/TextEditorBasedStructureViewModel.getSuitableClasses must not return null");
        }
        return ArrayUtil.EMPTY_CLASS_ARRAY;
    }

    protected Editor getEditor() {
        return this.myEditor;
    }

    @Override
    @NotNull
    public Grouper[] getGroupers() {
        if (Grouper.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/TextEditorBasedStructureViewModel.getGroupers must not return null");
        }
        return Grouper.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public Sorter[] getSorters() {
        if (Sorter.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/TextEditorBasedStructureViewModel.getSorters must not return null");
        }
        return Sorter.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public Filter[] getFilters() {
        if (Filter.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/TextEditorBasedStructureViewModel.getFilters must not return null");
        }
        return Filter.EMPTY_ARRAY;
    }
}

