/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.ProgramRunnerUtil;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryConfiguration;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizable;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenericProgramRunner<Settings extends JDOMExternalizable>
implements ProgramRunner<Settings> {
    public static final DataKey<RunContentDescriptor> CONTENT_TO_REUSE_DATA_KEY = DataKey.create("contentToReuse");
    @Deprecated
    @NonNls
    public static final String CONTENT_TO_REUSE = CONTENT_TO_REUSE_DATA_KEY.getName();

    @Override
    @Nullable
    public Settings createConfigurationData(ConfigurationInfoProvider settingsProvider) {
        return null;
    }

    @Override
    public void checkConfiguration(RunnerSettings settings, ConfigurationPerRunnerSettings configurationPerRunnerSettings) throws RuntimeConfigurationException {
    }

    @Override
    public void onProcessStarted(RunnerSettings settings, ExecutionResult executionResult) {
    }

    @Override
    public AnAction[] createActions(ExecutionResult executionResult) {
        return AnAction.EMPTY_ARRAY;
    }

    @Override
    @Nullable
    public SettingsEditor<Settings> getSettingsEditor(Executor executor, RunConfiguration configuration) {
        return null;
    }

    @Override
    public void execute(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/runners/GenericProgramRunner.execute must not be null");
        }
        if (environment == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/runners/GenericProgramRunner.execute must not be null");
        }
        this.execute(executor, environment, null);
    }

    @Override
    public void execute(final @NotNull Executor executor, final @NotNull ExecutionEnvironment env, final @Nullable ProgramRunner.Callback callback) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/runners/GenericProgramRunner.execute must not be null");
        }
        if (env == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/runners/GenericProgramRunner.execute must not be null");
        }
        final RunProfile profile = env.getRunProfile();
        final Project project = env.getProject();
        if (project == null) {
            return;
        }
        final RunContentDescriptor reuseContent = ExecutionManager.getInstance(project).getContentManager().getReuseContent(executor, env.getContentToReuse());
        final RunProfileState state = env.getState(executor);
        if (state == null) {
            return;
        }
        Runnable startRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (project.isDisposed()) {
                        return;
                    }
                    RunContentDescriptor descriptor = GenericProgramRunner.this.doExecute(project, executor, state, reuseContent, env);
                    if (callback != null) {
                        callback.processStarted(descriptor);
                    }
                    if (descriptor != null) {
                        if (LocalHistoryConfiguration.getInstance().ADD_LABEL_ON_RUNNING) {
                            LocalHistory.putSystemLabel(project, executor.getId() + " " + profile.getName());
                        }
                        ExecutionManager.getInstance(project).getContentManager().showRunContent(executor, descriptor);
                        ProcessHandler processHandler = descriptor.getProcessHandler();
                        if (processHandler != null) {
                            processHandler.startNotify();
                        }
                    }
                }
                catch (ExecutionException e) {
                    ProgramRunnerUtil.handleExecutionError(project, profile, e);
                }
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            startRunnable.run();
        } else {
            ExecutionManager.getInstance(project).compileAndRun(startRunnable, profile, state);
        }
    }

    @Nullable
    protected abstract RunContentDescriptor doExecute(Project var1, Executor var2, RunProfileState var3, RunContentDescriptor var4, ExecutionEnvironment var5) throws ExecutionException;
}

