/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.executors;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.ui.UIBundle;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DefaultRunExecutor
extends Executor {
    @NonNls
    public static final String EXECUTOR_ID = ToolWindowId.RUN;
    private static final Icon ICON = IconLoader.getIcon((String)"/actions/execute.png");
    private static final Icon TOOLWINDOW_ICON = IconLoader.getIcon((String)"/general/toolWindowRun.png");
    private static final Icon DISABLED_ICON = IconLoader.getIcon((String)"/process/disabledRun.png");

    @Override
    @NotNull
    public String getStartActionText() {
        String string = ExecutionBundle.message("default.runner.start.action.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/executors/DefaultRunExecutor.getStartActionText must not return null");
        }
        return string;
    }

    @Override
    public String getToolWindowId() {
        return ToolWindowId.RUN;
    }

    @Override
    public Icon getToolWindowIcon() {
        return TOOLWINDOW_ICON;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = ICON;
        if (icon == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/executors/DefaultRunExecutor.getIcon must not return null");
        }
        return icon;
    }

    @Override
    public Icon getDisabledIcon() {
        return DISABLED_ICON;
    }

    @Override
    public String getDescription() {
        return ExecutionBundle.message("standard.runner.description", new Object[0]);
    }

    @Override
    @NotNull
    public String getActionName() {
        String string = UIBundle.message((String)"tool.window.name.run", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/executors/DefaultRunExecutor.getActionName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String getId() {
        String string = EXECUTOR_ID;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/executors/DefaultRunExecutor.getId must not return null");
        }
        return string;
    }

    @Override
    public String getContextActionId() {
        return "RunClass";
    }

    @Override
    public String getHelpId() {
        return "ideaInterface.run";
    }

    public static Executor getRunExecutorInstance() {
        return ExecutorRegistry.getInstance().getExecutorById(EXECUTOR_ID);
    }
}

