/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralCommandLine {
    private Map<String, String> myEnvParams;
    private boolean myPassParentEnvs;
    private String myExePath = null;
    private File myWorkDirectory = null;
    private ParametersList myProgramParams = new ParametersList();
    private Charset myCharset = CharsetToolkit.getDefaultSystemCharset();

    public void setExePath(@NonNls String exePath) {
        this.myExePath = exePath.trim();
    }

    public void setWorkDirectory(@NonNls String path) {
        this.setWorkingDirectory(path != null ? new File(path) : null);
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.myWorkDirectory = workingDirectory;
    }

    public void setEnvParams(Map<String, String> envParams) {
        this.myEnvParams = envParams;
    }

    public void setCharset(@NotNull Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/configurations/GeneralCommandLine.setCharset must not be null");
        }
        this.myCharset = charset;
        this.addParameter("-Dfile.encoding=" + charset.name());
    }

    public void addParameters(String ... parameters) {
        for (String parameter : parameters) {
            this.addParameter(parameter);
        }
    }

    public void addParameters(List<String> parameters) {
        for (String parameter : parameters) {
            this.addParameter(parameter);
        }
    }

    public void addParameter(@NotNull @NonNls String parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/configurations/GeneralCommandLine.addParameter must not be null");
        }
        this.myProgramParams.add(parameter);
    }

    public String getCommandLineString() {
        StringBuffer buffer = new StringBuffer(GeneralCommandLine.quoteParameter(this.myExePath));
        this.appendParams(buffer);
        return buffer.toString();
    }

    public String getCommandLineParams() {
        StringBuffer buffer = new StringBuffer();
        this.appendParams(buffer);
        return buffer.toString();
    }

    private void appendParams(StringBuffer buffer) {
        for (String param : this.myProgramParams.getList()) {
            buffer.append(" ").append(GeneralCommandLine.quoteParameter(param));
        }
    }

    public Charset getCharset() {
        return this.myCharset;
    }

    public Process createProcess() throws ExecutionException {
        this.checkWorkingDirectory();
        try {
            String[] commands = this.getCommands();
            if (commands[0] == null) {
                throw new ExecutionException(IdeBundle.message("run.configuration.error.executable.not.specified", new Object[0]));
            }
            return this.myWorkDirectory != null ? Runtime.getRuntime().exec(commands, this.getEnvParamsArray(), this.myWorkDirectory) : Runtime.getRuntime().exec(commands, this.getEnvParamsArray());
        }
        catch (IOException e) {
            throw new ProcessNotCreatedException(e.getMessage(), e, this);
        }
    }

    private void checkWorkingDirectory() throws ExecutionException {
        if (this.myWorkDirectory == null) {
            return;
        }
        if (!this.myWorkDirectory.exists()) {
            throw new ExecutionException(IdeBundle.message("run.configuration.error.working.directory.does.not.exist", this.myWorkDirectory.getAbsolutePath()));
        }
        if (!this.myWorkDirectory.isDirectory()) {
            throw new ExecutionException(IdeBundle.message("run.configuration.error.working.directory.not.directory", new Object[0]));
        }
    }

    @Nullable
    public Map<String, String> getEnvParams() {
        return this.myEnvParams;
    }

    @Nullable
    private String[] getEnvParamsArray() {
        if (this.myEnvParams == null) {
            return null;
        }
        HashMap<String, String> envParams = new HashMap<String, String>();
        if (this.myPassParentEnvs) {
            envParams.putAll(System.getenv());
        }
        envParams.putAll(this.myEnvParams);
        String[] result = new String[envParams.size()];
        int i = 0;
        for (String key : envParams.keySet()) {
            result[i++] = key + "=" + ((String)envParams.get(key)).trim();
        }
        return result;
    }

    public String[] getCommands() {
        List<String> parameters = this.myProgramParams.getList();
        String[] result = new String[parameters.size() + 1];
        result[0] = this.myExePath;
        int index = 1;
        Iterator<String> iterator = parameters.iterator();
        while (iterator.hasNext()) {
            result[index] = iterator.next();
            ++index;
        }
        return result;
    }

    public ParametersList getParametersList() {
        return this.myProgramParams;
    }

    private static String quoteParameter(String param) {
        if (!SystemInfo.isWindows) {
            return param;
        }
        return GeneralCommandLine.quote(param);
    }

    public static String quote(String parameter) {
        if (parameter == null || !GeneralCommandLine.hasWhitespace(parameter)) {
            return parameter;
        }
        if (parameter.length() >= 2 && parameter.startsWith("\"") && parameter.endsWith("\"")) {
            return parameter;
        }
        return "\"" + parameter + (parameter.endsWith("\\") ? "\\\"" : "\"");
    }

    private static boolean hasWhitespace(String string) {
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public GeneralCommandLine clone() {
        GeneralCommandLine clone = new GeneralCommandLine();
        clone.myCharset = this.myCharset;
        clone.myExePath = this.myExePath;
        clone.myWorkDirectory = this.myWorkDirectory;
        clone.myProgramParams = this.myProgramParams.clone();
        clone.myEnvParams = this.myEnvParams != null ? new HashMap<String, String>(this.myEnvParams) : null;
        return clone;
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.myPassParentEnvs = passParentEnvs;
    }
}

