/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.ui.DocumentAdapter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;
import org.jetbrains.annotations.NonNls;

public class SingleIntegerFieldOptionsPanel
extends JPanel {
    public SingleIntegerFieldOptionsPanel(String labelString, InspectionProfileEntry owner, @NonNls String property) {
        this(labelString, owner, property, 2);
    }

    public SingleIntegerFieldOptionsPanel(String labelString, final InspectionProfileEntry owner, final @NonNls String property, int integerFieldColumns) {
        super(new GridBagLayout());
        JLabel label = new JLabel(labelString);
        NumberFormat formatter = NumberFormat.getIntegerInstance();
        formatter.setParseIntegerOnly(true);
        final JFormattedTextField valueField = new JFormattedTextField(formatter);
        valueField.setValue(SingleIntegerFieldOptionsPanel.getPropertyValue(owner, property));
        valueField.setColumns(integerFieldColumns);
        Document document = valueField.getDocument();
        document.addDocumentListener(new DocumentAdapter(){

            @Override
            public void textChanged(DocumentEvent e) {
                try {
                    valueField.commitEdit();
                    SingleIntegerFieldOptionsPanel.setPropertyValue(owner, property, ((Number)valueField.getValue()).intValue());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets.left = 4;
        constraints.insets.top = 4;
        constraints.weightx = 0.0;
        constraints.anchor = 23;
        constraints.fill = 0;
        this.add((Component)label, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 23;
        constraints.fill = 0;
        this.add((Component)valueField, constraints);
    }

    private static void setPropertyValue(InspectionProfileEntry owner, String property, int value) {
        try {
            owner.getClass().getField(property).setInt(owner, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int getPropertyValue(InspectionProfileEntry owner, String property) {
        try {
            return owner.getClass().getField(property).getInt(owner);
        }
        catch (Exception e) {
            return 0;
        }
    }
}

