/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;

public class BaseGenerateAction
extends CodeInsightAction {
    private final CodeInsightActionHandler myHandler;

    public BaseGenerateAction(CodeInsightActionHandler handler) {
        this.myHandler = handler;
    }

    @Override
    protected final CodeInsightActionHandler getHandler() {
        return this.myHandler;
    }

    @Nullable
    protected PsiClass getTargetClass(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiClass target = PsiTreeUtil.getParentOfType(element, PsiClass.class);
        return target instanceof SyntheticElement ? null : target;
    }

    @Override
    protected boolean isValidForFile(Project project, Editor editor, PsiFile file) {
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        if (file instanceof PsiCompiledElement) {
            return false;
        }
        PsiDocumentManager.getInstance(project).commitAllDocuments();
        PsiClass targetClass = this.getTargetClass(editor, file);
        if (targetClass == null) {
            return false;
        }
        return this.isValidForClass(targetClass);
    }

    protected boolean isValidForClass(PsiClass targetClass) {
        return !targetClass.isInterface();
    }
}

