/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import org.jetbrains.annotations.Nullable;

public class PrioritizedLookupElement<T extends LookupElement>
extends LookupElementDecorator<T> {
    private final double myPriority;
    private final int myGrouping;

    public PrioritizedLookupElement(T delegate, double priority, int grouping) {
        super(delegate);
        this.myPriority = priority;
        this.myGrouping = grouping;
    }

    public double getPriority() {
        return this.myPriority;
    }

    public int getGrouping() {
        return this.myGrouping;
    }

    public static LookupElement withPriority(LookupElement element, double priority) {
        PrioritizedLookupElement prioritized = PrioritizedLookupElement.from(element);
        return new PrioritizedLookupElement<LookupElement>(element, priority, prioritized == null ? 0 : prioritized.getGrouping());
    }

    public static LookupElement withGrouping(LookupElement element, int grouping) {
        PrioritizedLookupElement prioritized = PrioritizedLookupElement.from(element);
        return new PrioritizedLookupElement<LookupElement>(element, prioritized == null ? 0.0 : prioritized.getPriority(), grouping);
    }

    @Nullable
    public static PrioritizedLookupElement from(LookupElement element) {
        if (element instanceof PrioritizedLookupElement) {
            return (PrioritizedLookupElement)element;
        }
        if (element instanceof LookupElementDecorator) {
            return PrioritizedLookupElement.from(((LookupElementDecorator)element).getDelegate());
        }
        return null;
    }
}

