/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CharTailType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessors;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiUtilBase;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class TailType {
    public static final TailType UNKNOWN = new TailType(){

        @Override
        public int processTail(Editor editor, int tailOffset) {
            return tailOffset;
        }

        public String toString() {
            return "UNKNOWN";
        }
    };
    public static final TailType NONE = new TailType(){

        @Override
        public int processTail(Editor editor, int tailOffset) {
            return tailOffset;
        }

        public String toString() {
            return "NONE";
        }
    };
    public static final TailType SEMICOLON = new CharTailType(';');
    public static final TailType EXCLAMATION = new CharTailType('!');
    public static final TailType COMMA = new TailType(){

        @Override
        public int processTail(Editor editor, int tailOffset) {
            CodeStyleSettings styleSettings = CodeStyleSettingsManager.getSettings(editor.getProject());
            if (styleSettings.SPACE_BEFORE_COMMA) {
                tailOffset = 3.insertChar(editor, tailOffset, ' ');
            }
            tailOffset = 3.insertChar(editor, tailOffset, ',');
            if (styleSettings.SPACE_AFTER_COMMA) {
                tailOffset = 3.insertChar(editor, tailOffset, ' ');
            }
            return tailOffset;
        }

        public String toString() {
            return "COMMA";
        }
    };
    public static final TailType SPACE = new CharTailType(' ');
    public static final TailType DOT = new CharTailType('.');
    public static final TailType CASE_COLON = new CharTailType(':');
    public static final TailType COND_EXPR_COLON = new TailType(){

        @Override
        public int processTail(Editor editor, int tailOffset) {
            Document document = editor.getDocument();
            int textLength = document.getTextLength();
            CharSequence chars = document.getCharsSequence();
            if (tailOffset < textLength - 1 && chars.charAt(tailOffset) == ' ' && chars.charAt(tailOffset + 1) == ':') {
                return 4.moveCaret(editor, tailOffset, 2);
            }
            if (tailOffset < textLength && chars.charAt(tailOffset) == ':') {
                return 4.moveCaret(editor, tailOffset, 1);
            }
            document.insertString(tailOffset, " : ");
            return 4.moveCaret(editor, tailOffset, 3);
        }

        public String toString() {
            return "COND_EXPR_COLON";
        }
    };
    public static final TailType EQ = new TailType(){

        @Override
        public int processTail(Editor editor, int tailOffset) {
            CodeStyleSettings styleSettings = CodeStyleSettingsManager.getSettings(editor.getProject());
            Document document = editor.getDocument();
            int textLength = document.getTextLength();
            CharSequence chars = document.getCharsSequence();
            if (tailOffset < textLength - 1 && chars.charAt(tailOffset) == ' ' && chars.charAt(tailOffset + 1) == '=') {
                return 5.moveCaret(editor, tailOffset, 2);
            }
            if (tailOffset < textLength && chars.charAt(tailOffset) == '=') {
                return 5.moveCaret(editor, tailOffset, 1);
            }
            if (styleSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS) {
                document.insertString(tailOffset, " =");
                tailOffset = 5.moveCaret(editor, tailOffset, 2);
            } else {
                document.insertString(tailOffset, "=");
                tailOffset = 5.moveCaret(editor, tailOffset, 1);
            }
            if (styleSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS) {
                tailOffset = 5.insertChar(editor, tailOffset, ' ');
            }
            return tailOffset;
        }

        public String toString() {
            return "EQ";
        }
    };
    public static final TailType LPARENTH = new CharTailType('(');
    public static final TailType SMART_COMPLETION = new TailType(){

        @Override
        public int processTail(Editor editor, int tailOffset) {
            Project project = editor.getProject();
            Document doc = editor.getDocument();
            Language language = PsiUtilBase.getLanguageInEditor(editor, project);
            List processors = SmartEnterProcessors.INSTANCE.forKey(language);
            if (processors.size() > 0) {
                for (SmartEnterProcessor processor : processors) {
                    processor.process(project, editor, PsiDocumentManager.getInstance(project).getPsiFile(doc));
                }
            }
            return tailOffset;
        }

        @NonNls
        public String toString() {
            return "SMART_COMPLETION";
        }
    };

    public static int insertChar(Editor editor, int tailOffset, char c) {
        Document document = editor.getDocument();
        int textLength = document.getTextLength();
        CharSequence chars = document.getCharsSequence();
        if (tailOffset == textLength || chars.charAt(tailOffset) != c) {
            document.insertString(tailOffset, String.valueOf(c));
        }
        return TailType.moveCaret(editor, tailOffset, 1);
    }

    protected static int moveCaret(Editor editor, int tailOffset, int delta) {
        CaretModel model = editor.getCaretModel();
        if (model.getOffset() == tailOffset) {
            model.moveToOffset(tailOffset + delta);
        }
        return tailOffset + delta;
    }

    public abstract int processTail(Editor var1, int var2);

    public static TailType createSimpleTailType(char c) {
        return new CharTailType(c);
    }

    public boolean isApplicable(@NotNull InsertionContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/TailType.isApplicable must not be null");
        }
        return true;
    }
}

