/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.commander;

import com.intellij.ide.commander.Commander;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import java.util.ArrayList;
import java.util.List;

public class CommanderHistory {
    public static final int HISTORY_LIMIT = 60;
    private final Commander myCommander;
    private final List<HistoryState> myHistory = new ArrayList<HistoryState>();
    private int myCurrentCommandIndex = 0;
    private boolean myStateLoggingEnabled = true;

    public CommanderHistory(Commander commander) {
        this.myCommander = commander;
    }

    public void clearHistory() {
        this.myHistory.clear();
        this.myCurrentCommandIndex = 0;
    }

    public void saveState(PsiElement element, boolean isElementExpanded, boolean isLeftPanel) {
        if (!this.myStateLoggingEnabled) {
            return;
        }
        if (this.myCurrentCommandIndex >= 0 && this.myCurrentCommandIndex < this.myHistory.size() - 1) {
            this.myHistory.subList(this.myCurrentCommandIndex + 1, this.myHistory.size()).clear();
        }
        if (this.myHistory.size() == 60) {
            this.myHistory.remove(0);
        }
        this.myHistory.add(new HistoryState(element, isElementExpanded, isLeftPanel));
        this.myCurrentCommandIndex = this.myHistory.size() - 1;
    }

    public void back() {
        if (this.applyState(this.getHistoryState(this.myCurrentCommandIndex - 1))) {
            --this.myCurrentCommandIndex;
        }
    }

    public boolean canGoBack() {
        return this.getHistoryState(this.myCurrentCommandIndex - 1) != null;
    }

    public void forward() {
        if (this.applyState(this.getHistoryState(this.myCurrentCommandIndex + 1))) {
            ++this.myCurrentCommandIndex;
        }
    }

    public boolean canGoForward() {
        return this.getHistoryState(this.myCurrentCommandIndex + 1) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean applyState(HistoryState state) {
        this.myStateLoggingEnabled = false;
        try {
            if (state != null) {
                PsiElement element = state.getElement();
                boolean shouldOpenInLeftPanel = state.isInLeftPanel();
                if (state.isElementExpanded()) {
                    boolean isLeftPanelCurrentlyActive = this.myCommander.isLeftPanelActive();
                    if (shouldOpenInLeftPanel && !isLeftPanelCurrentlyActive || !shouldOpenInLeftPanel && isLeftPanelCurrentlyActive) {
                        this.myCommander.switchActivePanel();
                    }
                    this.myCommander.enterElementInActivePanel(element);
                } else if (shouldOpenInLeftPanel) {
                    this.myCommander.selectElementInLeftPanel(element, PsiUtilBase.getVirtualFile((PsiElement)element));
                } else {
                    this.myCommander.selectElementInRightPanel(element, PsiUtilBase.getVirtualFile((PsiElement)element));
                }
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.myStateLoggingEnabled = true;
        }
        return false;
    }

    private HistoryState getHistoryState(int index) {
        if (index >= 0 && index < this.myHistory.size()) {
            return this.myHistory.get(index);
        }
        return null;
    }

    private static final class HistoryState {
        private final PsiElement myElement;
        private final boolean myElementExpanded;
        private final boolean myIsLeftPanel;

        public HistoryState(PsiElement element, boolean isElementExpanded, boolean isLeftPanel) {
            this.myElement = element;
            this.myElementExpanded = isElementExpanded;
            this.myIsLeftPanel = isLeftPanel;
        }

        public boolean isInLeftPanel() {
            return this.myIsLeftPanel;
        }

        public boolean isElementExpanded() {
            return this.myElementExpanded;
        }

        public PsiElement getElement() {
            return this.myElement;
        }
    }
}

