/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.validation;

import com.intellij.lang.ant.AntSupport;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntProject;
import com.intellij.lang.ant.psi.impl.AntImportsIndex;
import com.intellij.openapi.editor.HectorComponentPanel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;

public class AntHectorConfigurable
extends HectorComponentPanel {
    @NonNls
    private static final String NONE = "<None>";
    @NonNls
    public static final String CONTEXTS_COMBO_KEY = "AntContextsComboBox";
    private final AntFile myFile;
    private final String myLocalPath;
    private final Map<String, AntFile> myPathToFileMap = new HashMap<String, AntFile>();
    private String myOriginalContext = "<None>";
    private JComboBox myCombo;
    private final GlobalSearchScope myFileFilter;

    public AntHectorConfigurable(AntFile file) {
        this.myFile = file;
        VirtualFile selfVFile = this.myFile.getVirtualFile();
        this.myLocalPath = PathUtil.getLocalPath((VirtualFile)selfVFile);
        Project project = file.getProject();
        this.myFileFilter = GlobalSearchScope.projectScope((Project)project);
    }

    public boolean canClose() {
        return !this.myCombo.isPopupVisible();
    }

    public JComponent createComponent() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("File Context"));
        this.myCombo = new ComboBox();
        this.myCombo.putClientProperty(CONTEXTS_COMBO_KEY, Boolean.TRUE);
        panel.add((Component)new JLabel("Included into:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        panel.add((Component)this.myCombo, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        FileBasedIndex fbi = FileBasedIndex.getInstance();
        Collection antFiles = fbi.getContainingFiles(AntImportsIndex.INDEX_NAME, (Object)AntImportsIndex.ANT_FILES_WITH_IMPORTS_KEY, this.myFileFilter);
        for (VirtualFile file : antFiles) {
            AntFile antFile = AntSupport.toAntFile(file, this.myFile.getProject());
            if (antFile == null || antFile.equals(this.myFile)) continue;
            String path = PathUtil.getLocalPath((VirtualFile)file);
            AntFile previous = this.myPathToFileMap.put(path, antFile);
            assert (previous == null);
        }
        AntConfigurationBase antConfig = AntConfigurationBase.getInstance(this.myFile.getProject());
        for (AntBuildFile buildFile : antConfig.getBuildFiles()) {
            AntProject antProject;
            String path;
            AntFile antFile = (AntFile)buildFile.getAntFile();
            String string = path = antFile != null ? PathUtil.getLocalPath((VirtualFile)antFile.getVirtualFile()) : null;
            if (path == null || this.myPathToFileMap.containsKey(path) || FileUtil.pathsEqual((String)path, (String)this.myLocalPath) || (antProject = antFile.getAntProject()) == null || antProject.getImportedFiles().length <= 0) continue;
            this.myPathToFileMap.put(path, antFile);
        }
        ArrayList<String> paths = new ArrayList<String>(this.myPathToFileMap.keySet());
        Collections.sort(paths, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        this.myCombo.addItem(NONE);
        for (String path : paths) {
            this.myCombo.addItem(path);
        }
        AntFile currentContext = antConfig.getContextFile(this.myFile);
        if (currentContext != null) {
            VirtualFile vFile = currentContext.getVirtualFile();
            assert (vFile != null);
            String path = PathUtil.getLocalPath((VirtualFile)vFile);
            if (!FileUtil.pathsEqual((String)path, (String)this.myLocalPath)) {
                this.myOriginalContext = path;
            }
        }
        this.myCombo.setSelectedItem(this.myOriginalContext);
        return panel;
    }

    public boolean isModified() {
        return !FileUtil.pathsEqual((String)this.myOriginalContext, (String)((String)this.myCombo.getSelectedItem()));
    }

    public void apply() throws ConfigurationException {
        this.applyItem((String)this.myCombo.getSelectedItem());
    }

    public void reset() {
        this.applyItem(this.myOriginalContext);
    }

    private void applyItem(String contextStr) {
        AntFile context = null;
        if (!NONE.equals(contextStr)) {
            context = this.myPathToFileMap.get(contextStr);
            assert (context != null);
        }
        AntConfigurationBase.getInstance(this.myFile.getProject()).setContextFile(this.myFile, context);
    }

    public void disposeUIResources() {
        this.myPathToFileMap.clear();
    }
}

