/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl.reference.providers;

import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.impl.AntAntImpl;
import com.intellij.lang.ant.psi.impl.AntCallImpl;
import com.intellij.lang.ant.psi.impl.AntProjectImpl;
import com.intellij.lang.ant.psi.impl.reference.AntTargetReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AntSingleTargetReferenceProvider
extends PsiReferenceProvider {
    @NonNls
    private static final Map<Class, String> ourTypesToAttributeNames = new HashMap();

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiReference[] psiReferenceArray;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/reference/providers/AntSingleTargetReferenceProvider.getReferencesByElement must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/ant/psi/impl/reference/providers/AntSingleTargetReferenceProvider.getReferencesByElement must not be null");
        }
        String attributeName = ourTypesToAttributeNames.get(element.getClass());
        if (attributeName == null) {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
            if (PsiReference.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/providers/AntSingleTargetReferenceProvider.getReferencesByElement must not return null");
            return psiReferenceArray;
        }
        AntElement antElement = (AntElement)element;
        XmlAttribute attr = ((XmlTag)antElement.getSourceElement()).getAttribute(attributeName, null);
        if (attr == null) {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
            if (PsiReference.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/providers/AntSingleTargetReferenceProvider.getReferencesByElement must not return null");
            return psiReferenceArray;
        }
        XmlAttributeValue valueElement = attr.getValueElement();
        if (valueElement == null) {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
            if (PsiReference.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/providers/AntSingleTargetReferenceProvider.getReferencesByElement must not return null");
            return psiReferenceArray;
        }
        int offsetInPosition = valueElement.getTextRange().getStartOffset() - antElement.getTextRange().getStartOffset() + 1;
        String attrValue = valueElement.getValue();
        psiReferenceArray = new PsiReference[]{new AntTargetReference(antElement, attrValue, new TextRange(offsetInPosition, offsetInPosition + attrValue.length()), attr)};
        if (psiReferenceArray != null) return psiReferenceArray;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/providers/AntSingleTargetReferenceProvider.getReferencesByElement must not return null");
    }

    static {
        ourTypesToAttributeNames.put(AntProjectImpl.class, "default");
        ourTypesToAttributeNames.put(AntCallImpl.class, "target");
        ourTypesToAttributeNames.put(AntAntImpl.class, "target");
    }
}

