/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl.reference;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.psi.impl.reference.AntReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.resolve.reference.impl.CachingReference;
import com.intellij.psi.xml.XmlAttribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AntGenericReference
extends CachingReference
implements AntReference {
    private final AntElement myAntElement;
    private final String myText;
    private final TextRange myTextRange;
    private final XmlAttribute myAttribute;

    protected AntGenericReference(AntElement element, String str, TextRange textRange, XmlAttribute attribute) {
        this.myAntElement = element;
        this.myText = str;
        this.myTextRange = textRange;
        this.myAttribute = attribute;
    }

    protected AntGenericReference(AntStructuredElement element, XmlAttribute attr) {
        this.myAntElement = element;
        this.myText = attr == null ? element.getSourceElement().getName() : attr.getName();
        int startInElement = attr == null ? 1 : attr.getTextRange().getStartOffset() - element.getTextRange().getStartOffset();
        this.myTextRange = new TextRange(startInElement, this.myText.length() + startInElement);
        this.myAttribute = attr;
    }

    protected AntGenericReference(AntStructuredElement element) {
        this(element, null);
    }

    public AntElement getElement() {
        return this.myAntElement;
    }

    public TextRange getRangeInElement() {
        return this.myTextRange;
    }

    public String getCanonicalText() {
        return this.myText;
    }

    @Override
    public boolean shouldBeSkippedByAnnotator() {
        return false;
    }

    @Override
    public void setShouldBeSkippedByAnnotator(boolean value) {
    }

    @Override
    @NotNull
    public IntentionAction[] getFixes() {
        if (IntentionAction.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/AntGenericReference.getFixes must not return null");
        }
        return IntentionAction.EMPTY_ARRAY;
    }

    protected XmlAttribute getAttribute() {
        return this.myAttribute;
    }

    @Override
    @Nullable
    public String getCanonicalRepresentationText() {
        AntElement element = this.getElement();
        String value = this.getCanonicalText();
        if (element instanceof AntStructuredElement) {
            return ((AntStructuredElement)element).computeAttributeValue(value);
        }
        return element.getAntProject().computeAttributeValue(value);
    }

    public PsiElement resolveInner() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getUnresolvedMessagePattern() {
        return CodeInsightBundle.message((String)"error.cannot.resolve.default.message", (Object[])new Object[0]);
    }
}

