/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl;

import com.intellij.lang.ant.psi.AntElementVisitor;
import com.intellij.lang.ant.psi.AntPresetDef;
import com.intellij.lang.ant.psi.AntProject;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.psi.impl.AntAllTasksContainerImpl;
import com.intellij.lang.ant.psi.impl.AntStructuredElementImpl;
import com.intellij.lang.ant.psi.introspection.AntAttributeType;
import com.intellij.lang.ant.psi.introspection.AntTypeDefinition;
import com.intellij.lang.ant.psi.introspection.AntTypeId;
import com.intellij.lang.ant.psi.introspection.impl.AntTypeDefinitionImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLock;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.StringBuilderSpinAllocator;
import java.util.HashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AntPresetDefImpl
extends AntAllTasksContainerImpl
implements AntPresetDef {
    @NonNls
    public static final String ANT_PRESETDEF_NAME = "AntPresetDef";
    private AntTypeDefinitionImpl myPresetDefinition;

    public AntPresetDefImpl(AntStructuredElement parent, XmlTag sourceElement, AntTypeDefinition definition) {
        super(parent, sourceElement, definition);
        this.invalidatePresetDefinition();
    }

    @Override
    public String toString() {
        return AntPresetDefImpl.createPresetDefClassName(this.getName());
    }

    @Override
    public void acceptAntElementVisitor(@NotNull AntElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntPresetDefImpl.acceptAntElementVisitor must not be null");
        }
        visitor.visitAntPresetDef(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createPresetDefClassName(String presetDefName) {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            builder.append(ANT_PRESETDEF_NAME);
            builder.append("[");
            builder.append(presetDefName);
            builder.append("]");
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    @Override
    public AntTypeDefinition getPresetDefinition() {
        return this.myPresetDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            super.clearCaches();
            this.clearClassesCache();
            this.getAntFile().clearCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearClassesCache() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (this.myPresetDefinition != null) {
                AntProject parent = this.getAntProject();
                if (parent != null) {
                    parent.unregisterCustomType(this.myPresetDefinition);
                }
                this.myPresetDefinition = null;
            }
        }
    }

    private void invalidatePresetDefinition() {
        AntProject parent;
        AntTypeDefinitionImpl extentedDef;
        this.myPresetDefinition = null;
        if (!this.hasNameElement()) {
            return;
        }
        String thisClassName = AntPresetDefImpl.createPresetDefClassName(this.getName());
        AntStructuredElementImpl extented = (AntStructuredElementImpl)PsiTreeUtil.getChildOfType((PsiElement)this, AntStructuredElementImpl.class);
        AntTypeId typeId = new AntTypeId(this.getName());
        if (extented != null && (extentedDef = (AntTypeDefinitionImpl)extented.getTypeDefinition()) != null) {
            this.myPresetDefinition = new AntTypeDefinitionImpl(typeId, thisClassName, extentedDef.isTask(), false, extentedDef.getAttributesMap(), extentedDef.getNestedElementsMap(), this);
        }
        if (this.myPresetDefinition == null) {
            this.myPresetDefinition = new AntTypeDefinitionImpl(typeId, thisClassName, false, false, new HashMap<String, AntAttributeType>(), new HashMap<AntTypeId, String>(), this);
        }
        if ((parent = this.getAntProject()) != null) {
            parent.registerCustomType(this.myPresetDefinition);
        }
    }
}

