/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl;

import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntNameIdentifier;
import com.intellij.lang.ant.psi.impl.AntElementImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class AntNameIdentifierImpl
extends AntElementImpl
implements AntNameIdentifier {
    private String myCachedName;
    private volatile long myModCount;

    public AntNameIdentifierImpl(AntElement parent, XmlAttributeValue sourceElement) {
        super(parent, (XmlElement)sourceElement);
    }

    @NotNull
    public XmlAttributeValue getSourceElement() {
        XmlAttributeValue xmlAttributeValue = (XmlAttributeValue)super.getSourceElement();
        if (xmlAttributeValue == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntNameIdentifierImpl.getSourceElement must not return null");
        }
        return xmlAttributeValue;
    }

    public TextRange getTextRange() {
        return this.getSourceElement().getValueTextRange();
    }

    public String getText() {
        return this.getName();
    }

    public int getTextOffset() {
        return this.getTextRange().getStartOffset();
    }

    public int getTextLength() {
        return this.getText().length();
    }

    public String getName() {
        return this.getIdentifierName();
    }

    @Override
    public String getIdentifierName() {
        long modificationCount;
        String name = this.myCachedName;
        PsiManager psiManager = this.getManager();
        long l = modificationCount = psiManager != null ? psiManager.getModificationTracker().getModificationCount() : this.myModCount;
        if (name != null && this.myModCount == modificationCount) {
            return name;
        }
        this.myModCount = modificationCount;
        this.myCachedName = name = this.getSourceElement().getValue();
        return name;
    }

    @Override
    public void setIdentifierName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntNameIdentifierImpl.setIdentifierName must not be null");
        }
        XmlAttribute attr = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)this.getSourceElement(), XmlAttribute.class, (boolean)true);
        if (attr != null) {
            attr.setValue(name);
        }
    }
}

