/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildModelBase;
import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.AntBuildTargetBase;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.impl.AntBuildTargetImpl;
import com.intellij.lang.ant.config.impl.BuildTask;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntProject;
import com.intellij.lang.ant.psi.AntTarget;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class AntBuildModelImpl
implements AntBuildModelBase {
    private final AntBuildFile myFile;

    public AntBuildModelImpl(AntBuildFile buildFile) {
        this.myFile = buildFile;
    }

    @Override
    @Nullable
    public String getDefaultTargetName() {
        AntProject project = this.getAntProject();
        AntTarget target = project == null ? null : project.getDefaultTarget();
        return target == null ? "" : target.getName();
    }

    @Override
    @Nullable
    public String getName() {
        AntProject project = this.getAntProject();
        return project != null ? project.getName() : null;
    }

    @Override
    public AntBuildTarget[] getTargets() {
        List<AntBuildTargetBase> list = this.getTargetsList();
        return list.toArray(new AntBuildTargetBase[list.size()]);
    }

    @Override
    public AntBuildTarget[] getFilteredTargets() {
        ArrayList<AntBuildTargetBase> filtered = new ArrayList<AntBuildTargetBase>();
        for (AntBuildTargetBase buildTarget : this.getTargetsList()) {
            if (!this.myFile.isTargetVisible(buildTarget)) continue;
            filtered.add(buildTarget);
        }
        return filtered.size() == 0 ? AntBuildTargetBase.EMPTY_ARRAY : (AntBuildTarget[])filtered.toArray(new AntBuildTargetBase[filtered.size()]);
    }

    @Override
    @Nullable
    public String getDefaultTargetActionId() {
        if (this.getDefaultTargetName() == null) {
            return null;
        }
        String modelName = this.getName();
        if (modelName == null || modelName.trim().length() == 0) {
            return null;
        }
        return AntConfiguration.getActionIdPrefix(this.getBuildFile().getProject()) + modelName;
    }

    @Override
    public AntBuildFileBase getBuildFile() {
        return (AntBuildFileBase)this.myFile;
    }

    @Override
    @Nullable
    public AntBuildTargetBase findTarget(final String name) {
        return (AntBuildTargetBase)ApplicationManager.getApplication().runReadAction((Computable)new Computable<AntBuildTargetBase>(){

            @Nullable
            public AntBuildTargetBase compute() {
                return AntBuildModelImpl.findTargetImpl(name, AntBuildModelImpl.this);
            }
        });
    }

    @Override
    @Nullable
    public BuildTask findTask(String targetName, String taskName) {
        AntBuildTargetBase buildTarget = this.findTarget(targetName);
        return buildTarget == null ? null : buildTarget.findTask(taskName);
    }

    @Override
    public AntProject getAntProject() {
        AntFile antFile = (AntFile)this.getBuildFile().getAntFile();
        return antFile != null ? antFile.getAntProject() : null;
    }

    @Override
    public boolean hasTargetWithActionId(String id) {
        List<AntBuildTargetBase> targetsList = this.getTargetsList();
        for (AntBuildTargetBase buildTarget : targetsList) {
            if (!id.equals(buildTarget.getActionId())) continue;
            return true;
        }
        return false;
    }

    private List<AntBuildTargetBase> getTargetsList() {
        return (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<AntBuildTargetBase>>(){

            public List<AntBuildTargetBase> compute() {
                return AntBuildModelImpl.getTargetListImpl(AntBuildModelImpl.this);
            }
        });
    }

    @Nullable
    private static AntBuildTargetBase findTargetImpl(String name, AntBuildModelImpl model) {
        List<AntBuildTargetBase> buildTargetBases = AntBuildModelImpl.getTargetListImpl(model);
        for (AntBuildTargetBase targetBase : buildTargetBases) {
            if (!Comparing.strEqual((String)targetBase.getName(), (String)name)) continue;
            return targetBase;
        }
        return null;
    }

    private static List<AntBuildTargetBase> getTargetListImpl(AntBuildModelBase model) {
        AntProject project = model.getAntProject();
        AntTarget[] targets = project == null ? AntTarget.EMPTY_ARRAY : project.getTargets();
        ArrayList<AntBuildTargetBase> list = new ArrayList<AntBuildTargetBase>(targets.length);
        VirtualFile sourceFile = model.getBuildFile().getVirtualFile();
        AntTarget defaultTarget = project != null ? project.getDefaultTarget() : null;
        for (AntTarget target : targets) {
            list.add(new AntBuildTargetImpl(target, model, sourceFile, false, target.equals(defaultTarget)));
        }
        if (project != null) {
            for (AntTarget target : project.getImportedTargets()) {
                AntProject antProject;
                PsiFile containingFile = target.getContainingFile();
                AntTarget fileDefaultTarget = containingFile instanceof AntFile ? ((antProject = ((AntFile)containingFile).getAntProject()) != null ? antProject.getDefaultTarget() : null) : null;
                list.add(new AntBuildTargetImpl(target, model, containingFile != null ? containingFile.getVirtualFile() : null, true, target.equals(fileDefaultTarget)));
            }
        }
        return list;
    }
}

