/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.lang.ant.AntSupport;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildModel;
import com.intellij.lang.ant.config.AntBuildModelBase;
import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.config.impl.AllJarsUnderDirEntry;
import com.intellij.lang.ant.config.impl.AntBuildFileClassLoaderHolder;
import com.intellij.lang.ant.config.impl.AntClasspathEntry;
import com.intellij.lang.ant.config.impl.AntInstallation;
import com.intellij.lang.ant.config.impl.AntReference;
import com.intellij.lang.ant.config.impl.BuildFileProperty;
import com.intellij.lang.ant.config.impl.ClassLoaderHolder;
import com.intellij.lang.ant.config.impl.CompositePropertyContainer;
import com.intellij.lang.ant.config.impl.GlobalAntConfiguration;
import com.intellij.lang.ant.config.impl.SinglePathEntry;
import com.intellij.lang.ant.config.impl.TargetFilter;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.NewInstanceFactory;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.BooleanProperty;
import com.intellij.util.config.ExternalizablePropertyContainer;
import com.intellij.util.config.IntProperty;
import com.intellij.util.config.ListProperty;
import com.intellij.util.config.StringProperty;
import com.intellij.util.config.ValueProperty;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntBuildFileImpl
implements AntBuildFileBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.ant.config.impl.AntBuildFileImpl");
    @NonNls
    private static final String USER_HOME = "user.home";
    @NonNls
    private static final String ANT_LIB = "/.ant/lib";
    public static final AbstractProperty<AntInstallation> ANT_INSTALLATION = new AbstractProperty<AntInstallation>(){

        public String getName() {
            return "$antInstallation";
        }

        public AntInstallation getDefault(AbstractProperty.AbstractPropertyContainer container) {
            return ((GlobalAntConfiguration)GlobalAntConfiguration.INSTANCE.get(container)).getBundledAnt();
        }

        public AntInstallation copy(AntInstallation value) {
            return value;
        }

        public AntInstallation get(AbstractProperty.AbstractPropertyContainer container) {
            if (container.hasProperty(ANT_REFERENCE)) {
                return (AntInstallation)RUN_WITH_ANT.get(container);
            }
            return ((GlobalAntConfiguration)GlobalAntConfiguration.INSTANCE.get(container)).getBundledAnt();
        }
    };
    public static final AbstractProperty<List<File>> ALL_CLASS_PATH = new AbstractProperty<List<File>>(){

        public String getName() {
            return "$allClasspath";
        }

        public List<File> getDefault(AbstractProperty.AbstractPropertyContainer container) {
            return this.get(container);
        }

        public List<File> get(AbstractProperty.AbstractPropertyContainer container) {
            ArrayList<File> classpath = new ArrayList<File>();
            this.collectClasspath(classpath, ADDITIONAL_CLASSPATH, container);
            AntInstallation antInstallation = (AntInstallation)ANT_INSTALLATION.get(container);
            if (antInstallation != null) {
                this.collectClasspath(classpath, AntInstallation.CLASS_PATH, antInstallation.getProperties());
            }
            return classpath;
        }

        private void collectClasspath(ArrayList<File> files, ListProperty<AntClasspathEntry> property, AbstractProperty.AbstractPropertyContainer container) {
            if (!container.hasProperty(property)) {
                return;
            }
            Iterator entries = property.getIterator(container);
            while (entries.hasNext()) {
                AntClasspathEntry entry = (AntClasspathEntry)entries.next();
                entry.addFilesTo(files);
            }
        }

        public void set(AbstractProperty.AbstractPropertyContainer container, List<File> files) {
            throw new UnsupportedOperationException(this.getName());
        }

        public List<File> copy(List<File> files) {
            return files;
        }
    };
    public static final BooleanProperty RUN_IN_BACKGROUND = new BooleanProperty("runInBackground", true);
    public static final IntProperty MAX_HEAP_SIZE = new IntProperty("maximumHeapSize", 128);
    public static final IntProperty MAX_STACK_SIZE = new IntProperty("maximumStackSize", 2);
    public static final BooleanProperty VERBOSE = new BooleanProperty("verbose", true);
    public static final BooleanProperty TREE_VIEW = new BooleanProperty("treeView", true);
    public static final BooleanProperty CLOSE_ON_NO_ERRORS = new BooleanProperty("viewClosedWhenNoErrors", false);
    public static final AbstractProperty<String> CUSTOM_JDK_NAME = new StringProperty("customJdkName", "");
    public static final ListProperty<TargetFilter> TARGET_FILTERS = ListProperty.create((String)"targetFilters");
    public static final ListProperty<BuildFileProperty> ANT_PROPERTIES = ListProperty.create((String)"properties");
    public static final AbstractProperty<String> ANT_COMMAND_LINE_PARAMETERS = new StringProperty("antCommandLine", "");
    public static final AbstractProperty<AntReference> ANT_REFERENCE = new ValueProperty("antReference", (Object)AntReference.PROJECT_DEFAULT);
    public static final ListProperty<AntClasspathEntry> ADDITIONAL_CLASSPATH = ListProperty.create((String)"additionalClassPath");
    public static final AbstractProperty<AntInstallation> RUN_WITH_ANT = new AbstractProperty<AntInstallation>(){

        public String getName() {
            return "$runWithAnt";
        }

        @Nullable
        public AntInstallation getDefault(AbstractProperty.AbstractPropertyContainer container) {
            return this.get(container);
        }

        @Nullable
        public AntInstallation get(AbstractProperty.AbstractPropertyContainer container) {
            return AntReference.findAnt(ANT_REFERENCE, container);
        }

        public AntInstallation copy(AntInstallation antInstallation) {
            return antInstallation;
        }
    };
    private final VirtualFile myVFile;
    private final Project myProject;
    private final AntConfigurationBase myAntConfiguration;
    private final ExternalizablePropertyContainer myWorkspaceOptions;
    private final ExternalizablePropertyContainer myProjectOptions;
    private final AbstractProperty.AbstractPropertyContainer myAllOptions;
    private final ClassLoaderHolder myClassloaderHolder;
    private boolean myExpandFirstTime = true;

    public AntBuildFileImpl(AntFile antFile, AntConfigurationBase configuration) {
        this.myVFile = antFile.getVirtualFile();
        this.myProject = antFile.getProject();
        this.myAntConfiguration = configuration;
        this.myWorkspaceOptions = new ExternalizablePropertyContainer();
        this.myWorkspaceOptions.registerProperty(RUN_IN_BACKGROUND);
        this.myWorkspaceOptions.registerProperty(CLOSE_ON_NO_ERRORS);
        this.myWorkspaceOptions.registerProperty(TREE_VIEW);
        this.myWorkspaceOptions.registerProperty(VERBOSE);
        this.myWorkspaceOptions.registerProperty(TARGET_FILTERS, "filter", NewInstanceFactory.fromClass(TargetFilter.class));
        this.myWorkspaceOptions.registerProperty((StringProperty)ANT_COMMAND_LINE_PARAMETERS);
        this.myWorkspaceOptions.rememberKey(RUN_WITH_ANT);
        this.myProjectOptions = new ExternalizablePropertyContainer();
        this.myProjectOptions.registerProperty(MAX_HEAP_SIZE);
        this.myProjectOptions.registerProperty(MAX_STACK_SIZE);
        this.myProjectOptions.registerProperty((StringProperty)CUSTOM_JDK_NAME);
        this.myProjectOptions.registerProperty(ANT_PROPERTIES, "property", NewInstanceFactory.fromClass(BuildFileProperty.class));
        this.myProjectOptions.registerProperty(ADDITIONAL_CLASSPATH, "entry", SinglePathEntry.EXTERNALIZER);
        this.myProjectOptions.registerProperty(ANT_REFERENCE, AntReference.EXTERNALIZER);
        this.myAllOptions = new CompositePropertyContainer(new AbstractProperty.AbstractPropertyContainer[]{this.myWorkspaceOptions, this.myProjectOptions, GlobalAntConfiguration.getInstance().getProperties(this.getProject())});
        this.myClassloaderHolder = new AntBuildFileClassLoaderHolder(this.myAllOptions);
    }

    public static List<File> getUserHomeLibraries() {
        ArrayList<File> classpath = new ArrayList<File>();
        String homeDir = System.getProperty(USER_HOME);
        new AllJarsUnderDirEntry(new File(homeDir, ANT_LIB)).addFilesTo(classpath);
        return classpath;
    }

    @Override
    @Nullable
    public String getPresentableName() {
        String name;
        AntBuildModel model = this.myAntConfiguration.getModelIfRegistered(this);
        String string = name = model != null ? model.getName() : null;
        if (name == null || name.trim().length() == 0) {
            name = this.myVFile.getName();
        }
        return name;
    }

    @Override
    @Nullable
    public String getName() {
        VirtualFile vFile = this.getVirtualFile();
        return vFile != null ? vFile.getName() : null;
    }

    @Override
    public AntBuildModelBase getModel() {
        return (AntBuildModelBase)this.myAntConfiguration.getModel(this);
    }

    @Override
    @Nullable
    public AntBuildModelBase getModelIfRegistered() {
        return (AntBuildModelBase)this.myAntConfiguration.getModelIfRegistered(this);
    }

    @Override
    public boolean isRunInBackground() {
        return RUN_IN_BACKGROUND.value(this.myAllOptions);
    }

    @Override
    public AntFile getAntFile() {
        PsiFile psiFile = this.myVFile.isValid() ? PsiManager.getInstance((Project)this.getProject()).findFile(this.myVFile) : null;
        return psiFile != null ? AntSupport.getAntFile(psiFile) : null;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myVFile;
    }

    @Override
    public AbstractProperty.AbstractPropertyContainer getAllOptions() {
        return this.myAllOptions;
    }

    @Override
    @Nullable
    public String getPresentableUrl() {
        VirtualFile file = this.getVirtualFile();
        return file == null ? null : file.getPresentableUrl();
    }

    @Override
    public boolean shouldExpand() {
        boolean expandFirstTime = this.myExpandFirstTime;
        this.myExpandFirstTime = false;
        return expandFirstTime;
    }

    @Override
    public boolean isTargetVisible(AntBuildTarget target) {
        TargetFilter filter = this.findFilter(target.getName());
        if (filter == null) {
            return target.isDefault() || target.getNotEmptyDescription() != null;
        }
        return filter.isVisible();
    }

    @Override
    public boolean exists() {
        VirtualFile file = this.getVirtualFile();
        return file != null && new File(file.getPath()).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateProperties() {
        AntBuildFileImpl antBuildFileImpl = this;
        synchronized (antBuildFileImpl) {
            HashMap targetByName = ContainerUtil.assignKeys(Arrays.asList(this.getModel().getTargets()).iterator(), (Convertor)new Convertor<AntBuildTarget, String>(){

                public String convert(AntBuildTarget target) {
                    return target.getName();
                }
            });
            targetByName.remove(null);
            ArrayList filters = TARGET_FILTERS.getModifiableList(this.myAllOptions);
            Iterator iterator = filters.iterator();
            while (iterator.hasNext()) {
                TargetFilter filter = (TargetFilter)iterator.next();
                String name = filter.getTargetName();
                if (name == null) {
                    iterator.remove();
                    continue;
                }
                AntBuildTarget target = (AntBuildTarget)targetByName.get(name);
                if (target != null) {
                    filter.updateDescription(target);
                    targetByName.remove(name);
                    continue;
                }
                iterator.remove();
            }
            for (AntBuildTarget target : targetByName.values()) {
                filters.add(TargetFilter.fromTarget(target));
            }
        }
    }

    @Override
    public void updateConfig() {
        this.basicUpdateConfig();
        DaemonCodeAnalyzer.getInstance((Project)this.getProject()).restart();
    }

    @Override
    public void setTreeView(boolean value) {
        TREE_VIEW.primSet(this.myAllOptions, value);
    }

    @Override
    public void setVerboseMode(boolean value) {
        VERBOSE.primSet(this.myAllOptions, value);
    }

    @Override
    public boolean isViewClosedWhenNoErrors() {
        return CLOSE_ON_NO_ERRORS.value(this.myAllOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readWorkspaceProperties(Element parentNode) throws InvalidDataException {
        AntBuildFileImpl antBuildFileImpl = this;
        synchronized (antBuildFileImpl) {
            this.myWorkspaceOptions.readExternal(parentNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeWorkspaceProperties(Element parentNode) throws WriteExternalException {
        AntBuildFileImpl antBuildFileImpl = this;
        synchronized (antBuildFileImpl) {
            this.myWorkspaceOptions.writeExternal(parentNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readProperties(Element parentNode) throws InvalidDataException {
        AntBuildFileImpl antBuildFileImpl = this;
        synchronized (antBuildFileImpl) {
            this.myProjectOptions.readExternal(parentNode);
            this.basicUpdateConfig();
            this.readWorkspaceProperties(parentNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeProperties(Element parentNode) throws WriteExternalException {
        AntBuildFileImpl antBuildFileImpl = this;
        synchronized (antBuildFileImpl) {
            this.myProjectOptions.writeExternal(parentNode);
        }
    }

    private void basicUpdateConfig() {
        AntFile antFile = this.getAntFile();
        if (antFile != null) {
            this.registerPropertiesInPsi(antFile);
            this.bindAnt();
            this.myClassloaderHolder.updateClasspath();
            antFile.clearCachesWithTypeDefinitions();
        }
    }

    private void registerPropertiesInPsi(AntFile antFile) {
        DataContext context = SimpleDataContext.getProjectContext((Project)this.myProject);
        MacroManager macroManager = MacroManager.getInstance();
        Iterator properties = ANT_PROPERTIES.getIterator(this.myAllOptions);
        antFile.clearExternalProperties();
        while (properties.hasNext()) {
            BuildFileProperty property = (BuildFileProperty)properties.next();
            try {
                String value = property.getPropertyValue();
                value = macroManager.expandSilentMarcos(value, true, context);
                value = macroManager.expandSilentMarcos(value, false, context);
                antFile.setExternalProperty(property.getPropertyName(), value);
            }
            catch (Macro.ExecutionCancelledException e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    private void bindAnt() {
        ANT_REFERENCE.set(this.getAllOptions(), (Object)((AntReference)ANT_REFERENCE.get(this.getAllOptions())).bind(GlobalAntConfiguration.getInstance()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private TargetFilter findFilter(String targetName) {
        List filters;
        AntBuildFileImpl antBuildFileImpl = this;
        synchronized (antBuildFileImpl) {
            filters = (List)TARGET_FILTERS.get(this.myAllOptions);
        }
        for (TargetFilter targetFilter : filters) {
            if (!Comparing.equal((String)targetName, (String)targetFilter.getTargetName())) continue;
            return targetFilter;
        }
        return null;
    }

    @NotNull
    public ClassLoader getClassLoader() {
        ClassLoader classLoader = this.myClassloaderHolder.getClassloader();
        if (classLoader == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/config/impl/AntBuildFileImpl.getClassLoader must not return null");
        }
        return classLoader;
    }
}

