/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.options;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.maddyhome.idea.copyright.options.LanguageOptions;
import com.maddyhome.idea.copyright.util.FileTypeUtil;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public class Options
implements JDOMExternalizable,
Cloneable {
    private Map<String, LanguageOptions> options = new TreeMap<String, LanguageOptions>();
    private static final String LANG_TEMPLATE = "__TEMPLATE__";
    private static final Logger logger = Logger.getInstance((String)Options.class.getName());

    public LanguageOptions getOptions(String name) {
        String lang = FileTypeUtil.getInstance().getFileTypeNameByName(name);
        LanguageOptions res = this.options.get(lang);
        if (res == null) {
            res = new LanguageOptions();
        }
        return res;
    }

    public LanguageOptions getTemplateOptions() {
        return this.getOptions(LANG_TEMPLATE);
    }

    public void setOptions(String name, LanguageOptions options) {
        String lang = FileTypeUtil.getInstance().getFileTypeNameByName(name);
        this.options.put(lang, options);
    }

    public void setTemplateOptions(LanguageOptions options) {
        this.setOptions(LANG_TEMPLATE, options);
    }

    @Nullable
    public LanguageOptions getMergedOptions(String name) {
        try {
            LanguageOptions lang = this.getOptions(name).clone();
            LanguageOptions temp = this.getTemplateOptions().clone();
            switch (lang.getFileTypeOverride()) {
                case 2: {
                    temp.setFileLocation(lang.getFileLocation());
                    temp.setFileTypeOverride(lang.getFileTypeOverride());
                    lang = temp;
                    break;
                }
            }
            return lang;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        logger.debug("readExternal()");
        List langs = element.getChildren("LanguageOptions");
        if (langs != null && langs.size() > 0) {
            for (int i = 0; i < langs.size(); ++i) {
                Element lang = (Element)langs.get(i);
                String name = lang.getAttributeValue("name");
                LanguageOptions opts = new LanguageOptions();
                opts.readExternal(lang);
                this.setOptions(name, opts);
            }
        } else {
            Element root = null;
            Element jOpts = element.getChild("JavaOptions");
            if (jOpts != null) {
                root = jOpts;
            } else {
                Element child = element.getChild("option");
                if (child != null && child.getAttribute("name") != null) {
                    root = element;
                }
            }
            if (root != null) {
                String lname = StdFileTypes.JAVA.getName();
                LanguageOptions opts = new LanguageOptions();
                opts.setFileTypeOverride(2);
                List children = root.getChildren("option");
                for (Object option : children) {
                    String name = ((Element)option).getAttributeValue("name");
                    String val = ((Element)option).getAttributeValue("value");
                    if ("body".equals(name) || !"location".equals(name)) continue;
                    opts.setFileLocation(Integer.parseInt(val));
                }
                this.setOptions(lname, opts);
            }
        }
        logger.debug("options=" + this);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        logger.debug("writeExternal()");
        for (String lang : this.options.keySet()) {
            LanguageOptions opts = this.options.get(lang);
            Element elem = new Element("LanguageOptions");
            elem.setAttribute("name", lang);
            element.addContent(elem);
            opts.writeExternal(elem);
        }
        logger.debug("options=" + this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Options options1 = (Options)o;
        return ((Object)this.options).equals(options1.options);
    }

    public int hashCode() {
        int result = ((Object)this.options).hashCode();
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Options");
        sb.append("{options=").append(this.options);
        sb.append('}');
        return sb.toString();
    }

    public Options clone() throws CloneNotSupportedException {
        Options res = (Options)super.clone();
        res.options = new TreeMap<String, LanguageOptions>();
        for (String lang : this.options.keySet()) {
            LanguageOptions opts = this.options.get(lang);
            res.options.put(lang, opts.clone());
        }
        return res;
    }
}

