/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.admin.Entries;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.util.BugLog;

final class EntriesDotLog {
    @NonNls
    private static final String ENTRY_ADDED = "A ";
    @NonNls
    private static final String ENTRY_REMOVED = "R ";

    EntriesDotLog() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readAndApply(File entriesDotLogFile, Entries entries) throws IOException {
        BugLog.getInstance().assertNotNull((Object)entriesDotLogFile);
        BugLog.getInstance().assertNotNull((Object)entries);
        if (!entriesDotLogFile.exists()) {
            return false;
        }
        BufferedReader reader = new BufferedReader(new FileReader(entriesDotLogFile));
        try {
            boolean entriesUpdated = false;
            String line = reader.readLine();
            while (line != null) {
                Entry entry;
                String entryLine;
                if (line.startsWith(ENTRY_ADDED)) {
                    entryLine = line.substring(ENTRY_ADDED.length());
                    entry = Entry.createEntryForLine((String)entryLine);
                    entries.addEntry(entry);
                    entriesUpdated = true;
                } else if (line.startsWith(ENTRY_REMOVED) && (entry = Entry.createEntryForLine((String)(entryLine = line.substring(ENTRY_REMOVED.length())))) != null) {
                    entries.removeEntry(entry.getFileName());
                    entriesUpdated = true;
                }
                line = reader.readLine();
            }
            boolean bl = entriesUpdated;
            return bl;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

