/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.projectView;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.uiDesigner.projectView.Form;
import org.jetbrains.annotations.NotNull;

public class FormRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        Form[] forms = (Form[])Form.DATA_KEY.getData(dataContext);
        return forms != null && forms.length == 1;
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/projectView/FormRenameHandler.invoke must not be null");
        }
        Form[] forms = (Form[])Form.DATA_KEY.getData(dataContext);
        if (forms == null || forms.length != 1) {
            return;
        }
        PsiClass boundClass = forms[0].getClassToBind();
        RefactoringActionHandlerFactory.getInstance().createRenameHandler().invoke(project, new PsiElement[]{boundClass}, dataContext);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/projectView/FormRenameHandler.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/uiDesigner/projectView/FormRenameHandler.invoke must not be null");
        }
        this.invoke(project, null, null, dataContext);
    }
}

