/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.componentTree;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.SyntaxHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeToolTipHandler;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.ErrorAnalyzer;
import com.intellij.uiDesigner.ErrorInfo;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.SimpleTransferable;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.actions.StartInplaceEditingAction;
import com.intellij.uiDesigner.componentTree.ButtonGroupDescriptor;
import com.intellij.uiDesigner.componentTree.ComponentPtr;
import com.intellij.uiDesigner.componentTree.ComponentPtrDescriptor;
import com.intellij.uiDesigner.componentTree.QuickFixManagerImpl;
import com.intellij.uiDesigner.componentTree.SuppressionDescriptor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.designSurface.ComponentDragObject;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.designSurface.ComponentItemDragObject;
import com.intellij.uiDesigner.designSurface.DraggedComponentList;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.designSurface.InsertComponentProcessor;
import com.intellij.uiDesigner.editor.UIFormEditor;
import com.intellij.uiDesigner.lw.LwInspectionSuppression;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.uiDesigner.quickFixes.QuickFixManager;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadErrorComponent;
import com.intellij.uiDesigner.radComponents.RadHSpacer;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.uiDesigner.radComponents.RadVSpacer;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComponentTree
extends Tree
implements DataProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.componentTree.ComponentTree");
    public static final DataKey<LwInspectionSuppression[]> LW_INSPECTION_SUPPRESSION_ARRAY_DATA_KEY = DataKey.create((String)LwInspectionSuppression.class.getName());
    private SimpleTextAttributes myBindingAttributes;
    private SimpleTextAttributes myClassAttributes;
    private SimpleTextAttributes myPackageAttributes;
    private SimpleTextAttributes myUnknownAttributes;
    private SimpleTextAttributes myTitleAttributes;
    private Map<HighlightSeverity, Map<SimpleTextAttributes, SimpleTextAttributes>> myHighlightAttributes;
    private GuiEditor myEditor;
    private UIFormEditor myFormEditor;
    private QuickFixManager myQuickFixManager;
    private RadComponent myDropTargetComponent;
    private final StartInplaceEditingAction myStartInplaceEditingAction;
    private final MyDeleteProvider myDeleteProvider;
    private final Icon myButtonGroupIcon;
    private final Icon myInspectionSuppressionIcon;
    @NonNls
    private static final String ourHelpID = "guiDesigner.uiTour.compsTree";
    private final Project myProject;

    public ComponentTree(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/componentTree/ComponentTree.<init> must not be null");
        }
        super((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.myDropTargetComponent = null;
        this.myDeleteProvider = new MyDeleteProvider();
        this.myButtonGroupIcon = IconLoader.getIcon((String)"/com/intellij/uiDesigner/icons/buttonGroup.png");
        this.myInspectionSuppressionIcon = IconLoader.getIcon((String)"/com/intellij/uiDesigner/icons/inspectionSuppression.png");
        this.myProject = project;
        this.setCellRenderer((TreeCellRenderer)((Object)new MyTreeCellRenderer()));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        TreeUtil.installActions((JTree)((Object)this));
        TreeToolTipHandler.install((JTree)((Object)this));
        PopupHandler.installPopupHandler((JComponent)((Object)this), (ActionGroup)((ActionGroup)ActionManager.getInstance().getAction("GuiDesigner.ComponentTreePopupMenu")), (String)"GuiDesigner.ComponentTreePopup", (ActionManager)ActionManager.getInstance());
        this.myStartInplaceEditingAction = new StartInplaceEditingAction(null);
        this.myStartInplaceEditingAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(113, 0)), (JComponent)((Object)this));
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.setDragEnabled(true);
            this.setTransferHandler(new TransferHandler(){

                @Override
                public int getSourceActions(JComponent c) {
                    return 3;
                }

                @Override
                protected Transferable createTransferable(JComponent c) {
                    return DraggedComponentList.pickupSelection(ComponentTree.this.myEditor, null);
                }
            });
            this.setDropTarget(new DropTarget((Component)((Object)this), new MyDropTargetListener()));
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/componentTree/ComponentTree.getProject must not return null");
        }
        return project;
    }

    public void initQuickFixManager(JViewport viewPort) {
        this.myQuickFixManager = new QuickFixManagerImpl(null, this, viewPort);
    }

    public void setEditor(GuiEditor editor) {
        this.myEditor = editor;
        this.myDeleteProvider.setEditor(editor);
        this.myQuickFixManager.setEditor(editor);
        this.myStartInplaceEditingAction.setEditor(editor);
    }

    public void refreshIntentionHint() {
        this.myQuickFixManager.refreshIntentionHint();
    }

    @Nullable
    public String getToolTipText(MouseEvent e) {
        ErrorInfo errorInfo;
        TreePath path = this.getPathForLocation(e.getX(), e.getY());
        RadComponent component = ComponentTree.getComponentFromPath(path);
        if (component != null && (errorInfo = ErrorAnalyzer.getErrorForComponent(component)) != null) {
            return errorInfo.myDescription;
        }
        return null;
    }

    @Nullable
    private static RadComponent getComponentFromPath(TreePath path) {
        if (path != null) {
            NodeDescriptor descriptor;
            ComponentPtr ptr;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            LOG.assertTrue(node != null);
            Object userObject = node.getUserObject();
            if (userObject instanceof ComponentPtrDescriptor && (ptr = (ComponentPtr)(descriptor = (NodeDescriptor)userObject).getElement()) != null && ptr.isValid()) {
                RadComponent component = ptr.getComponent();
                LOG.assertTrue(component != null);
                return component;
            }
        }
        return null;
    }

    @Nullable
    public RadComponent getSelectedComponent() {
        RadComponent[] selectedComponents = this.getSelectedComponents();
        return selectedComponents.length > 0 ? selectedComponents[0] : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public RadComponent[] getSelectedComponents() {
        RadComponent[] radComponentArray;
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            radComponentArray = RadComponent.EMPTY_ARRAY;
            if (RadComponent.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/componentTree/ComponentTree.getSelectedComponents must not return null");
            return radComponentArray;
        }
        ArrayList<RadComponent> result = new ArrayList<RadComponent>(paths.length);
        for (TreePath path : paths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            LOG.assertTrue(node != null);
            if (!(node.getUserObject() instanceof ComponentPtrDescriptor)) continue;
            ComponentPtrDescriptor descriptor = (ComponentPtrDescriptor)((Object)node.getUserObject());
            ComponentPtr ptr = (ComponentPtr)descriptor.getElement();
            LOG.assertTrue(ptr != null && ptr.isValid());
            result.add(ptr.getComponent());
        }
        radComponentArray = result.toArray(new RadComponent[result.size()]);
        if (radComponentArray != null) return radComponentArray;
        throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/componentTree/ComponentTree.getSelectedComponents must not return null");
    }

    public Object getData(String dataId) {
        PsiField[] fields;
        if (GuiEditor.DATA_KEY.is(dataId)) {
            return this.myEditor;
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.myDeleteProvider;
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.CUT_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.myEditor == null ? null : this.myEditor.getData(dataId);
        }
        if (LW_INSPECTION_SUPPRESSION_ARRAY_DATA_KEY.is(dataId)) {
            List<LwInspectionSuppression> elements = this.getSelectedElements(LwInspectionSuppression.class);
            return elements.size() == 0 ? null : elements.toArray(new LwInspectionSuppression[elements.size()]);
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return ourHelpID;
        }
        if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
            return this.myFormEditor;
        }
        if (!PlatformDataKeys.NAVIGATABLE.is(dataId)) {
            return null;
        }
        RadComponent selectedComponent = this.getSelectedComponent();
        if (selectedComponent == null) {
            return null;
        }
        String classToBind = this.myEditor.getRootContainer().getClassToBind();
        if (classToBind == null) {
            return null;
        }
        PsiClass aClass = FormEditingUtil.findClassToBind(this.myEditor.getModule(), classToBind);
        if (aClass == null) {
            return null;
        }
        if (selectedComponent instanceof RadRootContainer) {
            return EditSourceUtil.getDescriptor((PsiElement)aClass);
        }
        String binding = selectedComponent.getBinding();
        if (binding == null) {
            return null;
        }
        for (PsiField field : fields = aClass.getFields()) {
            if (!binding.equals(field.getName())) continue;
            return EditSourceUtil.getDescriptor((PsiElement)field);
        }
        return null;
    }

    public <T> List<T> getSelectedElements(Class<? extends T> elementClass) {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(paths.length);
        for (TreePath path : paths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            if (!(userObject instanceof NodeDescriptor) || !elementClass.isInstance(((NodeDescriptor)userObject).getElement())) continue;
            result.add(((NodeDescriptor)node.getUserObject()).getElement());
        }
        return result;
    }

    private SimpleTextAttributes getAttribute(@NotNull SimpleTextAttributes attrs, @Nullable HighlightDisplayLevel level) {
        SimpleTextAttributes result;
        if (attrs == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/componentTree/ComponentTree.getAttribute must not be null");
        }
        if (level == null) {
            return attrs;
        }
        Map<SimpleTextAttributes, SimpleTextAttributes> highlightMap = this.myHighlightAttributes.get(level.getSeverity());
        if (highlightMap == null) {
            highlightMap = new HashMap<SimpleTextAttributes, SimpleTextAttributes>();
            this.myHighlightAttributes.put(level.getSeverity(), highlightMap);
        }
        if ((result = highlightMap.get(attrs)) == null) {
            TextAttributesKey attrKey = SeverityRegistrar.getInstance((Project)this.myProject).getHighlightInfoTypeBySeverity(level.getSeverity()).getAttributesKey();
            TextAttributes textAttrs = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(attrKey);
            textAttrs = TextAttributes.merge((TextAttributes)attrs.toTextAttributes(), (TextAttributes)textAttrs);
            result = SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttrs);
            highlightMap.put(attrs, result);
        }
        return result;
    }

    public void setUI(TreeUI ui) {
        super.setUI(ui);
        this.myHighlightAttributes = new HashMap<HighlightSeverity, Map<SimpleTextAttributes, SimpleTextAttributes>>();
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes attributes = globalScheme.getAttributes(SyntaxHighlighterColors.STRING);
        this.myBindingAttributes = new SimpleTextAttributes(1, UIUtil.getTreeForeground());
        this.myClassAttributes = new SimpleTextAttributes(0, UIUtil.getTreeForeground());
        this.myPackageAttributes = new SimpleTextAttributes(0, Color.GRAY);
        this.myTitleAttributes = new SimpleTextAttributes(0, attributes.getForegroundColor());
        this.myUnknownAttributes = new SimpleTextAttributes(8, Color.RED);
    }

    public static Icon getComponentIcon(RadComponent component) {
        if (!(component instanceof RadErrorComponent)) {
            Palette palette = Palette.getInstance(component.getModule().getProject());
            ComponentItem item = palette.getItem(component.getComponentClassName());
            Icon icon = item != null ? item.getSmallIcon() : IconLoader.getIcon((String)"/com/intellij/uiDesigner/icons/unknown-small.png");
            return icon;
        }
        return IconLoader.getIcon((String)"/com/intellij/uiDesigner/icons/error-small.png");
    }

    public void setDropTargetComponent(RadComponent dropTargetComponent) {
        if (dropTargetComponent != this.myDropTargetComponent) {
            this.myDropTargetComponent = dropTargetComponent;
            this.repaint();
        }
    }

    public void setFormEditor(UIFormEditor formEditor) {
        this.myFormEditor = formEditor;
    }

    private static class MyDeleteProvider
    implements DeleteProvider {
        private GuiEditor myEditor;

        private MyDeleteProvider() {
        }

        public void setEditor(GuiEditor editor) {
            this.myEditor = editor;
        }

        public void deleteElement(DataContext dataContext) {
            if (this.myEditor != null) {
                LwInspectionSuppression[] suppressions = (LwInspectionSuppression[])LW_INSPECTION_SUPPRESSION_ARRAY_DATA_KEY.getData(dataContext);
                if (suppressions != null) {
                    if (!this.myEditor.ensureEditable()) {
                        return;
                    }
                    for (LwInspectionSuppression suppression : suppressions) {
                        this.myEditor.getRootContainer().removeInspectionSuppression(suppression);
                    }
                    this.myEditor.refreshAndSave(true);
                } else {
                    DeleteProvider baseProvider = (DeleteProvider)this.myEditor.getData(PlatformDataKeys.DELETE_ELEMENT_PROVIDER.getName());
                    if (baseProvider != null) {
                        baseProvider.deleteElement(dataContext);
                    }
                }
            }
        }

        public boolean canDeleteElement(DataContext dataContext) {
            if (this.myEditor != null) {
                LwInspectionSuppression[] suppressions = (LwInspectionSuppression[])LW_INSPECTION_SUPPRESSION_ARRAY_DATA_KEY.getData(dataContext);
                if (suppressions != null) {
                    return true;
                }
                DeleteProvider baseProvider = (DeleteProvider)this.myEditor.getData(PlatformDataKeys.DELETE_ELEMENT_PROVIDER.getName());
                if (baseProvider != null) {
                    return baseProvider.canDeleteElement(dataContext);
                }
            }
            return false;
        }
    }

    private final class MyDropTargetListener
    extends DropTargetAdapter {
        private MyDropTargetListener() {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            try {
                RadComponent dropTargetComponent = null;
                ComponentDragObject dragObject = null;
                DraggedComponentList dcl = DraggedComponentList.fromTransferable(dtde.getTransferable());
                if (dcl != null) {
                    dragObject = dcl;
                } else {
                    ComponentItem componentItem = SimpleTransferable.getData(dtde.getTransferable(), ComponentItem.class);
                    if (componentItem != null) {
                        dragObject = new ComponentItemDragObject(componentItem);
                    }
                }
                boolean canDrop = false;
                if (dragObject != null) {
                    TreePath path = ComponentTree.this.getPathForLocation((int)dtde.getLocation().getX(), (int)dtde.getLocation().getY());
                    RadComponent targetComponent = ComponentTree.getComponentFromPath(path);
                    if (path != null && targetComponent instanceof RadContainer) {
                        ComponentDropLocation dropLocation = ((RadContainer)targetComponent).getDropLocation(null);
                        canDrop = dropLocation.canDrop(dragObject);
                        if (dcl != null && FormEditingUtil.isDropOnChild(dcl, dropLocation)) {
                            canDrop = false;
                        }
                        if (canDrop) {
                            dropTargetComponent = targetComponent;
                            dtde.acceptDrag(dtde.getDropAction());
                        }
                    }
                }
                if (!canDrop) {
                    dtde.rejectDrag();
                }
                ComponentTree.this.setDropTargetComponent(dropTargetComponent);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            ComponentTree.this.setDropTargetComponent(null);
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            try {
                DraggedComponentList dcl = DraggedComponentList.fromTransferable(dtde.getTransferable());
                ComponentItem componentItem = SimpleTransferable.getData(dtde.getTransferable(), ComponentItem.class);
                if (dcl != null || componentItem != null) {
                    TreePath path = ComponentTree.this.getPathForLocation((int)dtde.getLocation().getX(), (int)dtde.getLocation().getY());
                    RadComponent targetComponent = ComponentTree.getComponentFromPath(path);
                    if (!ComponentTree.this.myEditor.ensureEditable()) {
                        return;
                    }
                    if (targetComponent instanceof RadContainer) {
                        ComponentDropLocation dropLocation = ((RadContainer)targetComponent).getDropLocation(null);
                        if (dcl != null) {
                            if (!FormEditingUtil.isDropOnChild(dcl, dropLocation)) {
                                int i;
                                RadComponent[] components = dcl.getComponents().toArray(new RadComponent[dcl.getComponents().size()]);
                                RadContainer[] originalParents = dcl.getOriginalParents();
                                GridConstraints[] originalConstraints = dcl.getOriginalConstraints();
                                for (i = 0; i < components.length; ++i) {
                                    originalParents[i].removeComponent(components[i]);
                                }
                                dropLocation.processDrop(ComponentTree.this.myEditor, components, null, dcl);
                                for (i = 0; i < originalConstraints.length; ++i) {
                                    if (!originalParents[i].getLayoutManager().isGrid()) continue;
                                    FormEditingUtil.deleteEmptyGridCells(originalParents[i], originalConstraints[i]);
                                }
                            }
                        } else {
                            new InsertComponentProcessor(ComponentTree.this.myEditor).processComponentInsert(componentItem, dropLocation);
                        }
                    }
                    ComponentTree.this.myEditor.refreshAndSave(true);
                }
                ComponentTree.this.setDropTargetComponent(null);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private final class MyTreeCellRenderer
    extends ColoredTreeCellRenderer {
        @NonNls
        private static final String SWING_PACKAGE = "javax.swing";

        private MyTreeCellRenderer() {
        }

        public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof ComponentPtrDescriptor) {
                ComponentPtrDescriptor descriptor = (ComponentPtrDescriptor)((Object)node.getUserObject());
                ComponentPtr ptr = (ComponentPtr)descriptor.getElement();
                if (ptr == null) {
                    return;
                }
                RadComponent component = ptr.getComponent();
                LOG.assertTrue(component != null);
                HighlightDisplayLevel level = ErrorAnalyzer.getHighlightDisplayLevel(ComponentTree.this.myProject, component);
                boolean hasText = false;
                String binding = component.getBinding();
                if (binding != null) {
                    this.append(binding, ComponentTree.this.getAttribute(ComponentTree.this.myBindingAttributes, level));
                    this.append(" : ", ComponentTree.this.getAttribute(ComponentTree.this.myClassAttributes, level));
                    hasText = true;
                } else {
                    String componentTitle = component.getComponentTitle();
                    if (componentTitle != null) {
                        this.append(componentTitle, ComponentTree.this.getAttribute(ComponentTree.this.myTitleAttributes, level));
                        this.append(" : ", ComponentTree.this.getAttribute(ComponentTree.this.myClassAttributes, level));
                        hasText = true;
                    }
                }
                String componentClassName = component.getComponentClassName();
                if (component instanceof RadVSpacer) {
                    this.append(UIDesignerBundle.message("component.vertical.spacer", new Object[0]), ComponentTree.this.getAttribute(ComponentTree.this.myClassAttributes, level));
                } else if (component instanceof RadHSpacer) {
                    this.append(UIDesignerBundle.message("component.horizontal.spacer", new Object[0]), ComponentTree.this.getAttribute(ComponentTree.this.myClassAttributes, level));
                } else if (component instanceof RadErrorComponent) {
                    RadErrorComponent c = (RadErrorComponent)component;
                    this.append(c.getErrorDescription(), ComponentTree.this.getAttribute(ComponentTree.this.myUnknownAttributes, level));
                } else if (component instanceof RadRootContainer) {
                    this.append(UIDesignerBundle.message("component.form", new Object[0]), ComponentTree.this.getAttribute(ComponentTree.this.myClassAttributes, level));
                    this.append("(", ComponentTree.this.getAttribute(ComponentTree.this.myPackageAttributes, level));
                    String classToBind = ((RadRootContainer)component).getClassToBind();
                    if (classToBind != null) {
                        this.append(classToBind, ComponentTree.this.getAttribute(ComponentTree.this.myPackageAttributes, level));
                    } else {
                        this.append(UIDesignerBundle.message("component.no.binding", new Object[0]), ComponentTree.this.getAttribute(ComponentTree.this.myPackageAttributes, level));
                    }
                    this.append(")", ComponentTree.this.getAttribute(ComponentTree.this.myPackageAttributes, level));
                } else {
                    SimpleTextAttributes classAttributes;
                    String packageName = null;
                    int pos = componentClassName.lastIndexOf(46);
                    if (pos >= 0) {
                        packageName = componentClassName.substring(0, pos);
                    }
                    SimpleTextAttributes simpleTextAttributes = classAttributes = hasText ? ComponentTree.this.myPackageAttributes : ComponentTree.this.myClassAttributes;
                    if (packageName != null) {
                        this.append(componentClassName.substring(packageName.length() + 1).replace('$', '.'), ComponentTree.this.getAttribute(classAttributes, level));
                        if (!packageName.equals(SWING_PACKAGE)) {
                            this.append(" (", ComponentTree.this.getAttribute(ComponentTree.this.myPackageAttributes, level));
                            this.append(packageName, ComponentTree.this.getAttribute(ComponentTree.this.myPackageAttributes, level));
                            this.append(")", ComponentTree.this.getAttribute(ComponentTree.this.myPackageAttributes, level));
                        }
                    } else {
                        this.append(componentClassName.replace('$', '.'), ComponentTree.this.getAttribute(classAttributes, level));
                    }
                }
                this.setIcon(ComponentTree.getComponentIcon(component));
                if (component == ComponentTree.this.myDropTargetComponent) {
                    this.setBorder(BorderFactory.createLineBorder(Color.BLUE, 1));
                } else {
                    this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                }
            } else if (node.getUserObject() != null) {
                String fragment = node.getUserObject().toString();
                if (fragment != null) {
                    this.append(fragment, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
                if (node.getUserObject() instanceof SuppressionDescriptor) {
                    this.setIcon(ComponentTree.this.myInspectionSuppressionIcon);
                } else if (node.getUserObject() instanceof ButtonGroupDescriptor) {
                    this.setIcon(ComponentTree.this.myButtonGroupIcon);
                }
            }
        }
    }
}

