/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uiDesigner.binding.FormClassIndex;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.text.CharArrayUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class FormReferencesSearcher
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(ReferencesSearch.SearchParameters p, Processor<PsiReference> consumer) {
        LocalSearchScope filterScope;
        if (!FormReferencesSearcher.scopeCanContainForms(p.getScope())) {
            return true;
        }
        final PsiElement refElement = p.getElementToSearch();
        PsiFile psiFile = (PsiFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile>(){

            public PsiFile compute() {
                if (!refElement.isValid()) {
                    return null;
                }
                return refElement.getContainingFile();
            }
        });
        if (psiFile == null) {
            return true;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return true;
        }
        Module module = ProjectRootManager.getInstance((Project)refElement.getProject()).getFileIndex().getModuleForFile(virtualFile);
        if (module == null) {
            return true;
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesScope((Module)module);
        LocalSearchScope localSearchScope = filterScope = p.getScope() instanceof LocalSearchScope ? (LocalSearchScope)p.getScope() : null;
        return refElement instanceof PsiPackage || !(refElement instanceof PsiClass ? !FormReferencesSearcher.processReferencesInUIForms(consumer, (PsiClass)refElement, scope, filterScope) : (refElement instanceof PsiEnumConstant ? !FormReferencesSearcher.processReferencesInUIForms(consumer, (PsiEnumConstant)refElement, scope, filterScope) : (refElement instanceof PsiField ? !FormReferencesSearcher.processReferencesInUIForms(consumer, (PsiField)refElement, scope, filterScope) : (refElement instanceof Property ? !FormReferencesSearcher.processReferencesInUIForms(consumer, (Property)refElement, scope, filterScope) : refElement instanceof PropertiesFile && !FormReferencesSearcher.processReferencesInUIForms(consumer, (PropertiesFile)refElement, scope, filterScope)))));
    }

    private static boolean scopeCanContainForms(SearchScope scope) {
        PsiElement[] elements;
        if (!(scope instanceof LocalSearchScope)) {
            return true;
        }
        LocalSearchScope localSearchScope = (LocalSearchScope)scope;
        for (PsiElement element : elements = localSearchScope.getScope()) {
            if (element instanceof PsiDirectory) {
                return true;
            }
            PsiFile file = element.getContainingFile();
            if (file.getFileType() != StdFileTypes.GUI_DESIGNER_FORM) continue;
            return true;
        }
        return false;
    }

    private static boolean processReferencesInUIForms(Processor<PsiReference> processor, PsiClass aClass, GlobalSearchScope scope, LocalSearchScope filterScope) {
        PsiManagerImpl manager = (PsiManagerImpl)aClass.getManager();
        String className = FormReferencesSearcher.getQualifiedName(aClass);
        return className == null || FormReferencesSearcher.processReferencesInUIFormsInner(className, (PsiElement)aClass, processor, scope, manager, filterScope);
    }

    public static String getQualifiedName(final PsiClass aClass) {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                if (!aClass.isValid()) {
                    return null;
                }
                return aClass.getQualifiedName();
            }
        });
    }

    private static boolean processReferencesInUIForms(Processor<PsiReference> processor, PsiEnumConstant enumConstant, GlobalSearchScope scope, LocalSearchScope filterScope) {
        PsiManagerImpl manager = (PsiManagerImpl)enumConstant.getManager();
        String className = enumConstant.getName();
        return className == null || FormReferencesSearcher.processReferencesInUIFormsInner(className, (PsiElement)enumConstant, processor, scope, manager, filterScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processReferencesInUIFormsInner(String name, PsiElement element, Processor<PsiReference> processor, GlobalSearchScope scope1, PsiManagerImpl manager, LocalSearchScope filterScope) {
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)manager.getProject()).intersectWith(scope1);
        manager.startBatchFilesProcessingMode();
        try {
            List<PsiFile> files = FormClassIndex.findFormsBoundToClass(manager.getProject(), name, scope);
            for (PsiFile file : files) {
                ProgressManager.checkCanceled();
                if (file.getFileType() != StdFileTypes.GUI_DESIGNER_FORM) continue;
                if (FormReferencesSearcher.processReferences(processor, file, name, element, filterScope)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            manager.finishBatchFilesProcessingMode();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processReferencesInUIForms(Processor<PsiReference> processor, PsiField field, GlobalSearchScope scope1, LocalSearchScope filterScope) {
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)field.getProject()).intersectWith(scope1);
        PsiManagerImpl manager = (PsiManagerImpl)field.getManager();
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return true;
        }
        String fieldName = field.getName();
        manager.startBatchFilesProcessingMode();
        try {
            List<PsiFile> files = FormClassIndex.findFormsBoundToClass(containingClass, scope);
            for (PsiFile file : files) {
                ProgressManager.checkCanceled();
                if (file.getFileType() != StdFileTypes.GUI_DESIGNER_FORM) continue;
                if (FormReferencesSearcher.processReferences(processor, file, fieldName, (PsiElement)field, filterScope)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            manager.finishBatchFilesProcessingMode();
        }
        return true;
    }

    private static boolean processReferences(Processor<PsiReference> processor, final PsiFile file, String name, final PsiElement element, final LocalSearchScope filterScope) {
        CharSequence chars = (CharSequence)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<CharSequence>(){

            public CharSequence compute() {
                if (filterScope != null) {
                    boolean isInScope = false;
                    for (PsiElement filterElement : filterScope.getScope()) {
                        if (!PsiTreeUtil.isAncestor((PsiElement)filterElement, (PsiElement)file, (boolean)false)) continue;
                        isInScope = true;
                        break;
                    }
                    if (!isInScope) {
                        return null;
                    }
                }
                return file.getViewProvider().getContents();
            }
        });
        if (chars == null) {
            return true;
        }
        int index = 0;
        int offset = name.lastIndexOf(46);
        while ((index = CharArrayUtil.indexOf((CharSequence)chars, (CharSequence)name, (int)index)) >= 0) {
            boolean isReferenceTo;
            final PsiReference ref = file.findReferenceAt(index + offset + 1);
            if (ref != null && (isReferenceTo = ((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    return ref.isReferenceTo(element);
                }
            })).booleanValue()) && !processor.process((Object)ref)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processReferencesInUIForms(Processor<PsiReference> processor, Property property, GlobalSearchScope globalSearchScope, LocalSearchScope filterScope) {
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)property.getProject()).intersectWith(globalSearchScope);
        PsiManagerImpl manager = (PsiManagerImpl)property.getManager();
        String name = property.getName();
        if (name == null) {
            return true;
        }
        manager.startBatchFilesProcessingMode();
        try {
            PsiFile[] files;
            List words = StringUtil.getWordsIn((String)name);
            if (words.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            HashSet fileSet = new HashSet();
            ApplicationManager.getApplication().runReadAction(new Runnable((Set)fileSet, manager, words, scope){
                final /* synthetic */ Set val$fileSet;
                final /* synthetic */ PsiManagerImpl val$manager;
                final /* synthetic */ List val$words;
                final /* synthetic */ GlobalSearchScope val$scope;
                {
                    this.val$fileSet = set;
                    this.val$manager = psiManagerImpl;
                    this.val$words = list;
                    this.val$scope = globalSearchScope;
                }

                @Override
                public void run() {
                    this.val$fileSet.addAll(Arrays.asList(this.val$manager.getCacheManager().getFilesWithWord((String)this.val$words.get(0), (short)16, this.val$scope, true)));
                    for (int i = 1; i < this.val$words.size(); ++i) {
                        this.val$fileSet.retainAll(Arrays.asList(this.val$manager.getCacheManager().getFilesWithWord((String)this.val$words.get(i), (short)16, this.val$scope, true)));
                    }
                }
            });
            for (PsiFile file : files = fileSet.toArray(new PsiFile[fileSet.size()])) {
                ProgressManager.checkCanceled();
                if (file.getFileType() != StdFileTypes.GUI_DESIGNER_FORM || FormReferencesSearcher.processReferences(processor, file, name, (PsiElement)property, filterScope)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            manager.finishBatchFilesProcessingMode();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processReferencesInUIForms(Processor<PsiReference> processor, PropertiesFile propFile, GlobalSearchScope globalSearchScope, LocalSearchScope filterScope) {
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)propFile.getProject()).intersectWith(globalSearchScope);
        PsiManagerImpl manager = (PsiManagerImpl)propFile.getManager();
        String baseName = propFile.getResourceBundle().getBaseName();
        manager.startBatchFilesProcessingMode();
        try {
            PsiFile[] files;
            for (PsiFile file : files = manager.getCacheManager().getFilesWithWord(baseName, (short)16, scope, true)) {
                ProgressManager.checkCanceled();
                if (file.getFileType() != StdFileTypes.GUI_DESIGNER_FORM || FormReferencesSearcher.processReferences(processor, file, baseName, (PsiElement)propFile, filterScope)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            manager.finishBatchFilesProcessingMode();
        }
        return true;
    }
}

