/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.binding.FormClassIndex;
import com.intellij.uiDesigner.editor.UIFormEditor;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.util.Icons;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoundIconRenderer
extends GutterIconRenderer {
    private final PsiElement myElement;
    private Icon myIcon;

    public BoundIconRenderer(PsiElement field) {
        ComponentItem item;
        String qName;
        PsiClass componentClass;
        PsiType type;
        this.myElement = field;
        if (this.myElement instanceof PsiField && (type = ((PsiField)this.myElement).getType()) instanceof PsiClassType && (componentClass = ((PsiClassType)type).resolve()) != null && (qName = componentClass.getQualifiedName()) != null && (item = Palette.getInstance(this.myElement.getProject()).getItem(qName)) != null) {
            this.myIcon = item.getIcon();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Icon getIcon() {
        Icon icon;
        if (this.myIcon != null) {
            icon = this.myIcon;
            if (icon == null) throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/binding/BoundIconRenderer.getIcon must not return null");
            return icon;
        }
        icon = Icons.UI_FORM_ICON;
        if (icon != null) return icon;
        throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/binding/BoundIconRenderer.getIcon must not return null");
    }

    public boolean isNavigateAction() {
        return true;
    }

    @Nullable
    public AnAction getClickAction() {
        return new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                List formFiles = BoundIconRenderer.this.getBoundFormFiles();
                if (formFiles.size() > 0) {
                    VirtualFile virtualFile = ((PsiFile)formFiles.get(0)).getVirtualFile();
                    if (virtualFile == null) {
                        return;
                    }
                    Project project = BoundIconRenderer.this.myElement.getProject();
                    FileEditor[] editors = FileEditorManager.getInstance((Project)project).openFile(virtualFile, true);
                    if (BoundIconRenderer.this.myElement instanceof PsiField) {
                        for (FileEditor editor : editors) {
                            if (!(editor instanceof UIFormEditor)) continue;
                            ((UIFormEditor)editor).selectComponent(((PsiField)BoundIconRenderer.this.myElement).getName());
                        }
                    }
                }
            }
        };
    }

    @Nullable
    public String getTooltipText() {
        List<PsiFile> formFiles = this.getBoundFormFiles();
        if (formFiles.size() > 0) {
            return BoundIconRenderer.composeText(formFiles);
        }
        return super.getTooltipText();
    }

    private List<PsiFile> getBoundFormFiles() {
        List<PsiFile> formFiles = Collections.emptyList();
        PsiClass aClass = this.myElement instanceof PsiField ? ((PsiField)this.myElement).getContainingClass() : (PsiClass)this.myElement;
        if (aClass != null && aClass.getQualifiedName() != null) {
            formFiles = FormClassIndex.findFormsBoundToClass(aClass);
        }
        return formFiles;
    }

    private static String composeText(List<PsiFile> formFiles) {
        StringBuilder result = new StringBuilder("<html><body>");
        result.append(UIDesignerBundle.message("ui.is.bound.header", new Object[0]));
        String sep = "";
        for (PsiFile file : formFiles) {
            result.append(sep);
            sep = "<br>";
            result.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            result.append(file.getName());
        }
        result.append("</body></html>");
        return result.toString();
    }
}

