/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.util.IconLoader;
import com.intellij.uiDesigner.CaptionSelection;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import org.jetbrains.annotations.NonNls;

public abstract class RowColumnAction
extends AnAction {
    private final String myColumnText;
    private final String myColumnIcon;
    private final String myRowText;
    private final String myRowIcon;

    public RowColumnAction(String columnText, @NonNls String columnIcon, String rowText, @NonNls String rowIcon) {
        this.myColumnText = columnText;
        this.myColumnIcon = columnIcon;
        this.myRowText = rowText;
        this.myRowIcon = rowIcon;
    }

    public void actionPerformed(AnActionEvent e) {
        GuiEditor editor = FormEditingUtil.getEditorFromContext(e.getDataContext());
        CaptionSelection selection = (CaptionSelection)CaptionSelection.DATA_KEY.getData(e.getDataContext());
        if (editor == null || selection == null || !editor.ensureEditable()) {
            return;
        }
        this.actionPerformed(selection);
        selection.getContainer().revalidate();
        editor.refreshAndSave(true);
    }

    protected abstract void actionPerformed(CaptionSelection var1);

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        CaptionSelection selection = (CaptionSelection)CaptionSelection.DATA_KEY.getData(e.getDataContext());
        if (selection == null) {
            presentation.setEnabled(false);
        } else {
            presentation.setEnabled(selection.getContainer() != null && selection.getFocusedIndex() >= 0);
            if (!selection.isRow()) {
                presentation.setText(this.myColumnText);
                if (this.myColumnIcon != null) {
                    presentation.setIcon(IconLoader.getIcon((String)this.myColumnIcon));
                }
            } else {
                presentation.setText(this.myRowText);
                if (this.myRowIcon != null) {
                    presentation.setIcon(IconLoader.getIcon((String)this.myRowIcon));
                }
            }
        }
    }
}

