/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.LoaderFactory;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.editor.UIFormEditor;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.radComponents.RadErrorComponent;

public class ReloadCustomComponentsAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        FileEditor[] fileEditors;
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        LoaderFactory.getInstance(project).clearClassLoaderCache();
        for (FileEditor editor : fileEditors = FileEditorManager.getInstance((Project)project).getAllEditors()) {
            if (!(editor instanceof UIFormEditor)) continue;
            ((UIFormEditor)editor).getEditor().readFromFile(true);
        }
    }

    public void update(AnActionEvent e) {
        GuiEditor editor = FormEditingUtil.getActiveEditor(e.getDataContext());
        e.getPresentation().setVisible(editor != null && ReloadCustomComponentsAction.haveCustomComponents(editor));
    }

    private static boolean haveCustomComponents(GuiEditor editor) {
        if (editor.isFormInvalid()) {
            return true;
        }
        final Ref result = new Ref();
        FormEditingUtil.iterate(editor.getRootContainer(), new FormEditingUtil.ComponentVisitor(){

            public boolean visit(IComponent component) {
                if (component instanceof RadErrorComponent || !component.getComponentClassName().startsWith("javax.swing")) {
                    result.set((Object)Boolean.TRUE);
                    return false;
                }
                return true;
            }
        });
        return !result.isNull();
    }
}

