/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner;

import com.intellij.ProjectTopics;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Pair;
import com.intellij.reference.SoftReference;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.util.messages.MessageBus;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringDescriptorManager {
    private final Module myModule;
    private final Map<Pair<Locale, String>, SoftReference<PropertiesFile>> myPropertiesFileCache = new HashMap<Pair<Locale, String>, SoftReference<PropertiesFile>>();

    public StringDescriptorManager(Module module, MessageBus bus) {
        this.myModule = module;
        bus.connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void beforeRootsChange(ModuleRootEvent event) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void rootsChanged(ModuleRootEvent event) {
                Map map = StringDescriptorManager.this.myPropertiesFileCache;
                synchronized (map) {
                    StringDescriptorManager.this.myPropertiesFileCache.clear();
                }
            }
        });
    }

    public static StringDescriptorManager getInstance(Module module) {
        return (StringDescriptorManager)ModuleServiceManager.getService((Module)module, StringDescriptorManager.class);
    }

    @Nullable
    public String resolve(@NotNull RadComponent component, @Nullable StringDescriptor descriptor) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/StringDescriptorManager.resolve must not be null");
        }
        RadRootContainer root = (RadRootContainer)FormEditingUtil.getRoot(component);
        Locale locale = root != null ? root.getStringDescriptorLocale() : null;
        return this.resolve(descriptor, locale);
    }

    @Nullable
    public String resolve(@Nullable StringDescriptor descriptor, @Nullable Locale locale) {
        String value;
        if (descriptor == null) {
            return null;
        }
        if (descriptor.getValue() != null) {
            return descriptor.getValue();
        }
        Property prop = this.resolveToProperty(descriptor, locale);
        if (prop != null && (value = prop.getUnescapedValue()) != null) {
            return value;
        }
        return "[" + descriptor.getKey() + " / " + descriptor.getBundleName() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property resolveToProperty(@NotNull StringDescriptor descriptor, @Nullable Locale locale) {
        Property propertyByKey;
        PropertiesFile propertiesFile;
        SoftReference<PropertiesFile> propertiesFileRef;
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/StringDescriptorManager.resolveToProperty must not be null");
        }
        String propFileName = descriptor.getDottedBundleName();
        Pair cacheKey = new Pair((Object)locale, (Object)propFileName);
        Map<Pair<Locale, String>, SoftReference<PropertiesFile>> map = this.myPropertiesFileCache;
        synchronized (map) {
            propertiesFileRef = this.myPropertiesFileCache.get(cacheKey);
        }
        PropertiesFile propertiesFile2 = propertiesFile = propertiesFileRef == null ? null : (PropertiesFile)propertiesFileRef.get();
        if (propertiesFile == null || !propertiesFile.isValid()) {
            propertiesFile = PropertiesUtil.getPropertiesFile((String)propFileName, (Module)this.myModule, (Locale)locale);
            Map<Pair<Locale, String>, SoftReference<PropertiesFile>> map2 = this.myPropertiesFileCache;
            synchronized (map2) {
                this.myPropertiesFileCache.put((Pair<Locale, String>)cacheKey, (SoftReference<PropertiesFile>)new SoftReference((Object)propertiesFile));
            }
        }
        if (propertiesFile != null && (propertyByKey = propertiesFile.findPropertyByKey(descriptor.getKey())) != null) {
            return propertyByKey;
        }
        return null;
    }
}

